/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.tsproviders.utils;

import ec.tss.TsAsyncMode;
import ec.tss.tsproviders.DataSource;
import ec.tss.tsproviders.IDataSourceLoader;
import ec.tss.tsproviders.utils.AbstractDataSourceProvider;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;

public abstract class AbstractDataSourceLoader<DATA, BEAN>
extends AbstractDataSourceProvider<DATA>
implements IDataSourceLoader {
    public AbstractDataSourceLoader(Logger logger, String providerName, TsAsyncMode asyncMode) {
        super(logger, providerName, asyncMode);
    }

    @Override
    protected DATA loadFromDataSource(DataSource key) throws Exception {
        return this.loadFromBean(this.decodeBean(key));
    }

    protected abstract @NonNull DATA loadFromBean(@NonNull BEAN var1) throws Exception;

    public abstract BEAN newBean();

    public abstract BEAN decodeBean(DataSource var1) throws IllegalArgumentException;

    @Override
    public boolean open(DataSource dataSource) {
        return this.support.open(dataSource);
    }

    @Override
    public boolean close(DataSource dataSource) {
        if (this.support.close(dataSource)) {
            this.cache.invalidate((Object)dataSource);
            return true;
        }
        return false;
    }

    @Override
    public void closeAll() {
        this.support.closeAll();
    }
}

