/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.tsproviders.utils;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import ec.tss.TsAsyncMode;
import ec.tss.TsCollectionInformation;
import ec.tss.TsInformation;
import ec.tss.TsInformationType;
import ec.tss.TsMoniker;
import ec.tss.tsproviders.DataSet;
import ec.tss.tsproviders.DataSource;
import ec.tss.tsproviders.IDataSourceListener;
import ec.tss.tsproviders.IDataSourceProvider;
import ec.tss.tsproviders.utils.AbstractTsProvider;
import ec.tss.tsproviders.utils.DataSourceSupport;
import ec.tss.tsproviders.utils.IConstraint;
import ec.tstoolkit.MetaData;
import ec.tstoolkit.timeseries.simplets.TsData;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;

public abstract class AbstractDataSourceProvider<DATA>
extends AbstractTsProvider
implements IDataSourceProvider {
    protected final LoadingCache<DataSource, DATA> cache = this.createCache();
    protected final DataSourceSupport support;

    public AbstractDataSourceProvider(Logger logger, String providerName, TsAsyncMode asyncMode) {
        super(logger, providerName, asyncMode);
        this.support = DataSourceSupport.create(providerName, logger);
    }

    protected abstract @NonNull DATA loadFromDataSource(@NonNull DataSource var1) throws Exception;

    protected @NonNull CacheBuilder<Object, Object> createCacheBuilder() {
        return CacheBuilder.newBuilder().softValues();
    }

    private LoadingCache<DataSource, DATA> createCache() {
        return this.createCacheBuilder().build(new CacheLoader<DataSource, DATA>(){

            public DATA load(DataSource key) throws Exception {
                return AbstractDataSourceProvider.this.loadFromDataSource(key);
            }
        });
    }

    @Override
    public void reload(DataSource dataSource) throws IllegalArgumentException {
        this.cache.invalidate((Object)dataSource);
        this.support.reload(dataSource);
    }

    @Override
    public List<DataSource> getDataSources() {
        return this.support.getDataSources();
    }

    @Override
    public void addDataSourceListener(IDataSourceListener listener) {
        this.support.addDataSourceListener(listener);
    }

    @Override
    public void removeDataSourceListener(IDataSourceListener listener) {
        this.support.removeDataSourceListener(listener);
    }

    @Override
    public TsMoniker toMoniker(DataSet dataSet) throws IllegalArgumentException {
        return this.support.toMoniker(dataSet);
    }

    @Override
    public TsMoniker toMoniker(DataSource dataSource) throws IllegalArgumentException {
        return this.support.toMoniker(dataSource);
    }

    @Override
    public DataSet toDataSet(TsMoniker moniker) throws IllegalArgumentException {
        return this.support.toDataSet(moniker);
    }

    @Override
    public DataSource toDataSource(TsMoniker moniker) throws IllegalArgumentException {
        return this.support.toDataSource(moniker);
    }

    @Override
    public void clearCache() {
        this.cache.invalidateAll();
    }

    @Override
    public boolean queryTsCollection(TsMoniker moniker, TsInformationType type) {
        Objects.requireNonNull(moniker, "Moniker cannot be null");
        Objects.requireNonNull(type, "Type cannot be null");
        return this.support.checkQuietly(moniker) && super.queryTsCollection(moniker, type);
    }

    @Override
    public boolean queryTs(TsMoniker moniker, TsInformationType type) {
        Objects.requireNonNull(moniker, "Moniker cannot be null");
        Objects.requireNonNull(type, "Type cannot be null");
        return this.support.checkQuietly(moniker) && super.queryTs(moniker, type);
    }

    @Override
    protected boolean process(TsCollectionInformation info) {
        DataSource dataSource = this.toDataSource(info.moniker);
        if (this.support.checkQuietly(dataSource, new IConstraint[0])) {
            try {
                this.fillCollection(info, dataSource);
                return true;
            }
            catch (Exception ex) {
                return this.support.reportException(info, ex, this::getDisplayName);
            }
        }
        DataSet dataSet = this.toDataSet(info.moniker);
        if (this.support.checkQuietly(dataSet, DataSet.Kind.COLLECTION)) {
            try {
                this.fillCollection(info, dataSet);
                return true;
            }
            catch (Exception ex) {
                return this.support.reportException(info, ex, this::getDisplayName);
            }
        }
        this.logger.warn("Invalid moniker '{}'", (Object)info.moniker.getId());
        return false;
    }

    @Override
    protected boolean process(TsInformation info) {
        DataSet dataSet = this.toDataSet(info.moniker);
        if (this.support.checkQuietly(dataSet, DataSet.Kind.SERIES)) {
            try {
                this.fillSeries(info, dataSet);
                return true;
            }
            catch (Exception ex) {
                return this.support.reportException(info, ex, this::getDisplayName);
            }
        }
        this.logger.warn("Invalid moniker '{}'", (Object)info.moniker.getId());
        return false;
    }

    protected abstract void fillCollection(@NonNull TsCollectionInformation var1, @NonNull DataSource var2) throws IOException;

    protected abstract void fillCollection(@NonNull TsCollectionInformation var1, @NonNull DataSet var2) throws IOException;

    protected abstract void fillSeries(@NonNull TsInformation var1, @NonNull DataSet var2) throws IOException;

    protected @NonNull TsInformation newTsInformation(@NonNull DataSet dataSet, @NonNull TsInformationType type) {
        return new TsInformation(this.getDisplayName(dataSet), this.toMoniker(dataSet), type);
    }

    @Deprecated
    protected @NonNull TsInformation newTsInformation(@NonNull DataSet dataSet, @Nullable TsData data, @Nullable MetaData metaData) {
        TsInformation result = this.newTsInformation(dataSet, data);
        result.metaData = metaData;
        return result;
    }

    @Deprecated
    protected @NonNull TsInformation newTsInformation(@NonNull DataSet dataSet, @Nullable TsData data) {
        TsInformation result = new TsInformation(this.getDisplayName(dataSet), this.toMoniker(dataSet), TsInformationType.All);
        result.data = data;
        return result;
    }
}

