/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.tsproviders.utils;

import ec.tss.ITsProvider;
import ec.tss.TsAsyncMode;
import ec.tss.TsCollectionInformation;
import ec.tss.TsFactory;
import ec.tss.TsInformation;
import ec.tss.TsInformationType;
import ec.tss.TsMoniker;
import ec.tss.tsproviders.utils.AsyncRequests;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.LockSupport;
import org.slf4j.Logger;

public abstract class AbstractTsProvider
implements ITsProvider {
    protected final Logger logger;
    protected final String providerName;
    protected final TsAsyncMode asyncMode;
    protected final AsyncRequests asyncRequests;
    protected final RequestsHandler2 requestsHandler;

    public AbstractTsProvider(Logger logger, String providerName, TsAsyncMode asyncMode) {
        this.logger = logger;
        this.providerName = providerName;
        this.asyncMode = asyncMode;
        this.asyncRequests = new AsyncRequests();
        if (this.asyncMode != TsAsyncMode.None) {
            this.requestsHandler = new RequestsHandler2();
            this.requestsHandler.start();
        } else {
            this.requestsHandler = null;
        }
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public String getSource() {
        return this.providerName;
    }

    @Override
    public void clearCache() {
    }

    @Override
    public void dispose() {
        if (this.asyncMode != TsAsyncMode.None) {
            this.requestsHandler.stop();
            this.asyncRequests.clear();
        }
        this.clearCache();
    }

    @Override
    public TsAsyncMode getAsyncMode() {
        return this.asyncMode;
    }

    @Override
    public boolean queryTsCollection(TsMoniker moniker, TsInformationType type) {
        if (this.asyncMode == TsAsyncMode.None) {
            return false;
        }
        if (type == TsInformationType.None) {
            this.asyncRequests.removeTsCollection(moniker, TsInformationType.All);
        } else {
            boolean empty = this.asyncRequests.isEmpty();
            this.asyncRequests.addTsCollection(moniker, type);
            if (empty) {
                this.requestsHandler.unpark();
            }
        }
        return true;
    }

    @Override
    public boolean queryTs(TsMoniker moniker, TsInformationType type) {
        if (this.asyncMode == TsAsyncMode.None) {
            return false;
        }
        if (type == TsInformationType.None) {
            this.asyncRequests.removeTs(moniker, TsInformationType.All);
        } else {
            boolean empty = this.asyncRequests.isEmpty();
            this.asyncRequests.addTs(moniker, type);
            if (empty) {
                this.requestsHandler.unpark();
            }
        }
        return true;
    }

    @Override
    public final boolean get(TsCollectionInformation info) {
        if (this.asyncMode != TsAsyncMode.None) {
            this.asyncRequests.removeTsCollection(info.moniker, info.type);
        }
        return this.process(info);
    }

    @Override
    public final boolean get(TsInformation info) {
        if (this.asyncMode != TsAsyncMode.None) {
            this.asyncRequests.removeTs(info.moniker, info.type);
        }
        return this.process(info);
    }

    protected abstract boolean process(TsCollectionInformation var1);

    protected abstract boolean process(TsInformation var1);

    protected class RequestsHandler2
    implements Runnable {
        final Thread requestsThread;
        final AtomicBoolean end = new AtomicBoolean(false);

        RequestsHandler2() {
            this.requestsThread = new Thread(this);
            this.requestsThread.setDaemon(true);
        }

        @Override
        public void run() {
            while (!this.end.get()) {
                TsInformation srequest;
                TsCollectionInformation crequest = AbstractTsProvider.this.asyncRequests.nextTsCollection();
                if (crequest != null && TsFactory.instance.isTsCollectionAlive(crequest.moniker)) {
                    AbstractTsProvider.this.process(crequest);
                    TsFactory.instance.update(crequest);
                }
                if ((srequest = AbstractTsProvider.this.asyncRequests.nextTs()) != null && TsFactory.instance.isTsAlive(srequest.moniker)) {
                    AbstractTsProvider.this.process(srequest);
                    TsFactory.instance.update(srequest);
                }
                if (srequest != null || crequest != null) continue;
                LockSupport.park();
            }
        }

        void start() {
            this.requestsThread.start();
        }

        void stop() {
            if (AbstractTsProvider.this.asyncRequests.isEmpty()) {
                LockSupport.unpark(this.requestsThread);
            }
            this.end.set(true);
        }

        void unpark() {
            LockSupport.unpark(this.requestsThread);
        }

        void park() {
            LockSupport.park(this.requestsThread);
        }
    }
}

