/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.tsproviders.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import net.jcip.annotations.ThreadSafe;
import org.checkerframework.checker.nullness.qual.NonNull;

@ThreadSafe
public abstract class ByteArrayConverter {
    private static final AtomicReference<ByteArrayConverter> INSTANCE = new AtomicReference<ByteArrayConverter>(ByteArrayConverter.getDefault());

    public static final @NonNull ByteArrayConverter getInstance() {
        return INSTANCE.get();
    }

    public static final void setInstance(@NonNull ByteArrayConverter s) throws IllegalArgumentException {
        INSTANCE.set(ByteArrayConverter.check(Objects.requireNonNull(s)));
    }

    public @NonNull byte[] fromDoubleArray(@NonNull double[] input) {
        int pos = 0;
        byte[] result = new byte[input.length * 8];
        for (int i = 0; i < input.length; ++i) {
            long bits = Double.doubleToLongBits(input[i]);
            result[pos++] = (byte)(bits >>> 56);
            result[pos++] = (byte)(bits >>> 48);
            result[pos++] = (byte)(bits >>> 40);
            result[pos++] = (byte)(bits >>> 32);
            result[pos++] = (byte)(bits >>> 24);
            result[pos++] = (byte)(bits >>> 16);
            result[pos++] = (byte)(bits >>> 8);
            result[pos++] = (byte)bits;
        }
        return result;
    }

    public @NonNull double[] toDoubleArray(@NonNull byte[] input) {
        int pos = 0;
        double[] result = new double[input.length / 8];
        for (int i = 0; i < result.length; ++i) {
            long bits = (((long)input[pos++] & 0xFFL) << 56) + (((long)input[pos++] & 0xFFL) << 48) + (((long)input[pos++] & 0xFFL) << 40) + (((long)input[pos++] & 0xFFL) << 32) + (((long)input[pos++] & 0xFFL) << 24) + (((long)input[pos++] & 0xFFL) << 16) + (((long)input[pos++] & 0xFFL) << 8) + ((long)input[pos++] & 0xFFL);
            result[i] = Double.longBitsToDouble(bits);
        }
        return result;
    }

    public static final @NonNull ByteArrayConverter getDefault() {
        return DefaultConverter.INSTANCE;
    }

    public static final @NonNull ByteArrayConverter getDeflate(int level, boolean nowrap) throws IllegalArgumentException {
        return new DeflateConverter(level, nowrap);
    }

    private static ByteArrayConverter check(ByteArrayConverter converter) throws IllegalArgumentException {
        try {
            double[] v1 = new double[]{};
            double[] v2 = new double[]{3.14, Double.NaN, Double.MIN_VALUE, Double.MAX_VALUE};
            if (Arrays.equals(v1, converter.toDoubleArray(converter.fromDoubleArray(v1))) && Arrays.equals(v2, converter.toDoubleArray(converter.fromDoubleArray(v2)))) {
                return converter;
            }
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Invalid byte array converter", ex);
        }
        throw new IllegalArgumentException("Invalid byte array converter");
    }

    private static final class DefaultConverter
    extends ByteArrayConverter {
        private static final DefaultConverter INSTANCE = new DefaultConverter();

        private DefaultConverter() {
        }
    }

    private static final class DeflateConverter
    extends ByteArrayConverter {
        private final int level;
        private final boolean nowrap;

        public DeflateConverter(int level, boolean nowrap) throws IllegalArgumentException {
            if ((level < 0 || level > 9) && level != -1) {
                throw new IllegalArgumentException("invalid compression level");
            }
            this.level = level;
            this.nowrap = nowrap;
        }

        @Override
        public byte[] fromDoubleArray(double[] input) {
            byte[] byArray;
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            try {
                try (DeflaterOutputStream deflater = new DeflaterOutputStream((OutputStream)result, new Deflater(this.level, this.nowrap), 512);){
                    deflater.write(super.fromDoubleArray(input));
                }
                byArray = result.toByteArray();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        result.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
            result.close();
            return byArray;
        }

        /*
         * Exception decompiling
         */
        @Override
        public double[] toDoubleArray(byte[] input) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

