/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.tsproviders.utils;

import com.google.common.base.Strings;
import ec.tss.tsproviders.utils.Formatters;
import ec.tss.tsproviders.utils.Parsers;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class DataFormat {
    public static final DataFormat DEFAULT = DataFormat.of(null, null, null);
    public static final DataFormat ROOT = DataFormat.of(Locale.ROOT, null, null);
    public static final String SEP = " ~ ";
    private final @Nullable Locale locale;
    private final @NonNull String datePattern;
    private final @NonNull String numberPattern;

    public static @NonNull DataFormat of(@Nullable Locale locale, @Nullable String datePattern, @Nullable String numberPattern) {
        return new DataFormat(locale, Strings.nullToEmpty((String)datePattern), Strings.nullToEmpty((String)numberPattern), null);
    }

    private DataFormat(Locale locale, String datePattern, String numberPattern, Void fake) {
        this.locale = locale;
        this.datePattern = datePattern;
        this.numberPattern = numberPattern;
    }

    public @NonNull String getNumberPattern() {
        return this.numberPattern;
    }

    public @NonNull String getDatePattern() {
        return this.datePattern;
    }

    public @Nullable Locale getLocale() {
        return this.locale;
    }

    public @NonNull String getLocaleString() {
        return this.locale != null ? this.locale.toString() : "";
    }

    public String toString() {
        return this.getLocaleString() + SEP + this.datePattern + SEP + this.numberPattern;
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof DataFormat && this.equals((DataFormat)obj);
    }

    private boolean equals(DataFormat that) {
        return Objects.equals(this.locale, that.locale) && this.datePattern.equals(that.datePattern) && this.numberPattern.equals(that.numberPattern);
    }

    public int hashCode() {
        return Objects.hash(this.locale, this.datePattern, this.numberPattern);
    }

    public @NonNull Formatters.Formatter<Date> dateFormatter() {
        try {
            return Formatters.onDateFormat(this.newDateFormat());
        }
        catch (IllegalArgumentException ex) {
            return Formatters.onNull();
        }
    }

    public @NonNull Parsers.Parser<Date> dateParser() {
        try {
            return Parsers.onDateFormat(this.newDateFormat());
        }
        catch (IllegalArgumentException ex) {
            return Parsers.onNull();
        }
    }

    public @NonNull Formatters.Formatter<Number> numberFormatter() {
        try {
            return Formatters.onNumberFormat(this.newNumberFormat());
        }
        catch (IllegalArgumentException ex) {
            return Formatters.onNull();
        }
    }

    public @NonNull Parsers.Parser<Number> numberParser() {
        try {
            return Parsers.onNumberFormat(this.newNumberFormat());
        }
        catch (IllegalArgumentException ex) {
            return Parsers.onNull();
        }
    }

    public @NonNull DateFormat newDateFormat() throws IllegalArgumentException {
        DateFormat result = !this.datePattern.isEmpty() ? new SimpleDateFormat(this.datePattern, this.getLocaleOrDefault()) : SimpleDateFormat.getDateInstance(2, this.getLocaleOrDefault());
        result.setLenient(this.datePattern.isEmpty() && this.locale == null);
        return result;
    }

    public @NonNull NumberFormat newNumberFormat() throws IllegalArgumentException {
        NumberFormat result = !this.numberPattern.isEmpty() ? new DecimalFormat(this.numberPattern, DecimalFormatSymbols.getInstance(this.getLocaleOrDefault())) : NumberFormat.getInstance(this.getLocaleOrDefault());
        return result;
    }

    private Locale getLocaleOrDefault() {
        return this.locale != null ? this.locale : Locale.getDefault(Locale.Category.FORMAT);
    }

    @Deprecated
    public DataFormat(@Nullable Locale locale, @Nullable String datePattern) {
        this(locale, datePattern, "", null);
    }

    @Deprecated
    public DataFormat(@Nullable Locale locale, @Nullable String datePattern, @Nullable String numberPattern) {
        this(locale, Strings.nullToEmpty((String)datePattern), Strings.nullToEmpty((String)numberPattern), null);
    }

    @Deprecated
    public static @NonNull DataFormat create(@Nullable String locale, @Nullable String datePattern) {
        return DataFormat.create(locale, datePattern, null);
    }

    @Deprecated
    public static @NonNull DataFormat create(@Nullable String locale, @Nullable String datePattern, @Nullable String numberPattern) {
        return DataFormat.of(locale != null ? (Locale)Parsers.localeParser().parseValue(locale).orElse(null) : null, datePattern, numberPattern);
    }

    @Deprecated
    public static @NonNull Parsers.Parser<Locale> localeParser() {
        return Parsers.localeParser();
    }

    @Deprecated
    public static @NonNull Locale toLocale(@NonNull String str) throws IllegalArgumentException {
        Objects.requireNonNull(str);
        Locale result = (Locale)Parsers.localeParser().parse(str);
        if (result == null) {
            throw new IllegalArgumentException("Invalid locale format: " + str);
        }
        return result;
    }

    @Deprecated
    public @Nullable String previewDate() {
        try {
            return this.newDateFormat().format(new Date());
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    @Deprecated
    public static @NonNull DateFormat newDateFormat(@Nullable String datePattern, @Nullable Locale locale) throws IllegalArgumentException {
        return DataFormat.of(locale, datePattern, null).newDateFormat();
    }

    @Deprecated
    public static @NonNull NumberFormat newNumberFormat(@Nullable Locale locale) {
        return DataFormat.of(locale, null, null).newNumberFormat();
    }
}

