/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.tsproviders.utils;

import ec.tss.tsproviders.DataSource;
import ec.tss.tsproviders.IDataSourceListener;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.helpers.NOPLogger;

public class DataSourceEventSupport {
    protected final Logger logger;
    protected final Set<IDataSourceListener> listeners;

    public static @NonNull DataSourceEventSupport create() {
        return DataSourceEventSupport.create((Logger)NOPLogger.NOP_LOGGER);
    }

    public static @NonNull DataSourceEventSupport create(@NonNull Logger logger) {
        Set weakHashSet = Collections.newSetFromMap(new WeakHashMap());
        return new DataSourceEventSupport(logger, Collections.synchronizedSet(weakHashSet));
    }

    @Deprecated
    public DataSourceEventSupport(@NonNull Logger logger, @NonNull Set<IDataSourceListener> listeners) {
        this.logger = logger;
        this.listeners = listeners;
    }

    public @NonNull Logger getLogger() {
        return this.logger;
    }

    public void add(@NonNull IDataSourceListener listener) {
        this.listeners.add(Objects.requireNonNull(listener));
    }

    public void remove(@NonNull IDataSourceListener listener) {
        this.listeners.remove(Objects.requireNonNull(listener));
    }

    public void fireOpened(@NonNull DataSource dataSource) {
        this.listeners.forEach(o -> {
            try {
                o.opened(dataSource);
            }
            catch (Exception ex) {
                this.logger.warn("While sending open event", (Throwable)ex);
            }
        });
    }

    public void fireClosed(@NonNull DataSource dataSource) {
        this.listeners.forEach(o -> {
            try {
                o.closed(dataSource);
            }
            catch (Exception ex) {
                this.logger.warn("While sending close event", (Throwable)ex);
            }
        });
    }

    public void fireAllClosed(@NonNull String providerName) {
        this.listeners.forEach(o -> {
            try {
                o.allClosed(providerName);
            }
            catch (Exception ex) {
                this.logger.warn("While sending closeall event", (Throwable)ex);
            }
        });
    }

    public void fireChanged(@NonNull DataSource dataSource) {
        this.listeners.forEach(o -> {
            try {
                o.changed(dataSource);
            }
            catch (Exception ex) {
                this.logger.warn("While sending change event", (Throwable)ex);
            }
        });
    }
}

