/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.tsproviders.utils;

import ec.tss.TsMoniker;
import ec.tss.tsproviders.DataSet;
import ec.tss.tsproviders.DataSource;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class DataSourcePreconditions {
    private DataSourcePreconditions() {
    }

    public static @NonNull DataSource checkProvider(@NonNull String providerName, @NonNull DataSource dataSource) throws IllegalArgumentException {
        DataSourcePreconditions.checkProvider(providerName, dataSource.getProviderName());
        return dataSource;
    }

    public static @NonNull DataSet checkProvider(@NonNull String providerName, @NonNull DataSet dataSet) throws IllegalArgumentException {
        DataSourcePreconditions.checkProvider(providerName, dataSet.getDataSource().getProviderName());
        return dataSet;
    }

    public static @NonNull TsMoniker checkProvider(@NonNull String providerName, @NonNull TsMoniker moniker) throws IllegalArgumentException {
        DataSourcePreconditions.checkProvider(providerName, moniker.getSource());
        return moniker;
    }

    private static void checkProvider(@NonNull String expected, @Nullable String found) throws IllegalArgumentException {
        if (!expected.equals(found)) {
            throw new IllegalArgumentException("Invalid provider name; expected: '" + expected + "' found: '" + found + "'");
        }
    }
}

