/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.tsproviders.utils;

import com.google.common.base.Strings;
import com.google.common.cache.LoadingCache;
import ec.tss.TsCollectionInformation;
import ec.tss.TsInformation;
import ec.tss.TsMoniker;
import ec.tss.tsproviders.DataSet;
import ec.tss.tsproviders.DataSource;
import ec.tss.tsproviders.HasDataMoniker;
import ec.tss.tsproviders.HasDataSourceMutableList;
import ec.tss.tsproviders.HasFilePaths;
import ec.tss.tsproviders.IDataSourceListener;
import ec.tss.tsproviders.utils.DataSourceEventSupport;
import ec.tss.tsproviders.utils.IConstraint;
import ec.tss.tsproviders.utils.IFormatter;
import ec.tss.tsproviders.utils.OptionalTsData;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.utilities.Files2;
import ec.tstoolkit.utilities.GuavaCaches;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;

public class DataSourceSupport
implements HasDataSourceMutableList,
HasDataMoniker,
HasFilePaths {
    protected final String providerName;
    protected final Set<DataSource> dataSources;
    protected final List<DataSource> dataSourcesAsList;
    protected final DataSourceEventSupport eventSupport;
    protected final IConstraint<String> providerNameConstraint;
    private final HasFilePaths filePathsSupport;

    public static @NonNull DataSourceSupport create(@NonNull String providerName, @NonNull Logger logger) {
        return new DataSourceSupport(providerName, new LinkedHashSet<DataSource>(), DataSourceEventSupport.create(logger));
    }

    public DataSourceSupport(@NonNull String providerName, @NonNull Set<DataSource> dataSources, @NonNull DataSourceEventSupport eventSupport) {
        this.providerName = providerName;
        this.dataSources = dataSources;
        this.dataSourcesAsList = new ArrayList<DataSource>(dataSources);
        this.eventSupport = eventSupport;
        this.providerNameConstraint = DataSourceSupport.onProviderName(providerName);
        this.filePathsSupport = HasFilePaths.of();
    }

    public @NonNull String getProviderName() {
        return this.providerName;
    }

    public @NonNull DataSourceEventSupport getEventSupport() {
        return this.eventSupport;
    }

    public boolean checkQuietly(@Nullable TsMoniker moniker) {
        if (moniker == null) {
            return false;
        }
        return this.doCheckQuietly(this.providerNameConstraint, moniker.getSource());
    }

    public @NonNull DataSource check(@NonNull DataSource dataSource, IConstraint<DataSource> ... constraints) throws IllegalArgumentException {
        this.doCheck(this.providerNameConstraint, dataSource.getProviderName());
        for (IConstraint<DataSource> o : constraints) {
            this.doCheck(o, dataSource);
        }
        return dataSource;
    }

    public boolean checkQuietly(@Nullable DataSource dataSource, IConstraint<DataSource> ... constraints) {
        if (dataSource == null) {
            return false;
        }
        if (!this.doCheckQuietly(this.providerNameConstraint, dataSource.getProviderName())) {
            return false;
        }
        for (IConstraint<DataSource> o : constraints) {
            if (this.doCheckQuietly(o, dataSource)) continue;
            return false;
        }
        return true;
    }

    public @NonNull DataSet check(@NonNull DataSet dataSet, IConstraint<DataSet> ... constraints) throws IllegalArgumentException {
        this.check(dataSet.getDataSource(), new IConstraint[0]);
        for (IConstraint<DataSet> o : constraints) {
            this.doCheck(o, dataSet);
        }
        return dataSet;
    }

    public boolean checkQuietly(@Nullable DataSet dataSet, IConstraint<DataSet> ... constraints) {
        if (dataSet == null) {
            return false;
        }
        if (!this.checkQuietly(dataSet.getDataSource(), new IConstraint[0])) {
            return false;
        }
        for (IConstraint<DataSet> o : constraints) {
            if (this.doCheckQuietly(o, dataSet)) continue;
            return false;
        }
        return true;
    }

    public <T> @NonNull T checkBean(@NonNull Object bean, final Class<T> clazz) {
        Objects.requireNonNull(bean);
        this.doCheck(new IConstraint<Object>(){

            @Override
            public String check(Object t) {
                return clazz.isInstance(t) ? null : "Not valid bean";
            }
        }, bean);
        return (T)bean;
    }

    <T> void doCheck(@NonNull IConstraint<T> constraint, @NonNull T value) throws IllegalArgumentException {
        String message = constraint.check(value);
        if (message != null) {
            this.eventSupport.logger.debug(message);
            throw new IllegalArgumentException(message);
        }
    }

    <T> boolean doCheckQuietly(@NonNull IConstraint<T> constraint, @NonNull T value) {
        String message = constraint.check(value);
        if (message != null) {
            this.eventSupport.logger.debug(message);
            return false;
        }
        return true;
    }

    @Override
    public void reload(DataSource dataSource) throws IllegalArgumentException {
        this.check(dataSource, new IConstraint[0]);
        this.eventSupport.fireChanged(dataSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean open(DataSource dataSource) {
        this.check(dataSource, new IConstraint[0]);
        Set<DataSource> set = this.dataSources;
        synchronized (set) {
            if (this.dataSources.add(dataSource)) {
                this.dataSourcesAsList.add(dataSource);
                this.eventSupport.fireOpened(dataSource);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean close(DataSource dataSource) {
        this.check(dataSource, new IConstraint[0]);
        Set<DataSource> set = this.dataSources;
        synchronized (set) {
            if (this.dataSources.remove(dataSource)) {
                this.dataSourcesAsList.remove(dataSource);
                this.eventSupport.fireClosed(dataSource);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeAll() {
        Set<DataSource> set = this.dataSources;
        synchronized (set) {
            this.dataSources.clear();
            this.dataSourcesAsList.clear();
            this.eventSupport.fireAllClosed(this.providerName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DataSource> getDataSources() {
        Set<DataSource> set = this.dataSources;
        synchronized (set) {
            return Collections.unmodifiableList(this.dataSourcesAsList);
        }
    }

    @Override
    public void addDataSourceListener(IDataSourceListener listener) {
        this.eventSupport.add(listener);
    }

    @Override
    public void removeDataSourceListener(IDataSourceListener listener) {
        this.eventSupport.remove(listener);
    }

    @Override
    public TsMoniker toMoniker(DataSet dataSet) throws IllegalArgumentException {
        this.check(dataSet, new IConstraint[0]);
        return new TsMoniker(this.providerName, DataSet.uriFormatter().formatValueAsString(dataSet).get());
    }

    @Override
    public TsMoniker toMoniker(DataSource dataSource) throws IllegalArgumentException {
        this.check(dataSource, new IConstraint[0]);
        return new TsMoniker(this.providerName, DataSource.uriFormatter().formatValueAsString(dataSource).get());
    }

    @Override
    public DataSet toDataSet(TsMoniker moniker) {
        this.doCheck(this.providerNameConstraint, moniker.getSource());
        String id = moniker.getId();
        DataSet result = (DataSet)DataSet.uriParser().parse(id);
        return result != null ? result : (DataSet)DataSet.xmlParser().parse(id);
    }

    @Override
    public DataSource toDataSource(TsMoniker moniker) {
        this.doCheck(this.providerNameConstraint, moniker.getSource());
        String id = moniker.getId();
        DataSource result = (DataSource)DataSource.uriParser().parse(id);
        return result != null ? result : (DataSource)DataSource.xmlParser().parse(id);
    }

    @Override
    public File[] getPaths() {
        return this.filePathsSupport.getPaths();
    }

    @Override
    public void setPaths(File[] paths) {
        this.filePathsSupport.setPaths(paths);
    }

    @Override
    public File resolveFilePath(File file) throws FileNotFoundException {
        return this.getRealFile(file);
    }

    public @NonNull File getRealFile(@NonNull File file) throws FileNotFoundException {
        return this.filePathsSupport.resolveFilePath(file);
    }

    @Deprecated
    public @NonNull String getDisplayName(@NonNull IOException exception) throws IllegalArgumentException {
        String message = exception.getMessage();
        return !Strings.isNullOrEmpty((String)message) ? message : exception.getClass().getSimpleName();
    }

    @Deprecated
    public @NonNull TsInformation fillSeries(@NonNull TsInformation info, @NonNull OptionalTsData data) {
        return this.fillSeries(info, data, true);
    }

    public @NonNull TsInformation fillSeries(@NonNull TsInformation info, @NonNull OptionalTsData data, boolean cleanExtremities) {
        if (!data.isPresent()) {
            info.data = null;
            info.invalidDataCause = data.getCause();
        } else {
            TsData tmp = data.get();
            info.data = cleanExtremities && DataSourceSupport.hasMissingValuesAtExtremities(tmp) ? tmp.cleanExtremities() : tmp;
            info.invalidDataCause = null;
        }
        return info;
    }

    @Deprecated
    public @NonNull TsInformation fillSeries(@NonNull TsInformation info, @NonNull Exception exception) {
        this.reportException(info, exception, Throwable::getMessage);
        return info;
    }

    public boolean reportException(@NonNull TsInformation info, @NonNull Exception ex, @NonNull IFormatter<? super IOException> formatter) {
        this.eventSupport.logger.info("Failed to get series", (Throwable)ex);
        info.data = null;
        info.invalidDataCause = ex instanceof IOException ? formatter.formatAsString((IOException)ex) : ex.getMessage();
        return false;
    }

    @Deprecated
    public @NonNull TsCollectionInformation fillCollection(@NonNull TsCollectionInformation info, @NonNull Exception exception) {
        this.reportException(info, exception, Throwable::getMessage);
        return info;
    }

    public boolean reportException(@NonNull TsCollectionInformation info, @NonNull Exception ex, @NonNull IFormatter<? super IOException> formatter) {
        this.eventSupport.logger.info("Failed to get collection", (Throwable)ex);
        info.invalidDataCause = ex instanceof IOException ? formatter.formatAsString((IOException)ex) : ex.getMessage();
        return false;
    }

    public <DATA> @NonNull DATA getValue(@NonNull LoadingCache<DataSource, DATA> cache, @NonNull DataSource key) throws IOException {
        this.check(key, new IConstraint[0]);
        return (DATA)GuavaCaches.getOrThrowIOException(cache, (Object)key);
    }

    public static @NonNull File getRealFile(@NonNull File[] paths, @NonNull File file) throws FileNotFoundException {
        File result = Files2.getAbsoluteFile((File[])paths, (File)file);
        if (result == null) {
            throw new FileNotFoundException("Relative file '" + file.getPath() + "' outside paths");
        }
        if (!result.exists()) {
            throw new FileNotFoundException(result.getPath());
        }
        return result;
    }

    private static boolean hasMissingValuesAtExtremities(@NonNull TsData data) {
        return !data.isEmpty() && (data.isMissing(0) || data.isMissing(data.getLength() - 1));
    }

    public static @NonNull IConstraint<String> onProviderName(final @NonNull String providerName) {
        return new IConstraint<String>(){

            @Override
            public String check(String t) {
                return providerName.equals(t) ? null : "Invalid provider name";
            }
        };
    }
}

