/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.tsproviders.utils;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import ec.tss.tsproviders.utils.IFormatter;
import ec.tstoolkit.design.UtilityClass;
import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@UtilityClass(value={IFormatter.class})
public final class Formatters {
    private static final Formatter<File> FILE_FORMATTER = new Adapter<File>(nbbrd.io.text.Formatter.onFile());
    private static final Formatter<Charset> CHARSET_FORMATTER = new Adapter<Charset>(nbbrd.io.text.Formatter.onCharset());
    private static final Formatter<double[]> DOUBLE_ARRAY_FORMATTER = new Adapter<double[]>(nbbrd.io.text.Formatter.onDoubleArray());
    private static final Formatter<?> OBJECT_TO_STRING_FORMATTER = new Adapter(nbbrd.io.text.Formatter.onObjectToString());
    private static final Formatter<String[]> STRING_ARRAY_FORMATTER = new Adapter<String[]>(nbbrd.io.text.Formatter.onStringArray());

    private Formatters() {
    }

    public static <T> @Nullable CharSequence formatFirstNotNull(@NonNull T value, @NonNull Iterable<? extends IFormatter<T>> formatters) {
        Objects.requireNonNull(value);
        for (IFormatter<T> o : formatters) {
            CharSequence result = o.format(value);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static <T> @NonNull Formatter<T> firstNotNull(IFormatter<T> ... formatters) {
        return Formatters.firstNotNull(ImmutableList.copyOf((Object[])formatters));
    }

    public static <T> @NonNull Formatter<T> firstNotNull(@NonNull ImmutableList<? extends IFormatter<T>> formatters) {
        return new Wrapper(o -> Formatters.formatFirstNotNull(o, formatters));
    }

    public static <T> @NonNull Formatter<T> onJAXB(@NonNull Class<T> classToBeFormatted, boolean formattedOutput) {
        try {
            return Formatters.onJAXB(JAXBContext.newInstance((Class[])new Class[]{classToBeFormatted}), formattedOutput);
        }
        catch (JAXBException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static <T> @NonNull Formatter<T> onJAXB(@NonNull JAXBContext context, boolean formattedOutput) {
        try {
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)formattedOutput);
            return Formatters.onJAXB(marshaller);
        }
        catch (JAXBException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static <T> @NonNull Formatter<T> onJAXB(final @NonNull Marshaller marshaller) {
        return new FailSafeFormatter<T>(){

            @Override
            protected CharSequence doFormat(T value) throws Exception {
                StringWriter result = new StringWriter();
                marshaller.marshal(value, (Writer)result);
                return result.toString();
            }
        };
    }

    public static @NonNull Formatter<Date> onDateFormat(@NonNull DateFormat dateFormat) {
        return new Adapter<Date>(nbbrd.io.text.Formatter.onDateFormat((DateFormat)dateFormat));
    }

    public static @NonNull Formatter<Number> onNumberFormat(@NonNull NumberFormat numberFormat) {
        return new Adapter<Number>(nbbrd.io.text.Formatter.onNumberFormat((NumberFormat)numberFormat));
    }

    public static <T> @NonNull Formatter<T> onNull() {
        return new Adapter(nbbrd.io.text.Formatter.onNull());
    }

    public static <T> @NonNull Formatter<T> ofInstance(@Nullable CharSequence instance) {
        return new Adapter(nbbrd.io.text.Formatter.onConstant((CharSequence)instance));
    }

    public static @NonNull Formatter<File> fileFormatter() {
        return FILE_FORMATTER;
    }

    public static @NonNull Formatter<Integer> intFormatter() {
        return OBJECT_TO_STRING_FORMATTER;
    }

    public static @NonNull Formatter<Long> longFormatter() {
        return OBJECT_TO_STRING_FORMATTER;
    }

    public static @NonNull Formatter<Double> doubleFormatter() {
        return OBJECT_TO_STRING_FORMATTER;
    }

    public static @NonNull Formatter<Boolean> boolFormatter() {
        return OBJECT_TO_STRING_FORMATTER;
    }

    public static @NonNull Formatter<Character> charFormatter() {
        return OBJECT_TO_STRING_FORMATTER;
    }

    public static @NonNull Formatter<Charset> charsetFormatter() {
        return CHARSET_FORMATTER;
    }

    public static <T extends Enum<T>> @NonNull Formatter<T> enumFormatter() {
        return new Adapter(nbbrd.io.text.Formatter.onEnum());
    }

    public static @NonNull Formatter<String> stringFormatter() {
        return OBJECT_TO_STRING_FORMATTER;
    }

    public static @NonNull Formatter<double[]> doubleArrayFormatter() {
        return DOUBLE_ARRAY_FORMATTER;
    }

    public static @NonNull Formatter<String[]> stringArrayFormatter() {
        return STRING_ARRAY_FORMATTER;
    }

    public static <X, Y> @NonNull Formatter<Y> compose(@NonNull IFormatter<X> formatter, @NonNull Function<? super Y, ? extends X> before) {
        return new Wrapper(o -> {
            Object tmp = before.apply((Object)o);
            return tmp != null ? formatter.format(tmp) : null;
        });
    }

    public static @NonNull Formatter<Object> usingToString() {
        return OBJECT_TO_STRING_FORMATTER;
    }

    public static @NonNull Formatter<List<String>> onJoiner(@NonNull Joiner joiner) {
        Objects.requireNonNull(joiner);
        return new Adapter<List<String>>(nbbrd.io.text.Formatter.onStringList(stream -> joiner.join(stream.iterator())));
    }

    public static <T> @NonNull Formatter<T> wrap(@NonNull IFormatter<T> formatter) {
        return formatter instanceof Formatter ? (Formatter)formatter : new Wrapper(Objects.requireNonNull(formatter));
    }

    public static abstract class Formatter<T>
    implements IFormatter<T> {
        @Deprecated
        public @NonNull com.google.common.base.Optional<CharSequence> tryFormat(@NonNull T value) throws NullPointerException {
            return com.google.common.base.Optional.fromNullable((Object)this.format(value));
        }

        @Override
        public <Y> @NonNull Formatter<Y> compose(@NonNull Function<? super Y, ? extends T> before) {
            return Formatters.compose(this, before);
        }

        @Deprecated
        public @NonNull com.google.common.base.Optional<String> tryFormatAsString(@NonNull T value) throws NullPointerException {
            return com.google.common.base.Optional.fromNullable((Object)this.formatAsString(value));
        }
    }

    private static final class Wrapper<T>
    extends Formatter<T> {
        private final IFormatter<T> formatter;

        private Wrapper(IFormatter<T> formatter) {
            this.formatter = formatter;
        }

        @Override
        public CharSequence format(T value) {
            return this.formatter.format(value);
        }

        @Override
        public String formatAsString(T value) {
            return this.formatter.formatAsString(value);
        }

        @Override
        public Optional<CharSequence> formatValue(T value) {
            return this.formatter.formatValue(value);
        }

        @Override
        public Optional<String> formatValueAsString(T value) {
            return this.formatter.formatValueAsString(value);
        }
    }

    private static final class Adapter<T>
    extends Formatter<T> {
        private final nbbrd.io.text.Formatter<T> formatter;

        @Override
        public CharSequence format(T value) {
            Objects.requireNonNull(value);
            return this.formatter.format(value);
        }

        @Override
        public String formatAsString(T value) {
            Objects.requireNonNull(value);
            return this.formatter.formatAsString(value);
        }

        @Override
        public Optional<CharSequence> formatValue(T value) {
            Objects.requireNonNull(value);
            return this.formatter.formatValue(value);
        }

        @Override
        public Optional<String> formatValueAsString(T value) {
            Objects.requireNonNull(value);
            return this.formatter.formatValueAsString(value);
        }

        @Generated
        public Adapter(nbbrd.io.text.Formatter<T> formatter) {
            this.formatter = formatter;
        }
    }

    public static abstract class FailSafeFormatter<T>
    extends Formatter<T> {
        @Override
        public CharSequence format(T value) throws NullPointerException {
            Objects.requireNonNull(value);
            try {
                return this.doFormat(value);
            }
            catch (Exception ex) {
                return null;
            }
        }

        protected abstract @Nullable CharSequence doFormat(@NonNull T var1) throws Exception;
    }
}

