/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.tsproviders.utils;

import ec.tss.tsproviders.utils.IParam;
import ec.tstoolkit.design.IBuilder;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import net.jcip.annotations.Immutable;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@Immutable
public interface IConfig {
    public @NonNull SortedMap<String, String> getParams();

    default public @Nullable String get(@NonNull String key) {
        return (String)this.getParams().get(key);
    }

    default public @NonNull Optional<String> getParam(@NonNull String key) {
        return Optional.of((String)this.getParams().get(key));
    }

    default public void forEach(@NonNull BiConsumer<? super String, ? super String> action) {
        this.getParams().forEach(action);
    }

    default public @NonNull Stream<Map.Entry<String, String>> stream() {
        return this.getParams().entrySet().stream();
    }

    public static interface Builder<THIS, T extends IConfig>
    extends IBuilder<T> {
        public @NonNull THIS put(@NonNull String var1, @NonNull String var2);

        default public @NonNull THIS put(@NonNull String key, int value) {
            return this.put(key, String.valueOf(value));
        }

        default public @NonNull THIS put(@NonNull String key, boolean value) {
            return this.put(key, String.valueOf(value));
        }

        default public @NonNull THIS put(@NonNull Map.Entry<String, String> entry) {
            return this.put(entry.getKey(), entry.getValue());
        }

        default public @NonNull THIS putAll(@NonNull Map<String, String> map) {
            map.forEach(this::put);
            return (THIS)this;
        }

        default public <V> @NonNull THIS put(@NonNull IParam<T, V> param, V value) {
            param.set(this, value);
            return (THIS)this;
        }
    }
}

