/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.tsproviders.utils;

import java.util.Optional;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@FunctionalInterface
public interface IFormatter<T> {
    public @Nullable CharSequence format(@NonNull T var1);

    default public @Nullable String formatAsString(@NonNull T value) {
        CharSequence result = this.format(value);
        return result != null ? result.toString() : null;
    }

    default public @NonNull Optional<CharSequence> formatValue(@NonNull T value) {
        return Optional.ofNullable(this.format(value));
    }

    default public @NonNull Optional<String> formatValueAsString(@NonNull T value) {
        return Optional.ofNullable(this.formatAsString(value));
    }

    default public <Y> @NonNull IFormatter<Y> compose(@NonNull Function<? super Y, ? extends T> before) {
        return o -> {
            Object tmp = before.apply((Object)o);
            return tmp != null ? this.format(tmp) : null;
        };
    }
}

