/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.tsproviders.utils;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@FunctionalInterface
public interface IParser<T> {
    public @Nullable T parse(@NonNull CharSequence var1);

    default public @NonNull Optional<T> parseValue(@NonNull CharSequence input) {
        return Optional.ofNullable(this.parse(input));
    }

    default public @NonNull IParser<T> orElse(@NonNull IParser<T> other) {
        Objects.requireNonNull(other);
        return o -> {
            T result = this.parse(o);
            return result != null ? result : other.parse(o);
        };
    }

    default public <X> @NonNull IParser<X> andThen(@NonNull Function<? super T, ? extends X> after) {
        Objects.requireNonNull(after);
        return o -> {
            T tmp = this.parse(o);
            return tmp != null ? after.apply((T)tmp) : null;
        };
    }
}

