/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.tsproviders.utils;

import ec.tss.tsproviders.utils.IteratorWithIOs;
import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface IteratorWithIO<E>
extends Closeable {
    public boolean hasNext() throws IOException;

    public @Nullable E next() throws IOException, NoSuchElementException;

    default public <Z> @NonNull IteratorWithIO<Z> transform(@NonNull Function<? super E, ? extends Z> function) {
        return new IteratorWithIOs.TransformingIterator<E, Z>(this, function);
    }

    default public @NonNull IteratorWithIO<E> onClose(@NonNull Closeable closeHandler) {
        return new IteratorWithIOs.OnCloseIterator(this, closeHandler);
    }

    public static <E> @NonNull IteratorWithIO<E> empty() {
        return new IteratorWithIOs.EmptyIterator();
    }

    public static <E> @NonNull IteratorWithIO<E> from(@NonNull Iterator<E> iterator) {
        return new IteratorWithIOs.Adapter<E>(iterator);
    }
}

