/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.tsproviders.utils;

import ec.tss.tsproviders.utils.IteratorWithIO;
import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Function;
import nbbrd.io.Resource;

final class IteratorWithIOs {
    private IteratorWithIOs() {
    }

    static final class Adapter<E>
    implements IteratorWithIO<E> {
        private final Iterator<E> delegate;

        Adapter(Iterator<E> delegate) {
            this.delegate = Objects.requireNonNull(delegate);
        }

        @Override
        public boolean hasNext() throws IOException {
            return this.delegate.hasNext();
        }

        @Override
        public E next() throws IOException, NoSuchElementException {
            return this.delegate.next();
        }

        @Override
        public void close() throws IOException {
        }
    }

    static final class EmptyIterator<E>
    implements IteratorWithIO<E> {
        EmptyIterator() {
        }

        @Override
        public boolean hasNext() throws IOException {
            return false;
        }

        @Override
        public E next() throws IOException, NoSuchElementException {
            throw new NoSuchElementException();
        }

        @Override
        public void close() throws IOException {
        }
    }

    static final class OnCloseIterator<E>
    extends ForwardingIterator<E> {
        private final Closeable closeHandler;

        OnCloseIterator(IteratorWithIO<E> delegate, Closeable closeHandler) {
            super(delegate);
            this.closeHandler = Objects.requireNonNull(closeHandler);
        }

        @Override
        public void close() throws IOException {
            Resource.closeBoth((Closeable)this.delegate, (Closeable)this.closeHandler);
        }
    }

    static final class TransformingIterator<E, Z>
    extends ForwardingIterator<Z> {
        private final Function<? super E, ? extends Z> function;

        TransformingIterator(IteratorWithIO<E> delegate, Function<? super E, ? extends Z> function) {
            super(delegate);
            this.function = Objects.requireNonNull(function);
        }

        @Override
        public Z next() throws IOException, NoSuchElementException {
            return this.function.apply(this.delegate.next());
        }
    }

    private static abstract class ForwardingIterator<E>
    implements IteratorWithIO<E> {
        protected final IteratorWithIO<E> delegate;

        private ForwardingIterator(IteratorWithIO<E> delegate) {
            this.delegate = Objects.requireNonNull(delegate);
        }

        @Override
        public boolean hasNext() throws IOException {
            return this.delegate.hasNext();
        }

        @Override
        public E next() throws IOException, NoSuchElementException {
            return this.delegate.next();
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
        }
    }
}

