/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.tsproviders.utils;

import ec.tstoolkit.utilities.Trees;
import java.util.function.Function;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class MultiLineNameUtil {
    private static final char RIGHT_POINTING_TRIANGLE = '\u25b6';
    private static final char HORIZONTAL_ELLIPSIS = '\u2026';
    private static final String JOIN_SEP = " \u25b6 ";
    private static final String LAST_PREFIX = "\u2026 ";
    public static final String SEPARATOR = "\n";

    private MultiLineNameUtil() {
    }

    public static @NonNull String join(@NonNull String input) {
        return MultiLineNameUtil.join(input, JOIN_SEP);
    }

    public static @NonNull String join(@NonNull String input, @NonNull String separator) {
        return input.replace(SEPARATOR, separator);
    }

    public static @NonNull String toHtml(@NonNull String input) {
        String[] items = input.split(SEPARATOR, -1);
        Function<Integer, Stream> children = o -> o < items.length - 1 ? Stream.of(Integer.valueOf(o + 1)) : Stream.empty();
        Function<Integer, String> toString = o -> (o == 0 ? "" : " ") + items[o] + "<br>";
        String result = Trees.prettyPrintToString((Object)0, children, (int)Integer.MAX_VALUE, toString);
        return "<html>" + result.replace(" ", "&nbsp;");
    }

    public static @NonNull String last(@NonNull String input) {
        int index = input.lastIndexOf(SEPARATOR);
        return index == -1 ? input : input.substring(index + 1);
    }

    public static @NonNull String lastWithMax(@NonNull String input, int maxLength) {
        String last = MultiLineNameUtil.last(input);
        return last.length() < maxLength ? last : LAST_PREFIX + last.substring(last.length() - maxLength);
    }
}

