/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.tsproviders.utils;

import ec.tstoolkit.timeseries.TsAggregationType;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import lombok.Generated;
import net.jcip.annotations.Immutable;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@Immutable
public final class ObsGathering {
    public static final ObsGathering DEFAULT = ObsGathering.excludingMissingValues(TsFrequency.Undefined, TsAggregationType.None);
    @lombok.NonNull
    private final TsFrequency frequency;
    @lombok.NonNull
    private final TsAggregationType aggregationType;
    private final boolean skipMissingValues;

    public static @NonNull ObsGathering includingMissingValues(@NonNull TsFrequency frequency, @NonNull TsAggregationType aggregationType) {
        return new ObsGathering(frequency, aggregationType, false);
    }

    public static @NonNull ObsGathering excludingMissingValues(@NonNull TsFrequency frequency, @NonNull TsAggregationType aggregationType) {
        return new ObsGathering(frequency, aggregationType, true);
    }

    private ObsGathering(TsFrequency frequency, TsAggregationType aggregationType, boolean skipMissingValues) {
        this.frequency = frequency;
        this.aggregationType = aggregationType;
        this.skipMissingValues = skipMissingValues;
    }

    @lombok.NonNull
    @Generated
    public TsFrequency getFrequency() {
        return this.frequency;
    }

    @lombok.NonNull
    @Generated
    public TsAggregationType getAggregationType() {
        return this.aggregationType;
    }

    @Generated
    public boolean isSkipMissingValues() {
        return this.skipMissingValues;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ObsGathering)) {
            return false;
        }
        ObsGathering other = (ObsGathering)o;
        if (this.isSkipMissingValues() != other.isSkipMissingValues()) {
            return false;
        }
        TsFrequency this$frequency = this.getFrequency();
        TsFrequency other$frequency = other.getFrequency();
        if (this$frequency == null ? other$frequency != null : !this$frequency.equals(other$frequency)) {
            return false;
        }
        TsAggregationType this$aggregationType = this.getAggregationType();
        TsAggregationType other$aggregationType = other.getAggregationType();
        return !(this$aggregationType == null ? other$aggregationType != null : !this$aggregationType.equals(other$aggregationType));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSkipMissingValues() ? 79 : 97);
        TsFrequency $frequency = this.getFrequency();
        result = result * 59 + ($frequency == null ? 43 : $frequency.hashCode());
        TsAggregationType $aggregationType = this.getAggregationType();
        result = result * 59 + ($aggregationType == null ? 43 : $aggregationType.hashCode());
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "ObsGathering(frequency=" + this.getFrequency() + ", aggregationType=" + this.getAggregationType() + ", skipMissingValues=" + this.isSkipMissingValues() + ")";
    }

    @Generated
    public @NonNull ObsGathering withFrequency(@lombok.NonNull TsFrequency frequency) {
        if (frequency == null) {
            throw new NullPointerException("frequency is marked non-null but is null");
        }
        return this.frequency == frequency ? this : new ObsGathering(frequency, this.aggregationType, this.skipMissingValues);
    }

    @Generated
    public @NonNull ObsGathering withAggregationType(@lombok.NonNull TsAggregationType aggregationType) {
        if (aggregationType == null) {
            throw new NullPointerException("aggregationType is marked non-null but is null");
        }
        return this.aggregationType == aggregationType ? this : new ObsGathering(this.frequency, aggregationType, this.skipMissingValues);
    }

    @Generated
    public @NonNull ObsGathering withSkipMissingValues(boolean skipMissingValues) {
        return this.skipMissingValues == skipMissingValues ? this : new ObsGathering(this.frequency, this.aggregationType, skipMissingValues);
    }
}

