/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.tsproviders.utils;

import com.google.common.base.Preconditions;
import ec.tss.tsproviders.utils.ByteArrayConverter;
import ec.tss.tsproviders.utils.ObsCharacteristics;
import ec.tss.tsproviders.utils.ObsGathering;
import ec.tstoolkit.design.IBuilder;
import ec.tstoolkit.design.VisibleForTesting;
import ec.tstoolkit.timeseries.TsAggregationType;
import ec.tstoolkit.timeseries.simplets.ObsList;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsDataCollector;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import ec.tstoolkit.timeseries.simplets.TsPeriod;
import ec.tstoolkit.utilities.ObjLongToIntFunction;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.EnumSet;
import java.util.GregorianCalendar;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.ToLongFunction;
import java.util.stream.Stream;
import net.jcip.annotations.NotThreadSafe;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class OptionalTsData {
    @VisibleForTesting
    static final OptionalTsData NO_DATA = new Absent("No data available");
    @VisibleForTesting
    static final OptionalTsData INVALID_AGGREGATION = new Absent("Invalid aggregation mode");
    @VisibleForTesting
    static final OptionalTsData GUESS_SINGLE = new Absent("Cannot guess frequency with a single observation");
    @VisibleForTesting
    static final OptionalTsData GUESS_DUPLICATION = new Absent("Cannot guess frequency with duplicated periods");
    @VisibleForTesting
    static final OptionalTsData DUPLICATION_WITHOUT_AGGREGATION = new Absent("Duplicated observations without aggregation");
    @VisibleForTesting
    static final OptionalTsData UNKNOWN = new Absent("Unexpected error");

    public static @NonNull OptionalTsData present(@NonNull TsData data) {
        return new Present(Objects.requireNonNull(data));
    }

    @Deprecated
    public static @NonNull OptionalTsData present(@NonNegative int nbrRows, @NonNegative int nbrUselessRows, @NonNull TsData data) {
        Preconditions.checkArgument((nbrRows >= nbrUselessRows && nbrUselessRows >= 0 ? 1 : 0) != 0);
        return OptionalTsData.present(data);
    }

    public static @NonNull OptionalTsData absent(@NonNull String cause) {
        return new Absent(Objects.requireNonNull(cause));
    }

    @Deprecated
    public static @NonNull OptionalTsData absent(@NonNegative int nbrRows, @NonNegative int nbrUselessRows, @NonNull String cause) {
        Preconditions.checkArgument((nbrRows >= nbrUselessRows && nbrUselessRows >= 0 ? 1 : 0) != 0);
        return OptionalTsData.absent(cause);
    }

    public static @NonNull Builder2<Date> builderByDate(@NonNull Calendar resource, @NonNull ObsGathering gathering, ObsCharacteristics ... characteristics) {
        return OptionalTsData.builder(gathering, OptionalTsData.toEnumSet(characteristics), Date::getTime, (ObjLongToIntFunction<TsFrequency>)((ObjLongToIntFunction)(f, p) -> OptionalTsData.getIdFromTimeInMillis(resource, f, p)));
    }

    public static @NonNull Builder2<LocalDate> builderByLocalDate(@NonNull ObsGathering gathering, ObsCharacteristics ... characteristics) {
        return OptionalTsData.builder(gathering, OptionalTsData.toEnumSet(characteristics), OptionalTsData::getYearMonthDay, (ObjLongToIntFunction<TsFrequency>)((ObjLongToIntFunction)OptionalTsData::getIdFromYearMonthDay));
    }

    @Deprecated
    public @NonNegative int getNbrRows() {
        return 0;
    }

    @Deprecated
    public @NonNegative int getNbrUselessRows() {
        return 0;
    }

    public abstract boolean isPresent();

    public abstract @NonNull TsData get() throws IllegalStateException;

    public @NonNull TsData or(@NonNull TsData defaultValue) {
        Objects.requireNonNull(defaultValue, "use orNull() instead of or(null)");
        return this.isPresent() ? this.get() : defaultValue;
    }

    public abstract @Nullable TsData orNull();

    public abstract @NonNull String getCause() throws IllegalStateException;

    private static <T> Builder2<T> builder(ObsGathering gathering, @NonNull Set<ObsCharacteristics> characteristics, ToLongFunction<T> periodFunc, ObjLongToIntFunction<TsFrequency> tsPeriodIdFunc) {
        boolean ordered = characteristics.contains((Object)ObsCharacteristics.ORDERED);
        if (gathering.getFrequency() == TsFrequency.Undefined) {
            if (gathering.getAggregationType() != TsAggregationType.None) {
                return new UndefinedWithAggregation();
            }
            return new BuilderSupport<T>(ObsList.newLongObsList((boolean)ordered, tsPeriodIdFunc), periodFunc, gathering.isSkipMissingValues(), o -> OptionalTsData.makeFromUnknownFrequency(o));
        }
        if (gathering.getAggregationType() != TsAggregationType.None) {
            return new BuilderSupport<T>(ObsList.newLongObsList((boolean)ordered, tsPeriodIdFunc), periodFunc, gathering.isSkipMissingValues(), o -> OptionalTsData.makeWithAggregation(o, gathering.getFrequency(), gathering.getAggregationType()));
        }
        return new BuilderSupport<T>(ObsList.newLongObsList((boolean)ordered, tsPeriodIdFunc), periodFunc, gathering.isSkipMissingValues(), o -> OptionalTsData.makeWithoutAggregation(o, gathering.getFrequency()));
    }

    private static OptionalTsData makeFromUnknownFrequency(ObsList obs) {
        switch (obs.size()) {
            case 0: {
                return NO_DATA;
            }
            case 1: {
                return GUESS_SINGLE;
            }
        }
        TsData result = TsDataCollector.makeFromUnknownFrequency((ObsList)obs);
        return result != null ? OptionalTsData.present(result) : GUESS_DUPLICATION;
    }

    private static OptionalTsData makeWithoutAggregation(ObsList obs, TsFrequency freq) {
        switch (obs.size()) {
            case 0: {
                return NO_DATA;
            }
        }
        TsData result = TsDataCollector.makeWithoutAggregation((ObsList)obs, (TsFrequency)freq);
        return result != null ? OptionalTsData.present(result) : DUPLICATION_WITHOUT_AGGREGATION;
    }

    private static OptionalTsData makeWithAggregation(ObsList obs, TsFrequency freq, TsAggregationType convMode) {
        switch (obs.size()) {
            case 0: {
                return NO_DATA;
            }
        }
        TsData result = TsDataCollector.makeFromUnknownFrequency((ObsList)obs);
        result = result != null && result.getFrequency().intValue() % freq.intValue() == 0 ? result.changeFrequency(freq, convMode, true) : TsDataCollector.makeWithAggregation((ObsList)obs, (TsFrequency)freq, (TsAggregationType)convMode);
        return result != null ? OptionalTsData.present(result) : UNKNOWN;
    }

    private static int getIdFromTimeInMillis(Calendar cal, TsFrequency freq, long period) {
        cal.setTimeInMillis(period);
        return OptionalTsData.calcTsPeriodId(freq.intValue(), cal.get(1), cal.get(2));
    }

    private static long getYearMonthDay(LocalDate date) {
        return (long)(date.getYear() * 100 + date.getMonthValue()) * 100L + (long)date.getDayOfMonth();
    }

    private static int getIdFromYearMonthDay(TsFrequency freq, long period) {
        return OptionalTsData.calcTsPeriodId(freq.intValue(), (int)((period /= 100L) / 100L), (int)(period % 100L - 1L));
    }

    private static int calcTsPeriodId(int freq, int year, int month) {
        return (year - 1970) * freq + month / (12 / freq);
    }

    private static EnumSet<ObsCharacteristics> toEnumSet(ObsCharacteristics[] items) {
        switch (items.length) {
            case 0: {
                return EnumSet.noneOf(ObsCharacteristics.class);
            }
            case 1: {
                return EnumSet.of(items[0]);
            }
        }
        return EnumSet.copyOf(Arrays.asList(items));
    }

    private static final class Present
    extends OptionalTsData {
        private static final ByteArrayConverter CONVERTER = ByteArrayConverter.getInstance();
        private final int freq;
        private final int year;
        private final int position;
        private final byte[] data;

        private Present(TsData data) {
            TsPeriod start = data.getStart();
            this.freq = start.getFrequency().intValue();
            this.year = start.getYear();
            this.position = start.getPosition();
            this.data = CONVERTER.fromDoubleArray(data.internalStorage());
        }

        @Override
        public boolean isPresent() {
            return true;
        }

        @Override
        public TsData get() {
            return new TsData(TsFrequency.valueOf((int)this.freq), this.year, this.position, CONVERTER.toDoubleArray(this.data), false);
        }

        @Override
        public TsData orNull() {
            return this.get();
        }

        @Override
        public String getCause() throws IllegalStateException {
            throw new IllegalStateException("TsData is present");
        }

        public boolean equals(Object obj) {
            return this == obj || obj instanceof Present && this.equals((Present)obj);
        }

        private boolean equals(Present that) {
            return this.freq == that.freq && this.year == that.year && this.position == that.position && Arrays.equals(this.data, that.data);
        }

        public int hashCode() {
            return Objects.hash(this.freq, this.year, this.position, this.data);
        }

        public String toString() {
            return "Present: " + this.freq + "@" + this.year + "/" + this.position + " " + Arrays.toString(this.data);
        }
    }

    private static final class Absent
    extends OptionalTsData {
        private final String cause;

        private Absent(String cause) {
            this.cause = cause;
        }

        @Override
        public boolean isPresent() {
            return false;
        }

        @Override
        public TsData get() throws IllegalStateException {
            throw new IllegalStateException(this.cause);
        }

        @Override
        public TsData orNull() {
            return null;
        }

        @Override
        public String getCause() {
            return this.cause;
        }

        public boolean equals(Object obj) {
            return this == obj || obj instanceof Absent && this.equals((Absent)obj);
        }

        private boolean equals(Absent that) {
            return this.cause.equals(that.cause);
        }

        public int hashCode() {
            return this.cause.hashCode();
        }

        public String toString() {
            return "Absent: " + this.cause;
        }
    }

    @NotThreadSafe
    public static interface Builder2<T>
    extends IBuilder<OptionalTsData> {
        public @NonNull Builder2<T> clear();

        public @NonNull Builder2<T> add(@Nullable T var1, @Nullable Number var2);

        default public <X> @NonNull Builder2<T> add(X obs, Function<? super X, ? extends T> dateFunc, Function<? super X, ? extends Number> valueFunc) {
            T date;
            return this.add(date, (date = dateFunc.apply(obs)) != null ? (Number)valueFunc.apply(obs) : (Number)null);
        }

        default public <X> @NonNull Builder2<T> addAll(Stream<X> stream, Function<? super X, ? extends T> dateFunc, Function<? super X, ? extends Number> valueFunc) {
            stream.forEach(o -> this.add(o, dateFunc, valueFunc));
            return this;
        }

        public @NonNull OptionalTsData build();
    }

    private static final class UndefinedWithAggregation<T>
    implements Builder2<T> {
        private UndefinedWithAggregation() {
        }

        @Override
        public Builder2<T> clear() {
            return this;
        }

        @Override
        public Builder2<T> add(T date, Number value) {
            return this;
        }

        @Override
        public OptionalTsData build() {
            return INVALID_AGGREGATION;
        }
    }

    private static final class BuilderSupport<T>
    implements Builder2<T> {
        private final ObsList.LongObsList obs;
        private final ToLongFunction<T> periodFunc;
        private final boolean skipMissingValues;
        private final Function<ObsList, OptionalTsData> maker;

        BuilderSupport(ObsList.LongObsList obs, ToLongFunction<T> periodFunc, boolean skipMissingValues, Function<ObsList, OptionalTsData> maker) {
            this.obs = obs;
            this.periodFunc = periodFunc;
            this.skipMissingValues = skipMissingValues;
            this.maker = maker;
        }

        @Override
        public Builder2<T> clear() {
            this.obs.clear();
            return this;
        }

        @Override
        public Builder2<T> add(T date, Number value) {
            if (date != null) {
                if (value != null) {
                    this.obs.add(this.periodFunc.applyAsLong(date), value.doubleValue());
                } else if (!this.skipMissingValues) {
                    this.obs.add(this.periodFunc.applyAsLong(date), Double.NaN);
                }
            }
            return this;
        }

        @Override
        public OptionalTsData build() {
            return this.maker.apply((ObsList)this.obs);
        }
    }

    @Deprecated
    public static final class Builder
    implements IBuilder<OptionalTsData> {
        private final Builder2<Date> delegate;

        public static @NonNull String toString(@NonNull TsFrequency freq, @NonNull TsAggregationType aggregation) {
            return "(" + freq + "/" + aggregation + ")";
        }

        public Builder(@NonNull TsFrequency freq, @NonNull TsAggregationType aggregation) {
            this(freq, aggregation, false);
        }

        public Builder(@NonNull TsFrequency freq, @NonNull TsAggregationType aggregation, boolean skipMissingValues) {
            ObsGathering gathering = skipMissingValues ? ObsGathering.excludingMissingValues(freq, aggregation) : ObsGathering.includingMissingValues(freq, aggregation);
            this.delegate = OptionalTsData.builderByDate(new GregorianCalendar(), gathering, new ObsCharacteristics[0]);
        }

        public @NonNull Builder clear() {
            this.delegate.clear();
            return this;
        }

        public @NonNull Builder add(@Nullable Date period, @Nullable Number value) {
            this.delegate.add(period, value);
            return this;
        }

        public @NonNull OptionalTsData build() {
            return this.delegate.build();
        }
    }
}

