/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.tsproviders.utils;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSortedMap;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.xml.bind.annotation.XmlAttribute;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ParamBean {
    @XmlAttribute(name="key")
    public String key;
    @XmlAttribute(name="value")
    public String value;

    public static @NonNull ImmutableSortedMap<String, String> toSortedMap(@Nullable ParamBean[] params) {
        if (params == null || params.length == 0) {
            return ImmutableSortedMap.of();
        }
        ImmutableSortedMap.Builder b = ImmutableSortedMap.naturalOrder();
        for (ParamBean o : params) {
            b.put((Object)Strings.nullToEmpty((String)o.key), (Object)Strings.nullToEmpty((String)o.value));
        }
        return b.build();
    }

    public static @Nullable ParamBean[] fromSortedMap(@NonNull SortedMap<String, String> sortedMap) {
        if (sortedMap.isEmpty()) {
            return null;
        }
        ParamBean[] result = new ParamBean[sortedMap.size()];
        int i = 0;
        for (Map.Entry<String, String> o : sortedMap.entrySet()) {
            ParamBean item = new ParamBean();
            item.key = o.getKey();
            item.value = o.getValue();
            result[i++] = item;
        }
        return result;
    }

    public static @NonNull Properties toProperties(@Nullable ParamBean[] params) {
        Properties result = new Properties();
        if (params != null) {
            for (ParamBean o : params) {
                result.put(o.key, o.value);
            }
        }
        return result;
    }

    public static @Nullable ParamBean[] fromProperties(@NonNull Properties properties) {
        TreeMap<String, String> result = new TreeMap<String, String>();
        properties.stringPropertyNames().forEach(o -> result.put((String)o, properties.getProperty((String)o)));
        return ParamBean.fromSortedMap(result);
    }
}

