/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.tsproviders.utils;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import ec.tss.tsproviders.utils.DataFormat;
import ec.tss.tsproviders.utils.Formatters;
import ec.tss.tsproviders.utils.IConfig;
import ec.tss.tsproviders.utils.IFormatter;
import ec.tss.tsproviders.utils.IParam;
import ec.tss.tsproviders.utils.IParser;
import ec.tss.tsproviders.utils.ObsGathering;
import ec.tss.tsproviders.utils.Parsers;
import ec.tstoolkit.design.UtilityClass;
import ec.tstoolkit.timeseries.TsAggregationType;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import java.io.File;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@UtilityClass(value={IParam.class})
public final class Params {
    private Params() {
    }

    public static <S extends IConfig> @NonNull IParam<S, String> onString(@NonNull String defaultValue, @NonNull String key) {
        return new SingleParam(defaultValue, key, Parsers.stringParser(), Formatters.stringFormatter());
    }

    public static <S extends IConfig> @NonNull IParam<S, File> onFile(@NonNull File defaultValue, @NonNull String key) {
        return new SingleParam(defaultValue, key, Parsers.fileParser(), Formatters.fileFormatter());
    }

    public static <S extends IConfig, X extends Enum<X>> @NonNull IParam<S, X> onEnum(@NonNull X defaultValue, @NonNull String key) {
        Class<?> enumClass = defaultValue.getClass();
        return new SingleParam(defaultValue, key, Parsers.enumParser(enumClass), Formatters.enumFormatter());
    }

    public static <S extends IConfig> @NonNull IParam<S, Integer> onInteger(@NonNull Integer defaultValue, @NonNull String key) {
        return new SingleParam(defaultValue, key, Parsers.intParser(), Formatters.intFormatter());
    }

    public static <S extends IConfig> @NonNull IParam<S, Long> onLong(@NonNull Long defaultValue, @NonNull String key) {
        return new SingleParam(defaultValue, key, Parsers.longParser(), Formatters.longFormatter());
    }

    public static <S extends IConfig> @NonNull IParam<S, Boolean> onBoolean(@NonNull Boolean defaultValue, @NonNull String key) {
        return new SingleParam(defaultValue, key, Parsers.boolParser(), Formatters.boolFormatter());
    }

    public static <S extends IConfig> @NonNull IParam<S, Character> onCharacter(@NonNull Character defaultValue, @NonNull String key) {
        return new SingleParam(defaultValue, key, Parsers.charParser(), Formatters.charFormatter());
    }

    public static <S extends IConfig> @NonNull IParam<S, Double> onDouble(@NonNull Double defaultValue, @NonNull String key) {
        return new SingleParam(defaultValue, key, Parsers.doubleParser(), Formatters.doubleFormatter());
    }

    public static <S extends IConfig> @NonNull IParam<S, Charset> onCharset(@NonNull Charset defaultValue, @NonNull String key) {
        return new SingleParam(defaultValue, key, Parsers.charsetParser(), Formatters.charsetFormatter());
    }

    @Deprecated
    public static <S extends IConfig> @NonNull IParam<S, DataFormat> onDataFormat(@NonNull DataFormat defaultValue, @NonNull String localeKey, @NonNull String datePatternKey) {
        return Params.onDataFormat(defaultValue, localeKey, datePatternKey, "numberPattern");
    }

    public static <S extends IConfig> @NonNull IParam<S, DataFormat> onDataFormat(@NonNull DataFormat defaultValue, @NonNull String localeKey, @NonNull String datePatternKey, @NonNull String numberPatternKey) {
        return new DataFormatParam(defaultValue, localeKey, datePatternKey, numberPatternKey);
    }

    public static <S extends IConfig> @NonNull IParam<S, double[]> onDoubleArray(@NonNull String key, double ... defaultValues) {
        return new SingleParam(defaultValues, key, Parsers.doubleArrayParser(), Formatters.doubleArrayFormatter());
    }

    public static <S extends IConfig> @NonNull IParam<S, String[]> onStringArray(@NonNull String key, String ... defaultValues) {
        return new SingleParam(defaultValues, key, Parsers.stringArrayParser(), Formatters.stringArrayFormatter());
    }

    public static <S extends IConfig> @NonNull IParam<S, List<String>> onStringList(@NonNull List<String> defaultValue, @NonNull String key, @NonNull Splitter splitter, @NonNull Joiner joiner) {
        return new SingleParam(ImmutableList.copyOf(defaultValue), key, Parsers.onSplitter(splitter), Formatters.onJoiner(joiner));
    }

    public static <S extends IConfig> @NonNull IParam<S, ObsGathering> onObsGathering(@NonNull ObsGathering defaultValue, @NonNull String frequencyKey, @NonNull String aggregationKey, @NonNull String skipKey) {
        return new ObsGatheringParam(defaultValue, frequencyKey, aggregationKey, skipKey);
    }

    private static final class SingleParam<S extends IConfig, P>
    implements IParam<S, P> {
        private final P defaultValue;
        private final String key;
        private final IParser<P> parser;
        private final IFormatter<P> formatter;

        private SingleParam(@NonNull P defaultValue, @NonNull String key, @NonNull IParser<P> parser, @NonNull IFormatter<P> formatter) {
            this.defaultValue = Objects.requireNonNull(defaultValue);
            this.key = Objects.requireNonNull(key);
            this.parser = Objects.requireNonNull(parser);
            this.formatter = Objects.requireNonNull(formatter);
        }

        private boolean isValid(@NonNull String tmp) {
            return !tmp.isEmpty();
        }

        @Override
        public P defaultValue() {
            return this.defaultValue;
        }

        @Override
        public P get(IConfig config) {
            P result;
            String tmp = config.get(this.key);
            if (tmp != null && this.isValid(tmp) && (result = this.parser.parse(tmp)) != null) {
                return result;
            }
            return this.defaultValue;
        }

        @Override
        public void set(IConfig.Builder<?, S> builder, P value) {
            String valueAsString;
            Objects.requireNonNull(builder);
            if (!this.defaultValue.equals(value) && value != null && (valueAsString = this.formatter.formatAsString(value)) != null) {
                builder.put(this.key, valueAsString);
            }
        }
    }

    private static final class DataFormatParam<S extends IConfig>
    implements IParam<S, DataFormat> {
        private final DataFormat defaultValue;
        private final String localeKey;
        private final String datePatternKey;
        private final String numberPatternKey;

        private DataFormatParam(@NonNull DataFormat defaultValue, @NonNull String localeKey, @NonNull String datePatternKey, @NonNull String numberPatternKey) {
            this.defaultValue = Objects.requireNonNull(defaultValue);
            this.localeKey = Objects.requireNonNull(localeKey);
            this.datePatternKey = Objects.requireNonNull(datePatternKey);
            this.numberPatternKey = Objects.requireNonNull(numberPatternKey);
        }

        private boolean isValid(String locale, String datePattern) {
            return locale != null && datePattern != null;
        }

        private @Nullable Locale parseLocale(@NonNull String locale) {
            Locale result = (Locale)Parsers.localeParser().parse(locale);
            return Locale.ROOT.equals(result) && locale.isEmpty() ? null : result;
        }

        @Override
        public DataFormat defaultValue() {
            return this.defaultValue;
        }

        @Override
        public DataFormat get(IConfig config) {
            String locale = config.get(this.localeKey);
            String datePattern = config.get(this.datePatternKey);
            String numberPattern = config.get(this.numberPatternKey);
            return this.isValid(locale, datePattern) ? DataFormat.of(this.parseLocale(locale), datePattern, numberPattern) : this.defaultValue;
        }

        @Override
        public void set(IConfig.Builder<?, S> builder, DataFormat value) {
            Objects.requireNonNull(builder);
            if (!this.defaultValue.equals((Object)value)) {
                builder.put(this.localeKey, value.getLocaleString());
                builder.put(this.datePatternKey, value.getDatePattern());
                builder.put(this.numberPatternKey, value.getNumberPattern());
            }
        }
    }

    private static final class ObsGatheringParam<S extends IConfig>
    implements IParam<S, ObsGathering> {
        private final ObsGathering defaultValue;
        private final IParam<S, TsFrequency> frequency;
        private final IParam<S, TsAggregationType> aggregationType;
        private final IParam<S, Boolean> skipMissingValues;

        private ObsGatheringParam(@NonNull ObsGathering defaultValue, @NonNull String frequencyKey, @NonNull String aggregationKey, @NonNull String skipKey) {
            this.defaultValue = defaultValue;
            this.frequency = Params.onEnum(defaultValue.getFrequency(), frequencyKey);
            this.aggregationType = Params.onEnum(defaultValue.getAggregationType(), aggregationKey);
            this.skipMissingValues = Params.onBoolean(defaultValue.isSkipMissingValues(), skipKey);
        }

        @Override
        public ObsGathering defaultValue() {
            return this.defaultValue;
        }

        @Override
        public ObsGathering get(S config) {
            return this.skipMissingValues.get(config) != false ? ObsGathering.excludingMissingValues(this.frequency.get(config), this.aggregationType.get(config)) : ObsGathering.includingMissingValues(this.frequency.get(config), this.aggregationType.get(config));
        }

        @Override
        public void set(IConfig.Builder<?, S> builder, ObsGathering value) {
            Objects.requireNonNull(builder);
            this.skipMissingValues.set(builder, value.isSkipMissingValues());
            this.frequency.set(builder, value.getFrequency());
            this.aggregationType.set(builder, value.getAggregationType());
        }
    }
}

