/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.tsproviders.utils;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import ec.tss.tsproviders.utils.IParser;
import ec.tstoolkit.design.UtilityClass;
import java.io.File;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.StreamSupport;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import lombok.Generated;
import nbbrd.io.xml.bind.Jaxb;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@UtilityClass(value={IParser.class})
public final class Parsers {
    private static final Parser<File> FILE_PARSER = new Adapter<File>(nbbrd.io.text.Parser.onFile());
    private static final Parser<Integer> INT_PARSER = new Adapter<Integer>(nbbrd.io.text.Parser.onInteger());
    private static final Parser<Long> LONG_PARSER = new Adapter<Long>(nbbrd.io.text.Parser.onLong());
    private static final Parser<Double> DOUBLE_PARSER = new Adapter<Double>(nbbrd.io.text.Parser.onDouble());
    private static final Parser<Boolean> BOOL_PARSER = new Adapter<Boolean>(nbbrd.io.text.Parser.onBoolean());
    private static final Parser<Character> CHAR_PARSER = new Adapter<Character>(nbbrd.io.text.Parser.onCharacter());
    private static final Parser<Charset> CHARSET_PARSER = new Adapter<Charset>(nbbrd.io.text.Parser.onCharset());
    private static final Parser<String> STRING_PARSER = new Adapter<String>(nbbrd.io.text.Parser.onString());
    private static final Parser<double[]> DOUBLE_ARRAY_PARSER = new Adapter<double[]>(nbbrd.io.text.Parser.onDoubleArray());
    private static final Parser<String[]> STRING_ARRAY_PARSER = new Adapter<String[]>(nbbrd.io.text.Parser.onStringArray());
    private static final Parser<Locale> LOCALE_PARSER = new Adapter<Locale>(nbbrd.io.text.Parser.onLocale());

    private Parsers() {
    }

    public static <T> @Nullable T parseFirstNotNull(@NonNull CharSequence input, @NonNull Iterable<? extends IParser<T>> parsers) {
        Objects.requireNonNull(input);
        for (IParser<T> o : parsers) {
            T result = o.parse(input);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static <T> @NonNull Parser<T> firstNotNull(IParser<T> ... parsers) {
        return Parsers.firstNotNull(ImmutableList.copyOf((Object[])parsers));
    }

    public static <T> @NonNull Parser<T> firstNotNull(final @NonNull ImmutableList<? extends IParser<T>> parsers) {
        return new Parser<T>(){

            @Override
            public T parse(CharSequence input) throws NullPointerException {
                return Parsers.parseFirstNotNull(input, parsers);
            }
        };
    }

    public static <T> @NonNull Parser<T> onJAXB(@NonNull Class<T> classToBeParsed) {
        try {
            return Parsers.onJAXB(JAXBContext.newInstance((Class[])new Class[]{classToBeParsed}));
        }
        catch (JAXBException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static <T> @NonNull Parser<T> onJAXB(@NonNull JAXBContext context) {
        try {
            return Parsers.onJAXB(context.createUnmarshaller());
        }
        catch (JAXBException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static <T> @NonNull Parser<T> onJAXB(@NonNull Unmarshaller unmarshaller) {
        final Jaxb.Parser p = Jaxb.Parser.builder().factory(() -> unmarshaller).build();
        return new FailSafeParser<T>(){

            @Override
            protected T doParse(CharSequence input) throws Exception {
                return p.parseChars(input);
            }
        };
    }

    @Deprecated
    public static @NonNull Parser<Date> onStrictDatePattern(@NonNull String datePattern, @NonNull Locale locale) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(datePattern, locale);
        dateFormat.setLenient(false);
        return Parsers.onDateFormat(dateFormat);
    }

    public static @NonNull Parser<Date> onDateFormat(@NonNull DateFormat dateFormat) {
        return new Adapter<Date>(nbbrd.io.text.Parser.onDateFormat((DateFormat)dateFormat));
    }

    public static @NonNull Parser<Number> onNumberFormat(@NonNull NumberFormat numberFormat) {
        return new Adapter<Number>(nbbrd.io.text.Parser.onNumberFormat((NumberFormat)numberFormat));
    }

    public static <T> @NonNull Parser<T> onNull() {
        return new Adapter(nbbrd.io.text.Parser.onNull());
    }

    public static <T> @NonNull Parser<T> ofInstance(@Nullable T instance) {
        return new Adapter(nbbrd.io.text.Parser.onConstant(instance));
    }

    public static @NonNull Parser<File> fileParser() {
        return FILE_PARSER;
    }

    public static @NonNull Parser<Integer> intParser() {
        return INT_PARSER;
    }

    public static @NonNull Parser<Long> longParser() {
        return LONG_PARSER;
    }

    public static @NonNull Parser<Boolean> boolParser() {
        return BOOL_PARSER;
    }

    public static @NonNull Parser<Character> charParser() {
        return CHAR_PARSER;
    }

    public static @NonNull Parser<Double> doubleParser() {
        return DOUBLE_PARSER;
    }

    public static @NonNull Parser<Charset> charsetParser() {
        return CHARSET_PARSER;
    }

    public static <T extends Enum<T>> @NonNull Parser<T> enumParser(@NonNull Class<T> enumClass) {
        return new Adapter(nbbrd.io.text.Parser.onEnum(enumClass));
    }

    public static @NonNull Parser<String> stringParser() {
        return STRING_PARSER;
    }

    public static @NonNull Parser<double[]> doubleArrayParser() {
        return DOUBLE_ARRAY_PARSER;
    }

    public static @NonNull Parser<String[]> stringArrayParser() {
        return STRING_ARRAY_PARSER;
    }

    public static @NonNull Parser<Locale> localeParser() {
        return LOCALE_PARSER;
    }

    public static <X, Y> @NonNull Parser<Y> compose(final @NonNull IParser<X> parser, final @NonNull Function<X, Y> after) {
        return new Parser<Y>(){

            @Override
            public Y parse(CharSequence input) throws NullPointerException {
                Object tmp = parser.parse(input);
                return tmp != null ? (Object)after.apply(tmp) : null;
            }
        };
    }

    public static @NonNull Parser<List<String>> onSplitter(@NonNull Splitter splitter) {
        Objects.requireNonNull(splitter);
        return new Adapter<List<String>>(nbbrd.io.text.Parser.onStringList(chars -> StreamSupport.stream(splitter.split(chars).spliterator(), false)));
    }

    public static <T> @NonNull Parser<T> wrap(@NonNull IParser<T> parser) {
        return parser instanceof Parser ? (Parser)parser : new Wrapper<T>(parser);
    }

    public static abstract class Parser<T>
    implements IParser<T> {
        @Deprecated
        public @NonNull com.google.common.base.Optional<T> tryParse(@NonNull CharSequence input) {
            return com.google.common.base.Optional.fromNullable(this.parse(input));
        }

        @Deprecated
        public <X> @NonNull Parser<X> compose(@NonNull Function<T, X> after) {
            return Parsers.compose(this, after);
        }

        @Deprecated
        public @NonNull Parser<T> or(IParser<T> ... parsers) {
            switch (parsers.length) {
                case 0: {
                    return this;
                }
                case 1: {
                    return Parsers.firstNotNull(ImmutableList.of((Object)this, parsers[0]));
                }
            }
            return Parsers.firstNotNull(ImmutableList.builder().add((Object)this).add((Object[])parsers).build());
        }
    }

    private static final class Adapter<T>
    extends Parser<T> {
        private final nbbrd.io.text.Parser<T> parser;

        @Override
        public T parse(CharSequence input) {
            Objects.requireNonNull(input);
            return (T)this.parser.parse(input);
        }

        @Override
        public Optional<T> parseValue(CharSequence input) {
            Objects.requireNonNull(input);
            return this.parser.parseValue(input);
        }

        @Generated
        public Adapter(nbbrd.io.text.Parser<T> parser) {
            this.parser = parser;
        }
    }

    private static final class Wrapper<T>
    extends Parser<T> {
        private final IParser<T> parser;

        @Override
        public T parse(CharSequence input) {
            return this.parser.parse(input);
        }

        @Override
        public Optional<T> parseValue(CharSequence input) {
            return this.parser.parseValue(input);
        }

        @Override
        public IParser<T> orElse(IParser<T> other) {
            return this.parser.orElse(other);
        }

        @Override
        public <X> IParser<X> andThen(Function<? super T, ? extends X> after) {
            return this.parser.andThen(after);
        }

        @Generated
        public Wrapper(IParser<T> parser) {
            this.parser = parser;
        }
    }

    public static abstract class FailSafeParser<T>
    extends Parser<T> {
        @Override
        public T parse(CharSequence input) throws NullPointerException {
            Objects.requireNonNull(input);
            try {
                return this.doParse(input);
            }
            catch (Exception ex) {
                return null;
            }
        }

        protected abstract @Nullable T doParse(@NonNull CharSequence var1) throws Exception;
    }
}

