/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.tsproviders.utils;

import ec.tss.tsproviders.utils.IParser;
import ec.tss.tsproviders.utils.Parsers;
import ec.tstoolkit.design.UtilityClass;
import ec.tstoolkit.timeseries.TsException;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import ec.tstoolkit.timeseries.simplets.TsPeriod;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.NonNull;

@UtilityClass(value={IParser.class})
public final class StrangeParsers {
    private StrangeParsers() {
    }

    public static @NonNull Parsers.Parser<Date> yearFreqPosParser() {
        return YearFreqPosParser.INSTANCE;
    }

    @Deprecated
    public static @NonNull Parsers.Parser<Number> onDoubleValueOf() {
        return DoubleValueOf.INSTANCE;
    }

    @Deprecated
    public static @NonNull Parsers.Parser<Number> onIntegerValueOf() {
        return IntegerValueOf.INSTANCE;
    }

    private static final class YearFreqPosParser
    extends Parsers.FailSafeParser<Date> {
        static final YearFreqPosParser INSTANCE = new YearFreqPosParser();
        private static final Pattern regex = Pattern.compile("(\\d+)-?([QMYST])(\\d+)");
        private static final int YEAR = 1;
        private static final int FREQ = 2;
        private static final int POS = 3;

        private YearFreqPosParser() {
        }

        @Override
        protected Date doParse(CharSequence input) throws Exception {
            Matcher m = regex.matcher(input);
            return m.matches() ? YearFreqPosParser.toDate(YearFreqPosParser.toInt(m.group(1)), YearFreqPosParser.toFreq(m.group(2)), YearFreqPosParser.toInt(m.group(3))) : null;
        }

        private static Date toDate(int year, TsFrequency freq, int pos) throws TsException {
            return new TsPeriod(freq, year, pos - 1).firstday().getTime();
        }

        private static int toInt(String input) {
            return Integer.parseInt(input);
        }

        private static TsFrequency toFreq(String input) {
            switch (input) {
                case "Q": {
                    return TsFrequency.Quarterly;
                }
                case "M": {
                    return TsFrequency.Monthly;
                }
                case "Y": {
                    return TsFrequency.Yearly;
                }
                case "S": {
                    return TsFrequency.HalfYearly;
                }
                case "T": {
                    return TsFrequency.QuadriMonthly;
                }
            }
            return TsFrequency.Undefined;
        }
    }

    private static final class DoubleValueOf
    extends Parsers.FailSafeParser<Number> {
        static final DoubleValueOf INSTANCE = new DoubleValueOf();

        private DoubleValueOf() {
        }

        @Override
        protected Number doParse(CharSequence input) throws Exception {
            return Double.valueOf(input.toString());
        }
    }

    private static final class IntegerValueOf
    extends Parsers.FailSafeParser<Number> {
        static final IntegerValueOf INSTANCE = new IntegerValueOf();

        private IntegerValueOf() {
        }

        @Override
        protected Number doParse(CharSequence input) throws Exception {
            return Integer.valueOf(input.toString());
        }
    }
}

