/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.tsproviders.utils;

import ec.tss.ITsProvider;
import ec.tss.TsAsyncMode;
import ec.tss.TsCollectionInformation;
import ec.tss.TsFactory;
import ec.tss.TsInformation;
import ec.tss.TsInformationType;
import ec.tss.TsMoniker;
import ec.tss.tsproviders.utils.AsyncRequests;
import ec.tss.tsproviders.utils.DataSourcePreconditions;
import ec.tss.tsproviders.utils.TsFiller;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.LockSupport;
import net.jcip.annotations.ThreadSafe;
import org.checkerframework.checker.nullness.qual.NonNull;

@ThreadSafe
public abstract class TsFillerAsProvider
implements ITsProvider {
    private final String providerName;
    private final Runnable cacheCleaner;
    private static final Runnable NO_CACHE = () -> {};

    public static @NonNull ITsProvider of(@NonNull String providerName, @NonNull TsAsyncMode asyncMode, @NonNull TsFiller filler) {
        return TsFillerAsProvider.of(providerName, asyncMode, filler, NO_CACHE);
    }

    public static @NonNull ITsProvider of(@NonNull String providerName, @NonNull TsAsyncMode asyncMode, @NonNull TsFiller filler, @NonNull Runnable cacheCleaner) {
        switch (asyncMode) {
            case None: {
                return new SyncImpl(providerName, filler, cacheCleaner);
            }
            case Dynamic: 
            case Once: {
                return new AsyncImpl(providerName, asyncMode, filler, cacheCleaner);
            }
        }
        throw new RuntimeException();
    }

    private TsFillerAsProvider(String providerName, Runnable cacheCleaner) {
        this.providerName = Objects.requireNonNull(providerName);
        this.cacheCleaner = Objects.requireNonNull(cacheCleaner);
    }

    @Override
    public String getSource() {
        return this.providerName;
    }

    @Override
    public void clearCache() {
        this.cacheCleaner.run();
    }

    private static final class SyncImpl
    extends TsFillerAsProvider {
        private final TsFiller filler;

        private SyncImpl(String providerName, TsFiller filler, Runnable cacheCleaner) {
            super(providerName, cacheCleaner);
            this.filler = Objects.requireNonNull(filler);
        }

        @Override
        public TsAsyncMode getAsyncMode() {
            return TsAsyncMode.None;
        }

        @Override
        public void dispose() {
            this.clearCache();
        }

        @Override
        public boolean get(TsCollectionInformation info) {
            DataSourcePreconditions.checkProvider(this.getSource(), info.moniker);
            return this.filler.fillCollection(info);
        }

        @Override
        public boolean get(TsInformation info) {
            DataSourcePreconditions.checkProvider(this.getSource(), info.moniker);
            return this.filler.fillSeries(info);
        }

        @Override
        public boolean queryTs(TsMoniker moniker, TsInformationType type) {
            Objects.requireNonNull(moniker, "Moniker cannot be null");
            Objects.requireNonNull(type, "Type cannot be null");
            throw new IllegalStateException("Not async provider");
        }

        @Override
        public boolean queryTsCollection(TsMoniker moniker, TsInformationType type) {
            Objects.requireNonNull(moniker, "Moniker cannot be null");
            Objects.requireNonNull(type, "Type cannot be null");
            throw new IllegalStateException("Not async provider");
        }
    }

    private static final class AsyncImpl
    extends TsFillerAsProvider {
        private final TsAsyncMode asyncMode;
        private final TsFiller filler;
        private final AsyncRequests asyncRequests;
        private final RequestsHandler2 requestsHandler;

        private AsyncImpl(String providerName, TsAsyncMode asyncMode, TsFiller filler, Runnable cacheCleaner) {
            super(providerName, cacheCleaner);
            this.asyncMode = Objects.requireNonNull(asyncMode);
            this.filler = Objects.requireNonNull(filler);
            this.asyncRequests = new AsyncRequests();
            this.requestsHandler = new RequestsHandler2(this.asyncRequests, filler);
            this.requestsHandler.start();
        }

        @Override
        public TsAsyncMode getAsyncMode() {
            return this.asyncMode;
        }

        @Override
        public void dispose() {
            this.requestsHandler.stop();
            this.asyncRequests.clear();
            this.clearCache();
        }

        @Override
        public boolean get(TsCollectionInformation info) {
            DataSourcePreconditions.checkProvider(this.getSource(), info.moniker);
            this.asyncRequests.removeTsCollection(info.moniker, info.type);
            return this.filler.fillCollection(info);
        }

        @Override
        public boolean get(TsInformation info) {
            DataSourcePreconditions.checkProvider(this.getSource(), info.moniker);
            this.asyncRequests.removeTs(info.moniker, info.type);
            return this.filler.fillSeries(info);
        }

        @Override
        public boolean queryTs(TsMoniker moniker, TsInformationType type) {
            Objects.requireNonNull(moniker, "Moniker cannot be null");
            Objects.requireNonNull(type, "Type cannot be null");
            DataSourcePreconditions.checkProvider(this.getSource(), moniker);
            if (type == TsInformationType.None) {
                this.asyncRequests.removeTs(moniker, TsInformationType.All);
            } else {
                boolean empty = this.asyncRequests.isEmpty();
                this.asyncRequests.addTs(moniker, type);
                if (empty) {
                    this.requestsHandler.unpark();
                }
            }
            return true;
        }

        @Override
        public boolean queryTsCollection(TsMoniker moniker, TsInformationType type) {
            Objects.requireNonNull(moniker, "Moniker cannot be null");
            Objects.requireNonNull(type, "Type cannot be null");
            DataSourcePreconditions.checkProvider(this.getSource(), moniker);
            if (type == TsInformationType.None) {
                this.asyncRequests.removeTsCollection(moniker, TsInformationType.All);
            } else {
                boolean empty = this.asyncRequests.isEmpty();
                this.asyncRequests.addTsCollection(moniker, type);
                if (empty) {
                    this.requestsHandler.unpark();
                }
            }
            return true;
        }
    }

    private static final class RequestsHandler2
    implements Runnable {
        private final AsyncRequests asyncRequests;
        private final TsFiller filler;
        private final Thread requestsThread;
        private final AtomicBoolean end;

        RequestsHandler2(AsyncRequests asyncRequests, TsFiller filler) {
            this.asyncRequests = asyncRequests;
            this.filler = filler;
            this.requestsThread = new Thread(this);
            this.end = new AtomicBoolean(false);
            this.requestsThread.setDaemon(true);
        }

        @Override
        public void run() {
            while (!this.end.get()) {
                this.processNextTsCollection();
                this.processNextTs();
                if (!this.asyncRequests.isEmpty()) continue;
                LockSupport.park();
            }
        }

        private void processNextTsCollection() {
            TsCollectionInformation crequest = this.asyncRequests.nextTsCollection();
            if (crequest != null && TsFactory.instance.isTsCollectionAlive(crequest.moniker)) {
                this.filler.fillCollection(crequest);
                TsFactory.instance.update(crequest);
            }
        }

        private void processNextTs() {
            TsInformation srequest = this.asyncRequests.nextTs();
            if (srequest != null && TsFactory.instance.isTsAlive(srequest.moniker)) {
                this.filler.fillSeries(srequest);
                TsFactory.instance.update(srequest);
            }
        }

        void start() {
            this.requestsThread.start();
        }

        void stop() {
            if (this.asyncRequests.isEmpty()) {
                LockSupport.unpark(this.requestsThread);
            }
            this.end.set(true);
        }

        void unpark() {
            LockSupport.unpark(this.requestsThread);
        }

        void park() {
            LockSupport.park(this.requestsThread);
        }
    }
}

