/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.tsproviders.utils;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Streams;
import ec.tstoolkit.design.IBuilder;
import ec.tstoolkit.utilities.URLEncoder2;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.function.BiConsumer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class UriBuilder
implements IBuilder<URI> {
    private final String scheme;
    private final String host;
    private String[] path;
    private SortedMap<String, String> query;
    private SortedMap<String, String> fragment;
    private static final Splitter PATH_SPLITTER = Splitter.on((char)'/');
    private static final Splitter ENTRY_SPLITTER = Splitter.on((char)'&');
    private static final Splitter KEY_VALUE_SPLITTER = Splitter.on((char)'=');

    public UriBuilder(@NonNull String scheme, @NonNull String host) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)scheme) ? 1 : 0) != 0, (Object)"scheme can't be null or empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)host) ? 1 : 0) != 0, (Object)"host can't be null or empty");
        this.scheme = scheme;
        this.host = host;
        this.reset();
    }

    public @NonNull UriBuilder reset() {
        this.path = null;
        this.query = null;
        this.fragment = null;
        return this;
    }

    public @NonNull UriBuilder path(String ... path) {
        this.path = path;
        return this;
    }

    public @NonNull UriBuilder query(@Nullable SortedMap<String, String> query) {
        this.query = query;
        return this;
    }

    public @NonNull UriBuilder fragment(@Nullable SortedMap<String, String> fragment) {
        this.fragment = fragment;
        return this;
    }

    public @NonNull String buildString() {
        StringBuilder result = new StringBuilder();
        result.append(this.scheme);
        result.append("://");
        result.append(this.host);
        if (this.path != null) {
            UriBuilder.appendArray(result.append('/'), this.path, '/');
        }
        if (this.query != null) {
            UriBuilder.appendMap(result.append('?'), this.query, '&', '=');
        }
        if (this.fragment != null) {
            UriBuilder.appendMap(result.append('#'), this.fragment, '&', '=');
        }
        return result.toString();
    }

    public URI build() {
        return URI.create(this.buildString());
    }

    private static String decodeUrlUtf8(String o) {
        try {
            return URLDecoder.decode(o, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static @NonNull StringBuilder appendEntry(@NonNull StringBuilder sb, @NonNull Map.Entry<String, String> o, char sep) {
        URLEncoder2.encode((StringBuilder)sb, (CharSequence)o.getKey(), (Charset)StandardCharsets.UTF_8);
        sb.append(sep);
        URLEncoder2.encode((StringBuilder)sb, (CharSequence)o.getValue(), (Charset)StandardCharsets.UTF_8);
        return sb;
    }

    private static @NonNull StringBuilder appendMap(@NonNull StringBuilder sb, @NonNull Map<String, String> keyValues, char sep1, char sep2) {
        if (!keyValues.isEmpty()) {
            Iterator<Map.Entry<String, String>> iterator = keyValues.entrySet().iterator();
            UriBuilder.appendEntry(sb, iterator.next(), sep2);
            while (iterator.hasNext()) {
                UriBuilder.appendEntry(sb.append(sep1), iterator.next(), sep2);
            }
        }
        return sb;
    }

    private static @NonNull StringBuilder appendArray(@NonNull StringBuilder sb, @NonNull String[] array, char sep) {
        if (array.length > 0) {
            int i = 0;
            URLEncoder2.encode((StringBuilder)sb, (CharSequence)array[i], (Charset)StandardCharsets.UTF_8);
            while (++i < array.length) {
                URLEncoder2.encode((StringBuilder)sb.append(sep), (CharSequence)array[i], (Charset)StandardCharsets.UTF_8);
            }
        }
        return sb;
    }

    public static @Nullable String[] getPathArray(@NonNull URI uri) {
        String path = uri.getRawPath();
        return path != null && !path.isEmpty() ? UriBuilder.splitToArray(path.subSequence(1, path.length())) : null;
    }

    public static @Nullable String[] getPathArray(@NonNull URI uri, int expectedSize) {
        String path = uri.getRawPath();
        return path != null && !path.isEmpty() ? UriBuilder.splitToArray(path.subSequence(1, path.length()), expectedSize) : null;
    }

    public static @Nullable Map<String, String> getQueryMap(@NonNull URI uri) {
        String query = uri.getRawQuery();
        return query != null ? UriBuilder.splitMap(query) : null;
    }

    public static @Nullable Map<String, String> getFragmentMap(@NonNull URI uri) {
        String fragment = uri.getRawFragment();
        return fragment != null ? UriBuilder.splitMap(fragment) : null;
    }

    private static @Nullable String[] splitToArray(@NonNull CharSequence input) {
        return (String[])Streams.stream((Iterable)PATH_SPLITTER.split(input)).map(UriBuilder::decodeUrlUtf8).toArray(String[]::new);
    }

    private static @Nullable String[] splitToArray(@NonNull CharSequence input, int expectedSize) {
        Iterator items = PATH_SPLITTER.split(input).iterator();
        if (expectedSize == 0 || !items.hasNext()) {
            return null;
        }
        String[] result = new String[expectedSize];
        int index = 0;
        do {
            result[index++] = UriBuilder.decodeUrlUtf8((String)items.next());
        } while (index < expectedSize && items.hasNext());
        return !items.hasNext() && index == expectedSize ? result : null;
    }

    private static @Nullable Map<String, String> splitMap(@NonNull CharSequence input) {
        if (input.length() == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, String> result = new HashMap<String, String>();
        return UriBuilder.splitMapTo(input, result::put) ? result : null;
    }

    private static boolean splitMapTo(@NonNull CharSequence input, @NonNull BiConsumer<String, String> consumer) {
        for (String entry : ENTRY_SPLITTER.split(input)) {
            Iterator entryFields = KEY_VALUE_SPLITTER.split((CharSequence)entry).iterator();
            if (!entryFields.hasNext()) {
                return false;
            }
            String key = (String)entryFields.next();
            if (!entryFields.hasNext()) {
                return false;
            }
            String value = (String)entryFields.next();
            if (entryFields.hasNext()) {
                return false;
            }
            consumer.accept(UriBuilder.decodeUrlUtf8(key), UriBuilder.decodeUrlUtf8(value));
        }
        return true;
    }
}

