/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.xml;

import ec.tss.TsInformation;
import ec.tss.TsInformationType;
import ec.tss.TsMoniker;
import ec.tss.xml.IXmlConverter;
import ec.tss.xml.XmlMetaData;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import ec.tstoolkit.timeseries.simplets.TsPeriod;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlList;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(name="ts")
@XmlType(name="tsType")
public class XmlTs
implements IXmlConverter<TsInformation> {
    static final String NAME = "tsType";
    static final String RNAME = "ts";
    @XmlElement
    public Integer freq;
    @XmlElement
    public Integer firstYear;
    @XmlElement
    public Integer firstPeriod;
    @XmlElement(name="data")
    @XmlList
    public double[] data;
    @XmlElement
    public XmlMetaData metaData;
    @XmlAttribute
    public String name;
    @XmlAttribute
    public String source;
    @XmlAttribute
    public String identifier;

    @Override
    public void copy(TsInformation t) {
        TsData tsdata = t.data;
        if (tsdata != null) {
            TsPeriod start = tsdata.getStart();
            this.freq = start.getFrequency().intValue();
            this.firstYear = start.getYear();
            this.firstPeriod = start.getPosition() + 1;
            this.data = tsdata.internalStorage();
        }
        this.source = t.moniker.getSource();
        this.identifier = t.moniker.getId();
        this.name = t.name;
        if (t.metaData != null && !t.metaData.isEmpty()) {
            this.metaData = new XmlMetaData();
            this.metaData.copy(t.metaData);
        }
    }

    @Override
    public TsInformation create() {
        TsMoniker moniker = TsMoniker.create(this.source, this.identifier);
        TsInformation info = new TsInformation(this.name, moniker, this.data != null ? TsInformationType.UserDefined : TsInformationType.None);
        if (this.metaData != null) {
            info.metaData = this.metaData.create();
        }
        if (this.data != null) {
            info.data = new TsData(TsFrequency.valueOf((int)this.freq), this.firstYear.intValue(), this.firstPeriod - 1, this.data, false);
        }
        return info;
    }
}

