/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.xml;

import ec.tss.Ts;
import ec.tss.TsCollection;
import ec.tss.TsCollectionInformation;
import ec.tss.TsFactory;
import ec.tss.TsInformation;
import ec.tss.TsInformationType;
import ec.tss.TsMoniker;
import ec.tss.xml.IXmlConverter;
import ec.tss.xml.XmlMetaData;
import ec.tss.xml.XmlTs;
import java.util.ArrayList;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(name="tsCollection")
@XmlType(name="tsCollectionType")
public class XmlTsCollection
implements IXmlConverter<TsCollectionInformation> {
    static final String NAME = "tsCollectionType";
    static final String RNAME = "tsCollection";
    @XmlElement
    public XmlMetaData metadata;
    @XmlAttribute
    public String name;
    @XmlAttribute
    public String source;
    @XmlAttribute
    public String identifier;
    @XmlElement(name="ts")
    @XmlElementWrapper(name="data")
    public XmlTs[] tslist;

    @Override
    public void copy(TsCollectionInformation t) {
        this.source = t.moniker.getSource();
        this.identifier = t.moniker.getId();
        this.name = t.name;
        if (t.metaData == null || t.metaData.isEmpty()) {
            this.metadata = null;
        } else {
            this.metadata = new XmlMetaData();
            this.metadata.copy(t.metaData);
        }
        int n = t.items.size();
        if (n > 0) {
            this.tslist = new XmlTs[n];
            for (int i = 0; i < n; ++i) {
                XmlTs s = new XmlTs();
                s.copy(t.items.get(i));
                this.tslist[i] = s;
            }
        } else {
            this.tslist = null;
        }
    }

    @Override
    public TsCollectionInformation create() {
        TsMoniker moniker = TsMoniker.create(this.source, this.identifier);
        TsCollectionInformation cinfo = new TsCollectionInformation(moniker, TsInformationType.UserDefined);
        cinfo.name = this.name;
        if (this.metadata != null) {
            cinfo.metaData = this.metadata.create();
        }
        if (this.tslist != null) {
            for (int i = 0; i < this.tslist.length; ++i) {
                cinfo.items.add(this.tslist[i].create());
            }
        }
        return cinfo;
    }

    public TsCollection createTSCollection() {
        TsCollectionInformation info = this.create();
        if (info == null) {
            return null;
        }
        ArrayList<Ts> ts = new ArrayList<Ts>();
        if (info.items != null) {
            for (TsInformation tsinfo : info.items) {
                ts.add(TsFactory.instance.createTs(tsinfo.name, tsinfo.moniker, tsinfo.metaData, tsinfo.data));
            }
        }
        return TsFactory.instance.createTsCollection(info.name, info.moniker, info.metaData, ts);
    }
}

