/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.xml.algorithm;

import ec.tss.xml.IXmlConverter;
import ec.tss.xml.algorithm.XmlBatchLink;
import ec.tss.xml.algorithm.XmlBatchStep;
import ec.tss.xml.algorithm.XmlProcessingContext;
import ec.tss.xml.information.XmlInformationSet;
import ec.tstoolkit.algorithm.BatchProcessingFactory;
import ec.tstoolkit.algorithm.IProcSpecification;
import ec.tstoolkit.algorithm.ProcessingManager;
import ec.tstoolkit.information.InformationSet;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(name="batch")
@XmlType(name="batchType")
public class XmlBatch
implements IXmlConverter<BatchProcessingFactory> {
    static final String NAME = "batchType";
    static final String RNAME = "batch";
    @XmlElement
    public XmlProcessingContext context;
    @XmlElement
    public XmlInformationSet input;
    @XmlElement
    public XmlBatchStep[] step;
    @XmlElement
    public String[] filter;

    @Override
    public BatchProcessingFactory create() {
        BatchProcessingFactory fac = new BatchProcessingFactory();
        if (this.step != null) {
            for (int i = 0; i < this.step.length; ++i) {
                InformationSet spec = this.step[i].specification.create();
                IProcSpecification pspec = ProcessingManager.getInstance().createSpecification(spec);
                if (pspec == null) {
                    return null;
                }
                fac.add(new BatchProcessingFactory.Node(this.step[i].name, pspec, this.step[i].link.linktype, this.step[i].link.linkid));
            }
        }
        return fac;
    }

    @Override
    public void copy(BatchProcessingFactory t) {
        List nodes = t.nodes();
        this.step = new XmlBatchStep[nodes.size()];
        int cur = 0;
        for (BatchProcessingFactory.Node node : nodes) {
            XmlBatchStep bstep = new XmlBatchStep();
            bstep.name = node.name;
            bstep.specification = new XmlInformationSet();
            bstep.specification.copy(node.specification.write(false));
            bstep.link = new XmlBatchLink();
            bstep.link.linktype = node.linkType;
            bstep.link.linkid = node.linkId;
            this.step[cur++] = bstep;
        }
    }
}

