/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.xml.algorithm;

import ec.tss.xml.IXmlConverter;
import ec.tss.xml.algorithm.XmlBatchLink;
import ec.tss.xml.algorithm.XmlBatchStep;
import ec.tss.xml.information.XmlInformationSet;
import ec.tstoolkit.algorithm.BatchProcessingFactory;
import ec.tstoolkit.algorithm.IProcSpecification;
import ec.tstoolkit.algorithm.ProcessingManager;
import ec.tstoolkit.information.InformationSet;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(name="batchSpecification")
@XmlType(name="batchSpecificationType")
public class XmlBatchSpecification
implements IXmlConverter<BatchProcessingFactory> {
    static final String NAME = "batchSpecificationType";
    static final String RNAME = "batchSpecification";
    @XmlElement
    public XmlBatchStep[] steps;

    @Override
    public BatchProcessingFactory create() {
        BatchProcessingFactory fac = new BatchProcessingFactory();
        if (this.steps != null) {
            for (int i = 0; i < this.steps.length; ++i) {
                InformationSet spec = this.steps[i].specification.create();
                IProcSpecification pspec = ProcessingManager.getInstance().createSpecification(spec);
                if (pspec == null) {
                    return null;
                }
                fac.add(new BatchProcessingFactory.Node(this.steps[i].name, pspec, this.steps[i].link.linktype, this.steps[i].link.linkid));
            }
        }
        return fac;
    }

    @Override
    public void copy(BatchProcessingFactory t) {
        List nodes = t.nodes();
        this.steps = new XmlBatchStep[nodes.size()];
        int cur = 0;
        for (BatchProcessingFactory.Node node : nodes) {
            XmlBatchStep step = new XmlBatchStep();
            step.name = node.name;
            step.specification = new XmlInformationSet();
            step.specification.copy(node.specification.write(false));
            step.link = new XmlBatchLink();
            step.link.linktype = node.linkType;
            step.link.linkid = node.linkId;
            this.steps[cur++] = step;
        }
    }
}

