/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.xml.arima;

import ec.tss.xml.IXmlConverter;
import ec.tstoolkit.arima.ArimaModel;
import ec.tstoolkit.maths.linearfilters.BackFilter;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlList;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(name="arimaModel")
@XmlType(name="arimaModelType")
public class XmlArimaModel
implements IXmlConverter<ArimaModel> {
    static final String NAME = "arimaModelType";
    static final String RNAME = "arimaModel";
    @XmlAttribute
    public String name;
    @XmlElement(name="ar")
    @XmlList
    public double[] ar;
    @XmlElement(name="differencing")
    @XmlList
    public double[] differencing;
    @XmlElement(name="ma")
    @XmlList
    public double[] ma;
    @XmlAttribute
    public double innovationVariance;

    @Override
    public ArimaModel create() {
        BackFilter far = null;
        BackFilter fd = null;
        BackFilter fma = null;
        if (this.ar != null) {
            far = BackFilter.of((double[])this.ar);
        }
        if (this.differencing != null) {
            fd = BackFilter.of((double[])this.differencing);
        }
        if (this.ma != null) {
            fma = BackFilter.of((double[])this.ma);
        }
        return new ArimaModel(far, fd, fma, this.innovationVariance);
    }

    @Override
    public void copy(ArimaModel t) {
        this.ar = t.getStationaryAR().getPolynomial().getCoefficients();
        this.differencing = t.getNonStationaryAR().getPolynomial().getCoefficients();
        this.ma = t.getMA().getPolynomial().getCoefficients();
        this.innovationVariance = t.getInnovationVariance();
    }
}

