/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.xml.arima;

import ec.tss.xml.IXmlConverter;
import ec.tstoolkit.arima.LinearModel;
import ec.tstoolkit.maths.linearfilters.BackFilter;
import ec.tstoolkit.maths.linearfilters.FiniteFilter;
import ec.tstoolkit.maths.linearfilters.ForeFilter;
import ec.tstoolkit.maths.linearfilters.IFiniteFilter;
import ec.tstoolkit.maths.linearfilters.RationalFilter;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlList;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(name="linearModel")
@XmlType(name="linearModelType")
public class XmlLinearModel
implements IXmlConverter<LinearModel> {
    static final String NAME = "linearModelType";
    static final String RNAME = "linearModel";
    @XmlAttribute
    public String name;
    @XmlElement(name="bar")
    @XmlList
    public double[] bar;
    @XmlElement(name="far")
    @XmlList
    public double[] far;
    @XmlElement(name="ma")
    @XmlList
    public double[] ma;
    @XmlElement
    public int lb;
    @XmlAttribute
    public double innovationVariance;

    @Override
    public LinearModel create() {
        ForeFilter pfar = null;
        BackFilter pbar = null;
        FiniteFilter pma = null;
        if (this.bar != null) {
            pbar = BackFilter.of((double[])this.bar);
        }
        if (this.far != null) {
            pfar = new ForeFilter(this.far);
        }
        if (this.ma != null) {
            pma = new FiniteFilter(this.ma, this.lb);
        }
        RationalFilter rf = new RationalFilter(pma, pbar, pfar);
        return new LinearModel(rf, this.innovationVariance);
    }

    @Override
    public void copy(LinearModel t) {
        RationalFilter rf = t.getFilter();
        if (rf != null) {
            this.bar = rf.getRationalBackFilter().getDenominator().getPolynomial().getCoefficients();
            this.far = rf.getRationalForeFilter().getDenominator().getPolynomial().getCoefficients();
        }
        IFiniteFilter num = t.getFilter().getNumerator();
        this.ma = num.getWeights();
        this.lb = num.getLowerBound();
        this.innovationVariance = t.getInnovationVariance();
    }
}

