/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.xml.arima;

import ec.tss.xml.IXmlConverter;
import ec.tstoolkit.sarima.SarimaModel;
import ec.tstoolkit.sarima.SarimaSpecification;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlList;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(name="sarimaModel")
@XmlType(name="sarimaModelType")
public class XmlSarima
implements IXmlConverter<SarimaModel> {
    static final String NAME = "sarimaModelType";
    static final String RNAME = "sarimaModel";
    @XmlAttribute
    public String name;
    @XmlElement(name="phi")
    @XmlList
    public double[] phi;
    @XmlElement
    public int d;
    @XmlElement(name="theta")
    @XmlList
    public double[] theta;
    public int s;
    @XmlElement(name="bphi")
    @XmlList
    public double[] bphi;
    @XmlElement
    public int bd;
    @XmlElement(name="btheta")
    @XmlList
    public double[] btheta;

    public boolean getDSpecified() {
        return this.d > 0;
    }

    public boolean getSSpecified() {
        return this.s > 1;
    }

    public boolean getBdSpecified() {
        return this.bd > 0;
    }

    @Override
    public void copy(SarimaModel t) {
        int i;
        SarimaSpecification spec = t.getSpecification();
        this.d = spec.getD();
        this.bd = spec.getBD();
        this.s = spec.getFrequency();
        if (spec.getP() > 0) {
            this.phi = new double[spec.getP() - 1];
            for (i = 1; i <= spec.getP(); ++i) {
                this.phi[i - 1] = t.phi(i);
            }
        }
        if (spec.getQ() > 0) {
            this.theta = new double[spec.getQ() - 1];
            for (i = 1; i <= spec.getQ(); ++i) {
                this.theta[i - 1] = t.theta(i);
            }
        }
        if (spec.getBP() > 0) {
            this.bphi = new double[]{t.bphi(1)};
        }
        if (spec.getBQ() > 0) {
            this.btheta = new double[]{t.btheta(1)};
        }
    }

    @Override
    public SarimaModel create() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

