/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.xml.sa;

import ec.satoolkit.ISaSpecification;
import ec.tss.Ts;
import ec.tss.TsFactory;
import ec.tss.TsInformation;
import ec.tss.TsInformationType;
import ec.tss.sa.SaItem;
import ec.tss.sa.SaProcessing;
import ec.tss.xml.IXmlConverter;
import ec.tss.xml.XmlMetaData;
import ec.tss.xml.XmlTs;
import ec.tss.xml.sa.AbstractXmlSaSpecification;
import ec.tss.xml.sa.XmlSaItem;
import ec.tss.xml.tramoseats.XmlTramoSeatsSpecification;
import ec.tss.xml.x12.XmlX12Specification;
import ec.tss.xml.x13.XmlX13Specification;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(name="saProcessing")
@XmlType(name="saProcessingType")
public class XmlSaProcessing
implements IXmlConverter<SaProcessing> {
    static final String NAME = "saProcessingType";
    static final String RNAME = "saProcessing";
    @XmlAttribute
    public Date timeStamp;
    @XmlElement
    public XmlMetaData metadata;
    @XmlElements(value={@XmlElement(name="trsSpec", type=XmlTramoSeatsSpecification.class), @XmlElement(name="x13Spec", type=XmlX13Specification.class), @XmlElement(name="x12Spec", type=XmlX12Specification.class)})
    public AbstractXmlSaSpecification[] defaultMethods;
    @XmlElementWrapper(name="items")
    @XmlElement(name="saItem")
    public XmlSaItem[] items;

    @Override
    public SaProcessing create() {
        SaProcessing processing = new SaProcessing();
        HashMap<String, ISaSpecification> dic = new HashMap<String, ISaSpecification>();
        if (this.defaultMethods != null) {
            for (AbstractXmlSaSpecification xspec : this.defaultMethods) {
                dic.put(xspec.name, xspec.convert(true));
            }
        }
        if (this.items != null) {
            for (XmlSaItem xitem : this.items) {
                TsInformation info = xitem.series.create();
                Ts s = TsFactory.instance.createTs(info.name, info.moniker, info.metaData, info.data);
                ISaSpecification spec = null;
                if (xitem.spec != null) {
                    spec = xitem.spec.convert(false);
                }
                ISaSpecification espec = null;
                if (xitem.espec != null) {
                    espec = xitem.espec.convert(false);
                }
                ISaSpecification defspec = (ISaSpecification)dic.get(xitem.defaultMethod);
                SaItem item = null;
                if (spec != null) {
                    item = new SaItem(defspec, xitem.policy, espec, s);
                    item.setPointSpecification(spec);
                } else {
                    item = new SaItem(defspec, s);
                }
                item.setPriority(xitem.priority);
                item.setQuality(xitem.quality);
                item.setStatus(xitem.status);
                processing.add(item);
            }
        }
        processing.getMetaData().put("TimeStamp", this.timeStamp.toString());
        return processing;
    }

    @Override
    public void copy(SaProcessing t) {
        this.timeStamp = new Date();
        int n = t.size();
        if (n > 0) {
            HashMap<ISaSpecification, String> dic = new HashMap<ISaSpecification, String>();
            XmlSaItem[] xitems = new XmlSaItem[n];
            ArrayList<AbstractXmlSaSpecification> xdspecs = new ArrayList<AbstractXmlSaSpecification>();
            int i = 0;
            int ispec = 1;
            Iterator iterator = t.iterator();
            while (iterator.hasNext()) {
                SaItem item = (SaItem)iterator.next();
                XmlSaItem xitem = new XmlSaItem();
                xitem.series = new XmlTs();
                if (item.getMoniker().isAnonymous()) {
                    xitem.series.copy(item.getTs().toInfo(TsInformationType.All));
                } else if (item.getStatus() == SaItem.Status.Unprocessed) {
                    xitem.series.copy(item.getTs().toInfo(TsInformationType.Definition));
                } else {
                    xitem.series.copy(item.getTs().freeze().toInfo(TsInformationType.All));
                }
                xitem.priority = item.getPriority();
                xitem.quality = item.getQuality();
                xitem.policy = item.getEstimationPolicy();
                xitem.status = item.getStatus();
                ISaSpecification rspec = item.getPointSpecification();
                ISaSpecification dspec = item.getDomainSpecification();
                if (rspec != null) {
                    xitem.spec = AbstractXmlSaSpecification.create(rspec);
                }
                if (item.getEstimationSpecification() != item.getDomainSpecification()) {
                    xitem.espec = AbstractXmlSaSpecification.create(item.getEstimationSpecification());
                }
                if (dspec != null) {
                    String name;
                    if (!dic.containsKey(dspec)) {
                        name = "spec" + Integer.toString(ispec++);
                        dic.put(dspec, name);
                        AbstractXmlSaSpecification xdspec = AbstractXmlSaSpecification.create(dspec);
                        xdspec.name = name;
                        xdspecs.add(xdspec);
                    } else {
                        name = (String)dic.get(dspec);
                    }
                    xitem.defaultMethod = name;
                }
                xitems[i++] = xitem;
            }
            this.items = xitems;
            this.defaultMethods = (AbstractXmlSaSpecification[])xdspecs.stream().toArray(AbstractXmlSaSpecification[]::new);
        }
    }
}

