/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.xml.tramoseats;

import ec.satoolkit.seats.SeatsSpecification;
import ec.tss.xml.IXmlConverter;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlType(name="seatsSpecType")
public class XmlSeatsSpec
implements IXmlConverter<SeatsSpecification> {
    static final String NAME = "seatsSpecType";
    @XmlElement
    public Double epsphi;
    @XmlElement
    public Double rmod;
    @XmlElement
    public Double xl;
    @XmlElement
    public SeatsSpecification.ApproximationMode mode;

    public boolean isEpsphiSpecified() {
        return this.epsphi != null;
    }

    public boolean isRmodSpecified() {
        return this.rmod != null;
    }

    public boolean isXlSpecified() {
        return this.xl != null;
    }

    @Override
    public SeatsSpecification create() {
        SeatsSpecification spec = new SeatsSpecification();
        if (this.isEpsphiSpecified()) {
            spec.setSeasTolerance(this.epsphi.doubleValue());
        }
        if (this.isRmodSpecified()) {
            spec.setTrendBoundary(this.rmod.doubleValue());
        }
        if (this.isXlSpecified()) {
            spec.setXlBoundary(this.xl.doubleValue());
        }
        if (this.mode != null) {
            spec.setApproximationMode(this.mode);
        }
        return spec;
    }

    @Override
    public void copy(SeatsSpecification t) {
        if (t.getSeasTolerance() != 2.0) {
            this.epsphi = t.getSeasTolerance();
        }
        if (t.getTrendBoundary() != 0.5) {
            this.rmod = t.getTrendBoundary();
        }
        if (t.getXlBoundary() != 0.95) {
            this.xl = t.getXlBoundary();
        }
        if (t.getApproximationMode() != SeatsSpecification.ApproximationMode.Legacy) {
            this.mode = t.getApproximationMode();
        }
    }
}

