/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.xml.tramoseats;

import ec.satoolkit.tramoseats.TramoSeatsSpecification;
import ec.tss.xml.tramoseats.IXmlTramoSeatsSpec;
import ec.tstoolkit.modelling.RegressionTestType;
import ec.tstoolkit.modelling.arima.tramo.CalendarSpec;
import ec.tstoolkit.modelling.arima.tramo.RegressionSpec;
import ec.tstoolkit.modelling.arima.tramo.TradingDaysSpec;
import ec.tstoolkit.timeseries.calendars.LengthOfPeriodType;
import ec.tstoolkit.timeseries.calendars.TradingDaysType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlType;

@XmlType(name="tradingDaysSpecType")
public class XmlTradingDaysSpec
implements IXmlTramoSeatsSpec {
    static final String NAME = "tradingDaysSpecType";
    @XmlElement
    public String calendar;
    @XmlElement(name="string")
    @XmlElementWrapper(name="userVariables")
    public String[] userVariables;
    @XmlElement
    public TradingDaysType tdOption = TradingDaysType.None;
    @XmlElement
    public LengthOfPeriodType lpOption = LengthOfPeriodType.None;
    @XmlAttribute
    public Boolean pretest;
    @XmlAttribute
    public RegressionTestType testType;

    public boolean isTdOptionSpecified() {
        return this.tdOption != null;
    }

    public boolean isLpOptionSpecified() {
        return this.lpOption != null;
    }

    public boolean isPretestSpecified() {
        return this.pretest != null;
    }

    public static XmlTradingDaysSpec create(CalendarSpec cspec) {
        if (cspec == null || !cspec.getTradingDays().isUsed()) {
            return null;
        }
        TradingDaysSpec td = cspec.getTradingDays();
        XmlTradingDaysSpec xspec = new XmlTradingDaysSpec();
        xspec.tdOption = td.getTradingDaysType();
        xspec.lpOption = td.isLeapYear() ? LengthOfPeriodType.LeapYear : LengthOfPeriodType.None;
        xspec.testType = td.getRegressionTestType();
        xspec.calendar = cspec.getTradingDays().getHolidays();
        xspec.userVariables = cspec.getTradingDays().getUserVariables();
        return xspec;
    }

    @Override
    public void copyTo(TramoSeatsSpecification spec) {
        RegressionSpec reg = spec.getTramoSpecification().getRegression();
        CalendarSpec cspec = reg.getCalendar();
        TradingDaysSpec tdspec = cspec.getTradingDays();
        if (this.isTdOptionSpecified()) {
            tdspec.setTradingDaysType(this.tdOption);
        }
        if (this.isLpOptionSpecified()) {
            tdspec.setLeapYear(this.lpOption != null);
        }
        if (this.isPretestSpecified()) {
            tdspec.setTest(this.pretest.booleanValue());
        } else if (this.testType != null) {
            tdspec.setRegressionTestType(this.testType);
        }
        if (this.calendar != null) {
            tdspec.setHolidays(this.calendar);
        }
        if (this.userVariables != null) {
            tdspec.setUserVariables(this.userVariables);
        }
    }
}

