/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.xml.uscb;

import ec.tss.xml.IXmlConverter;
import ec.tss.xml.XmlPeriodSelection;
import ec.tss.xml.uscb.XmlSingleOutlierSpec;
import ec.tstoolkit.modelling.arima.x13.OutlierSpec;
import ec.tstoolkit.modelling.arima.x13.SingleOutlierSpec;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlType;

@XmlType(name="outlierSpecType")
public class XmlOutlierSpec
implements IXmlConverter<OutlierSpec> {
    static final String NAME = "outlierSpecType";
    @XmlElement
    public XmlPeriodSelection span;
    @XmlElement
    public Double defaultCv;
    @XmlElementWrapper
    @XmlElement(name="outlier")
    public XmlSingleOutlierSpec[] type;
    @XmlElement
    public Integer lsrun;
    @XmlElement
    public OutlierSpec.Method method = OutlierSpec.Method.AddOne;
    @XmlElement
    public Double tcrate = 0.7;

    public static XmlOutlierSpec create(OutlierSpec spec) {
        if (spec == null) {
            return null;
        }
        XmlOutlierSpec x = new XmlOutlierSpec();
        x.copy(spec);
        x.defaultCv = spec.getDefaultCriticalValue();
        return x;
    }

    public void copyTo(OutlierSpec spec) {
        if (this.span != null) {
            spec.setSpan(this.span.create());
        }
        if (this.defaultCv != null) {
            spec.setDefaultCriticalValue(this.defaultCv.doubleValue());
        }
        if (this.type != null) {
            for (int i = 0; i < this.type.length; ++i) {
                spec.add(this.type[i].create());
            }
        }
        if (this.lsrun != null) {
            spec.setLSRun(this.lsrun.intValue());
        }
        if (this.method != null) {
            spec.setMethod(this.method);
        }
        if (this.tcrate != null) {
            spec.setMonthlyTCRate(this.tcrate.doubleValue());
        }
    }

    @Override
    public OutlierSpec create() {
        OutlierSpec spec = new OutlierSpec();
        this.copyTo(spec);
        return spec;
    }

    @Override
    public void copy(OutlierSpec t) {
        SingleOutlierSpec[] types;
        if (t.getSpan() != null) {
            this.span = new XmlPeriodSelection();
            this.span.copy(t.getSpan());
        }
        if ((types = t.getTypes()) != null && types.length > 0) {
            this.type = new XmlSingleOutlierSpec[types.length];
            for (int i = 0; i < types.length; ++i) {
                this.type[i] = new XmlSingleOutlierSpec();
                this.type[i].copy(types[i]);
            }
        }
        if (t.getMethod() != OutlierSpec.Method.AddOne) {
            this.method = t.getMethod();
        }
        if (t.getMonthlyTCRate() != 0.7) {
            this.tcrate = t.getMonthlyTCRate();
        }
    }
}

