/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.xml.uscb;

import ec.tss.xml.IXmlConverter;
import ec.tss.xml.uscb.AbstractXmlTdVariables;
import ec.tss.xml.uscb.XmlChangeOfRegimeSpec;
import ec.tstoolkit.modelling.RegressionTestSpec;
import ec.tstoolkit.modelling.arima.x13.RegressionSpec;
import ec.tstoolkit.modelling.arima.x13.TradingDaysSpec;
import ec.tstoolkit.timeseries.calendars.LengthOfPeriodType;
import ec.tstoolkit.timeseries.calendars.TradingDaysType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlType;

@XmlType(name="tdVariableSpecType")
public class XmlTradingDaysSpec
extends AbstractXmlTdVariables
implements IXmlConverter<TradingDaysSpec> {
    static final String NAME = "tdVariableSpecType";
    @XmlElement
    public XmlTradingDaysOption tdoption = XmlTradingDaysOption.None;
    @XmlElement
    public XmlLengthOfPeriodOption lpoption = XmlLengthOfPeriodOption.None;
    @XmlElement
    public RegressionTestSpec aicTest = RegressionTestSpec.None;
    @XmlElement
    public XmlChangeOfRegimeSpec changeOfRegime;
    @XmlElement
    public String holidays;
    @XmlElement(name="string")
    @XmlElementWrapper(name="userVariables")
    public String[] userVariables;

    public boolean isTdoptionSpecified() {
        return this.tdoption != XmlTradingDaysOption.None;
    }

    public boolean isLpoptionSpecified() {
        return this.lpoption != XmlLengthOfPeriodOption.None;
    }

    public boolean isAicTestSpecified() {
        return this.aicTest != RegressionTestSpec.None;
    }

    @Override
    public void copyTo(RegressionSpec spec) {
        spec.setTradingDays(this.create());
    }

    @Override
    public TradingDaysSpec create() {
        TradingDaysSpec spec = new TradingDaysSpec();
        spec.setTest(this.aicTest);
        spec.setHolidays(this.holidays);
        spec.setUserVariables(this.userVariables);
        switch (this.tdoption.ordinal()) {
            case 1: {
                spec.setTradingDaysType(TradingDaysType.TradingDays);
                spec.setLengthOfPeriod(LengthOfPeriodType.LeapYear);
                break;
            }
            case 3: {
                spec.setTradingDaysType(TradingDaysType.WorkingDays);
                spec.setLengthOfPeriod(LengthOfPeriodType.LeapYear);
                break;
            }
            case 2: {
                spec.setAutoAdjust(false);
                spec.setTradingDaysType(TradingDaysType.TradingDays);
                break;
            }
            case 4: {
                spec.setAutoAdjust(false);
                spec.setTradingDaysType(TradingDaysType.WorkingDays);
            }
        }
        if (!spec.isAutoAdjust()) {
            switch (this.lpoption.ordinal()) {
                case 1: {
                    spec.setLengthOfPeriod(LengthOfPeriodType.LeapYear);
                    break;
                }
                case 2: {
                    spec.setLengthOfPeriod(LengthOfPeriodType.LengthOfPeriod);
                }
            }
        }
        return spec;
    }

    @Override
    public void copy(TradingDaysSpec t) {
        this.aicTest = t.getTest();
        switch (t.getTradingDaysType()) {
            case TradingDays: {
                if (t.isAutoAdjust() && t.getLengthOfPeriod() != LengthOfPeriodType.None) {
                    this.tdoption = XmlTradingDaysOption.Td;
                    break;
                }
                this.tdoption = XmlTradingDaysOption.TdNoLpYear;
                break;
            }
            case WorkingDays: {
                this.tdoption = t.isAutoAdjust() && t.getLengthOfPeriod() != LengthOfPeriodType.None ? XmlTradingDaysOption.Td1Coef : XmlTradingDaysOption.Td1NoLpYear;
            }
        }
        if (!t.isAutoAdjust()) {
            switch (t.getLengthOfPeriod()) {
                case LeapYear: {
                    this.lpoption = XmlLengthOfPeriodOption.LpYear;
                    break;
                }
                case LengthOfPeriod: {
                    this.lpoption = XmlLengthOfPeriodOption.LengthofPeriod;
                }
            }
        }
        this.holidays = t.getHolidays();
        this.userVariables = t.getUserVariables();
    }

    public static enum XmlTradingDaysOption {
        None,
        Td,
        TdNoLpYear,
        Td1Coef,
        Td1NoLpYear;

    }

    public static enum XmlLengthOfPeriodOption {
        None,
        LpYear,
        LengthofPeriod;

    }
}

