/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.xml.x12;

import ec.satoolkit.x13.X13Specification;
import ec.tss.xml.uscb.AbstractXmlArimaSpec;
import ec.tstoolkit.modelling.arima.x13.AutoModelSpec;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlType(name="autoModelSpecType")
public class XmlAutoModelSpec
extends AbstractXmlArimaSpec {
    static final String NAME = "autoModelSpecType";
    @XmlElement
    public Boolean acceptDef;
    @XmlElement
    public Boolean checkMu;
    @XmlElement
    public Boolean mixed;
    @XmlElement
    public Boolean balanced;
    @XmlElement
    public Boolean hr;
    @XmlElement
    public Double cancel = 0.1;
    @XmlElement
    public Double fct = 1.0126582278481011;
    @XmlElement
    public Double ljungbox = 0.95;
    @XmlElement
    public Double predcv = 0.14286;
    @XmlElement
    public Double armaLimit = 1.0;
    @XmlElement
    public Double ub1 = 1.0416666666666667;
    @XmlElement
    public Double ub2 = 0.88;
    @XmlElement
    public Double ubFinal = 1.05;

    private boolean isAcceptDefSpecified() {
        return this.acceptDef != null;
    }

    public boolean isCheckMuSpecified() {
        return this.checkMu != null;
    }

    public boolean isMixedSpecified() {
        return this.mixed != null;
    }

    public boolean isBalancedSpecified() {
        return this.balanced != null;
    }

    public boolean isHrSpecified() {
        return this.hr != null;
    }

    public boolean isCancelSpecified() {
        return this.cancel != null;
    }

    public boolean isFctSpecified() {
        return this.fct != null;
    }

    public boolean isLjungboxSpecified() {
        return this.ljungbox != null;
    }

    public boolean isPredcvSpecified() {
        return this.predcv != null;
    }

    public boolean isArmaLimitSpecified() {
        return this.armaLimit != null;
    }

    public boolean isUb1Specified() {
        return this.ub1 != null;
    }

    public boolean isUb2Specified() {
        return this.ub2 != null;
    }

    public boolean isUbFinalSpecified() {
        return this.ubFinal != null;
    }

    public static XmlAutoModelSpec create(AutoModelSpec s) {
        XmlAutoModelSpec t = new XmlAutoModelSpec();
        t.acceptDef = s.isAcceptDefault();
        t.balanced = s.isBalanced();
        if (s.getCancelationLimit() != 0.1) {
            t.cancel = s.getCancelationLimit();
        }
        t.armaLimit = s.getArmaSignificance();
        t.checkMu = s.isCheckMu();
        t.fct = s.getPercentRSE();
        t.hr = s.isHannanRissannen();
        t.ljungbox = s.getLjungBoxLimit();
        t.mixed = s.isMixed();
        t.predcv = s.getPercentReductionCV();
        t.ub1 = s.getInitialUnitRootLimit();
        t.ub2 = s.getFinalUnitRootLimit();
        t.ubFinal = s.getUnitRootLimit();
        return t;
    }

    @Override
    public void copyTo(X13Specification spec) {
        AutoModelSpec s = new AutoModelSpec();
        if (this.isAcceptDefSpecified()) {
            s.setAcceptDefault(this.acceptDef.booleanValue());
        }
        if (this.isArmaLimitSpecified()) {
            s.setArmaSignificance(this.armaLimit.doubleValue());
        }
        if (this.isBalancedSpecified()) {
            s.setBalanced(this.balanced.booleanValue());
        }
        if (this.isCancelSpecified()) {
            s.setCancelationLimit(this.cancel.doubleValue());
        }
        if (this.isCheckMuSpecified()) {
            s.setCheckMu(this.checkMu.booleanValue());
        }
        if (this.isUb2Specified()) {
            s.setFinalUnitRootLimit(this.ub2.doubleValue());
        }
        if (this.isHrSpecified()) {
            s.setHannanRissanen(this.hr.booleanValue());
        }
        if (this.isUb1Specified()) {
            s.setInitialUnitRootLimit(this.ub1.doubleValue());
        }
        if (this.isLjungboxSpecified()) {
            s.setLjungBoxLimit(this.ljungbox.doubleValue());
        }
        if (this.isMixedSpecified()) {
            s.setMixed(this.mixed.booleanValue());
        }
        if (this.isPredcvSpecified()) {
            s.setPercentReductionCV(this.predcv.doubleValue());
        }
        if (this.isFctSpecified()) {
            s.setPercentRSE(this.fct.doubleValue());
        }
        if (this.isUbFinalSpecified()) {
            s.setUnitRootLimit(this.ubFinal.doubleValue());
        }
        spec.getRegArimaSpecification().setAutoModel(s);
    }
}

