/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.xml.x12;

import ec.satoolkit.x13.X13Specification;
import ec.tss.Ts;
import ec.tss.TsFactory;
import ec.tss.TsInformation;
import ec.tss.TsInformationType;
import ec.tss.sa.documents.X13Document;
import ec.tss.xml.IXmlConverter;
import ec.tss.xml.XmlTs;
import ec.tss.xml.x12.XmlX12Specification;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(name="x12Doc")
@XmlType(name="x12DocType")
public class XmlX12Document
implements IXmlConverter<X13Document> {
    static final String NAME = "x12DocType";
    static final String RNAME = "x12Doc";
    @XmlElement
    public XmlTs ts;
    @XmlElement
    public XmlX12Specification spec;
    @XmlAttribute
    public String name;

    @Override
    public X13Document create() {
        X13Document ndoc = new X13Document();
        Object cnt = null;
        Ts xt = null;
        X13Specification xs = null;
        if (this.spec != null) {
            xs = new X13Specification();
            this.spec.copyTo(xs);
        }
        if (this.ts != null) {
            TsInformation info = this.ts.create();
            xt = TsFactory.instance.createTs(info.name, info.moniker, info.metaData, info.data);
        }
        ndoc.setSpecification(xs);
        ndoc.setTs(xt);
        ndoc.setLocked(true);
        return ndoc;
    }

    @Override
    public void copy(X13Document t) {
        this.ts = new XmlTs();
        Ts s = t.getTs();
        if (s != null) {
            this.ts = new XmlTs();
            this.ts.copy(s.freeze().toInfo(TsInformationType.All));
        }
        this.spec = new XmlX12Specification();
        X13Specification tsSpec = (X13Specification)t.getSpecification();
        this.spec.copy(tsSpec);
    }
}

