/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.xml.x13;

import ec.satoolkit.x11.X11Specification;
import ec.satoolkit.x13.X13Specification;
import ec.tss.xml.IXmlConverter;
import ec.tss.xml.sa.AbstractXmlSaSpecification;
import ec.tss.xml.sa.XmlRegressionSpec;
import ec.tss.xml.uscb.AbstractXmlArimaSpec;
import ec.tss.xml.uscb.XmlBasicSpec;
import ec.tss.xml.uscb.XmlCalendarSpec;
import ec.tss.xml.uscb.XmlEstimateSpec;
import ec.tss.xml.uscb.XmlOutlierSpec;
import ec.tss.xml.uscb.XmlTransformSpec;
import ec.tss.xml.uscb.XmlX11Spec;
import ec.tss.xml.x13.XmlArimaSpec;
import ec.tss.xml.x13.XmlAutoModelSpec;
import ec.tstoolkit.modelling.arima.x13.EstimateSpec;
import ec.tstoolkit.modelling.arima.x13.OutlierSpec;
import ec.tstoolkit.modelling.arima.x13.RegressionSpec;
import ec.tstoolkit.modelling.arima.x13.TransformSpec;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(name="x13Spec")
@XmlType(name="x13SpecType")
public class XmlX13Specification
extends AbstractXmlSaSpecification
implements IXmlConverter<X13Specification> {
    static final String NAME = "x13SpecType";
    static final String RNAME = "x13Spec";
    @XmlElement
    public XmlBasicSpec basicSpec;
    @XmlElement
    public XmlTransformSpec transformSpec;
    @XmlElements(value={@XmlElement(name="autoModelSpec", type=XmlAutoModelSpec.class), @XmlElement(name="arimaSpec", type=XmlArimaSpec.class)})
    public AbstractXmlArimaSpec modelSpec;
    @XmlElement
    public XmlCalendarSpec calendarSpec;
    @XmlElement
    public XmlRegressionSpec regressionSpec;
    @XmlElement
    public XmlOutlierSpec outlierSpec;
    @XmlElement
    public XmlEstimateSpec estimateSpec;
    @XmlElement
    public XmlX11Spec x11Spec;

    public void copyTo(X13Specification spec) {
        if (this.basicSpec != null) {
            this.basicSpec.initSpec(spec.getRegArimaSpecification().getBasic());
        }
        if (this.transformSpec != null) {
            spec.getRegArimaSpecification().setTransform(new TransformSpec());
            this.transformSpec.initSpec(spec.getRegArimaSpecification().getTransform());
        }
        if (this.calendarSpec != null) {
            spec.getRegArimaSpecification().setRegression(new RegressionSpec());
            this.calendarSpec.initSpec(spec.getRegArimaSpecification().getRegression());
        }
        if (this.modelSpec != null) {
            this.modelSpec.copyTo(spec);
        }
        if (this.regressionSpec != null) {
            if (spec.getRegArimaSpecification().getRegression() == null) {
                spec.getRegArimaSpecification().setRegression(new RegressionSpec());
            }
            RegressionSpec regs = spec.getRegArimaSpecification().getRegression();
            regs.setOutliers(this.regressionSpec.createOutliers());
            regs.setInterventionVariables(this.regressionSpec.createInterventions());
            regs.setRamps(this.regressionSpec.createRamps());
            regs.setUserDefinedVariables(this.regressionSpec.createVariables());
        }
        if (this.outlierSpec != null) {
            spec.getRegArimaSpecification().setOutliers(new OutlierSpec());
            this.outlierSpec.copyTo(spec.getRegArimaSpecification().getOutliers());
        }
        if (this.estimateSpec != null) {
            spec.getRegArimaSpecification().setEstimate(new EstimateSpec());
            this.estimateSpec.copyTo(spec.getRegArimaSpecification().getEstimate());
        }
        if (this.x11Spec != null) {
            spec.setX11Specification(new X11Specification());
            this.x11Spec.copyTo(spec.getX11Specification());
        }
    }

    public X13Specification convert(boolean useSystem) {
        X13Specification spec = this.create();
        if (!useSystem) {
            return spec;
        }
        X13Specification s = spec.matchSystem();
        if (s != null) {
            return s;
        }
        return spec;
    }

    @Override
    public X13Specification create() {
        X13Specification spec = new X13Specification();
        this.copyTo(spec);
        return spec;
    }

    @Override
    public void copy(X13Specification t) {
        this.basicSpec = XmlBasicSpec.create(t.getRegArimaSpecification().getBasic());
        this.transformSpec = XmlTransformSpec.create(t.getRegArimaSpecification().getTransform());
        this.calendarSpec = XmlCalendarSpec.create(t.getRegArimaSpecification().getRegression());
        this.modelSpec = XmlX13Specification.createArima(t);
        this.x11Spec = XmlX11Spec.create(t.getX11Specification());
        this.regressionSpec = new XmlRegressionSpec();
        if (t.getRegArimaSpecification().getRegression() != null) {
            this.regressionSpec.add(t.getRegArimaSpecification().getRegression().getOutliers());
            this.regressionSpec.add(t.getRegArimaSpecification().getRegression().getRamps());
            this.regressionSpec.add(t.getRegArimaSpecification().getRegression().getUserDefinedVariables());
            this.regressionSpec.add(t.getRegArimaSpecification().getRegression().getInterventionVariables());
        }
        if (this.regressionSpec.isEmpty()) {
            this.regressionSpec = null;
        }
        this.outlierSpec = XmlOutlierSpec.create(t.getRegArimaSpecification().getOutliers());
        this.estimateSpec = XmlEstimateSpec.create(t.getRegArimaSpecification().getEstimate());
    }

    static AbstractXmlArimaSpec createArima(X13Specification spec) {
        if (spec.getRegArimaSpecification().isUsingAutoModel()) {
            return XmlAutoModelSpec.create(spec.getRegArimaSpecification().getAutoModel());
        }
        return XmlArimaSpec.create(spec.getRegArimaSpecification().getArima());
    }
}

