/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.xades.validation;

import eu.europa.esig.dss.asic.common.ASiCContent;
import eu.europa.esig.dss.asic.common.ASiCUtils;
import eu.europa.esig.dss.asic.common.AbstractASiCContainerExtractor;
import eu.europa.esig.dss.asic.common.ZipUtils;
import eu.europa.esig.dss.asic.common.validation.AbstractASiCContainerValidator;
import eu.europa.esig.dss.asic.xades.ASiCWithXAdESContainerExtractor;
import eu.europa.esig.dss.asic.xades.OpenDocumentSupportUtils;
import eu.europa.esig.dss.asic.xades.validation.ASiCEWithXAdESManifestParser;
import eu.europa.esig.dss.enumerations.ASiCContainerType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.DocumentValidator;
import eu.europa.esig.dss.validation.ManifestFile;
import eu.europa.esig.dss.validation.scope.SignatureScopeFinder;
import eu.europa.esig.dss.xades.XAdESSignatureUtils;
import eu.europa.esig.dss.xades.validation.XAdESSignature;
import eu.europa.esig.dss.xades.validation.XMLDocumentValidator;
import eu.europa.esig.dss.xades.validation.scope.XAdESSignatureScopeFinder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ASiCContainerWithXAdESValidator
extends AbstractASiCContainerValidator {
    ASiCContainerWithXAdESValidator() {
    }

    public ASiCContainerWithXAdESValidator(DSSDocument asicContainer) {
        super(asicContainer, (SignatureScopeFinder)new XAdESSignatureScopeFinder());
    }

    public ASiCContainerWithXAdESValidator(ASiCContent asicContent) {
        super(asicContent, (SignatureScopeFinder)new XAdESSignatureScopeFinder());
    }

    public boolean isSupported(DSSDocument dssDocument) {
        if (ASiCUtils.isZip((DSSDocument)dssDocument)) {
            List filenames = ZipUtils.getInstance().extractEntryNames(dssDocument);
            return !ASiCUtils.isASiCWithCAdES((List)filenames);
        }
        return false;
    }

    public boolean isSupported(ASiCContent asicContent) {
        List entryNames = DSSUtils.getDocumentNames((List)asicContent.getAllDocuments());
        return !ASiCUtils.isASiCWithCAdES((List)entryNames);
    }

    protected AbstractASiCContainerExtractor getContainerExtractor() {
        return new ASiCWithXAdESContainerExtractor(this.document);
    }

    protected List<DocumentValidator> getSignatureValidators() {
        if (this.signatureValidators == null) {
            this.signatureValidators = new ArrayList();
            for (DSSDocument signature : this.getSignatureDocuments()) {
                XMLDocumentValidator xadesValidator = new XMLDocumentValidator(signature);
                xadesValidator.setCertificateVerifier(this.certificateVerifier);
                xadesValidator.setProcessExecutor(this.processExecutor);
                xadesValidator.setSignaturePolicyProvider(this.getSignaturePolicyProvider());
                if (ASiCUtils.isOpenDocument((DSSDocument)this.getMimeTypeDocument())) {
                    xadesValidator.setDetachedContents(OpenDocumentSupportUtils.getOpenDocumentCoverage(this.asicContent));
                } else if (ASiCContainerType.ASiC_S.equals((Object)this.getContainerType())) {
                    xadesValidator.setDetachedContents(this.getSignedDocuments());
                    xadesValidator.setContainerContents(this.getArchiveDocuments());
                } else {
                    xadesValidator.setDetachedContents(this.getAllDocuments());
                }
                this.signatureValidators.add(xadesValidator);
            }
        }
        return this.signatureValidators;
    }

    protected List<ManifestFile> getManifestFilesDescriptions() {
        ArrayList<ManifestFile> descriptions = new ArrayList<ManifestFile>();
        List signatureDocuments = this.getSignatureDocuments();
        List manifestDocuments = this.getManifestDocuments();
        for (DSSDocument signatureDoc : signatureDocuments) {
            for (DSSDocument manifestDoc : manifestDocuments) {
                ASiCEWithXAdESManifestParser manifestParser = new ASiCEWithXAdESManifestParser(signatureDoc, manifestDoc);
                descriptions.add(manifestParser.getManifest());
            }
        }
        return descriptions;
    }

    public List<DSSDocument> getOriginalDocuments(AdvancedSignature advancedSignature) {
        XAdESSignature xadesSignature = (XAdESSignature)advancedSignature;
        List retrievedDocs = XAdESSignatureUtils.getSignerDocuments((XAdESSignature)xadesSignature);
        if (Utils.isCollectionNotEmpty((Collection)retrievedDocs)) {
            return this.extractArchiveDocuments(retrievedDocs);
        }
        return Collections.emptyList();
    }

    private List<DSSDocument> extractArchiveDocuments(List<DSSDocument> retrievedDocs) {
        if (ASiCContainerType.ASiC_S.equals((Object)this.getContainerType())) {
            return this.getSignedDocumentsASiCS(retrievedDocs);
        }
        return retrievedDocs;
    }
}

