/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.xades.validation;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.asic.xades.definition.ManifestNamespace;
import eu.europa.esig.dss.asic.xades.definition.ManifestPaths;
import eu.europa.esig.dss.definition.DSSNamespace;
import eu.europa.esig.dss.enumerations.MimeType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.ManifestEntry;
import eu.europa.esig.dss.validation.ManifestFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ASiCEWithXAdESManifestParser {
    private static final Logger LOG = LoggerFactory.getLogger(ASiCEWithXAdESManifestParser.class);
    private final DSSDocument signatureDocument;
    private final DSSDocument manifestDocument;

    public ASiCEWithXAdESManifestParser(DSSDocument manifestDocument) {
        this(null, manifestDocument);
    }

    public ASiCEWithXAdESManifestParser(DSSDocument signatureDocument, DSSDocument manifestDocument) {
        this.signatureDocument = signatureDocument;
        this.manifestDocument = manifestDocument;
    }

    public ManifestFile getManifest() {
        ManifestFile manifest = new ManifestFile();
        manifest.setDocument(this.manifestDocument);
        if (this.signatureDocument != null) {
            manifest.setSignatureFilename(this.signatureDocument.getName());
        }
        manifest.setEntries(this.getEntries());
        return manifest;
    }

    private List<ManifestEntry> getEntries() {
        if (!DomUtils.isDOM((DSSDocument)this.manifestDocument)) {
            LOG.warn("Unable to parse manifest file '{}': the document is not a valid XML!", (Object)this.manifestDocument.getName());
            return Collections.emptyList();
        }
        ArrayList<ManifestEntry> result = new ArrayList<ManifestEntry>();
        try {
            Document manifestDom = DomUtils.buildDOM((DSSDocument)this.manifestDocument);
            DSSNamespace manifestNamespace = this.getManifestNamespace(manifestDom);
            NodeList nodeList = DomUtils.getNodeList((Node)manifestDom, (String)ManifestPaths.FILE_ENTRY_PATH);
            if (nodeList != null && nodeList.getLength() > 0) {
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    ManifestEntry manifestEntry = new ManifestEntry();
                    Element fileEntryElement = (Element)nodeList.item(i);
                    String fullPathValue = fileEntryElement.getAttribute(ManifestPaths.getFullPathAttribute(manifestNamespace));
                    if (this.isFolder(fullPathValue)) continue;
                    manifestEntry.setFileName(fullPathValue);
                    manifestEntry.setMimeType(this.getMimeType(fileEntryElement, manifestNamespace));
                    result.add(manifestEntry);
                }
            }
        }
        catch (Exception e) {
            String errorMessage = "Unable to parse manifest file '{}' : {}";
            if (LOG.isDebugEnabled()) {
                LOG.warn(errorMessage, new Object[]{this.manifestDocument.getName(), e.getMessage(), e});
            }
            LOG.warn(errorMessage, (Object)this.manifestDocument.getName(), (Object)e.getMessage());
        }
        return result;
    }

    private DSSNamespace getManifestNamespace(Document manifestDom) {
        DSSNamespace manifestNamespace = DomUtils.browseRecursivelyForNamespaceWithUri((Element)manifestDom.getDocumentElement(), (String)ManifestNamespace.NS.getUri());
        return manifestNamespace != null ? manifestNamespace : ManifestNamespace.NS;
    }

    private MimeType getMimeType(Element fileEntryElement, DSSNamespace manifestNamespace) {
        String mediaType = fileEntryElement.getAttribute(ManifestPaths.getMediaTypeAttribute(manifestNamespace));
        if (Utils.isStringNotBlank((String)mediaType)) {
            return MimeType.fromMimeTypeString((String)mediaType);
        }
        return null;
    }

    private boolean isFolder(String fullpathValue) {
        return fullpathValue.endsWith("/");
    }

    static {
        DomUtils.registerNamespace((DSSNamespace)ManifestNamespace.NS);
    }
}

