/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.xades.merge;

import eu.europa.esig.dss.asic.common.ASiCContent;
import eu.europa.esig.dss.asic.common.ASiCUtils;
import eu.europa.esig.dss.asic.xades.merge.AbstractASiCWithXAdESContainerMerger;
import eu.europa.esig.dss.enumerations.ASiCContainerType;
import eu.europa.esig.dss.enumerations.MimeType;
import eu.europa.esig.dss.enumerations.MimeTypeEnum;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.exception.IllegalInputException;
import eu.europa.esig.dss.spi.signature.AdvancedSignature;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import eu.europa.esig.dss.xades.validation.XAdESSignature;
import eu.europa.esig.dss.xades.validation.XMLDocumentAnalyzer;
import eu.europa.esig.dss.xml.utils.DomUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.xml.security.signature.Reference;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ASiCSWithXAdESContainerMerger
extends AbstractASiCWithXAdESContainerMerger {
    ASiCSWithXAdESContainerMerger() {
    }

    public ASiCSWithXAdESContainerMerger(DSSDocument ... containers) {
        super(containers);
    }

    public ASiCSWithXAdESContainerMerger(ASiCContent ... asicContents) {
        super(asicContents);
    }

    @Override
    protected boolean isSupported(DSSDocument container) {
        return super.isSupported(container) && !ASiCUtils.isASiCEContainer((DSSDocument)container);
    }

    @Override
    protected boolean isSupported(ASiCContent asicContent) {
        return super.isSupported(asicContent) && !ASiCUtils.isASiCEContainer((ASiCContent)asicContent);
    }

    protected ASiCContainerType getTargetASiCContainerType() {
        return ASiCContainerType.ASiC_S;
    }

    protected void ensureContainerContentAllowMerge() {
        if (Arrays.stream(this.asicContents).allMatch(asicContent -> Utils.isCollectionEmpty((Collection)asicContent.getSignatureDocuments()) && Utils.isCollectionEmpty((Collection)asicContent.getEvidenceRecordDocuments()))) {
            return;
        }
        if (Arrays.stream(this.asicContents).anyMatch(asicContent -> Utils.collectionSize((Collection)asicContent.getSignatureDocuments()) > 1)) {
            throw new UnsupportedOperationException("Unable to merge ASiC-S with XAdES containers. One of the containers has more than one signature documents!");
        }
        if (Arrays.stream(this.asicContents).anyMatch(asicContent -> Utils.isCollectionNotEmpty((Collection)asicContent.getTimestampDocuments()))) {
            throw new UnsupportedOperationException("Unable to merge ASiC-S with XAdES containers. One of the containers contains a detached timestamp!");
        }
        if (Arrays.stream(this.asicContents).anyMatch(asicContent -> Utils.collectionSize((Collection)asicContent.getEvidenceRecordDocuments()) > 1)) {
            throw new UnsupportedOperationException("Unable to merge ASiC-S with XAdES containers. One of the containers has more than one evidence record documents!");
        }
        if (Arrays.stream(this.asicContents).filter(asicContent -> Utils.isCollectionNotEmpty((Collection)asicContent.getEvidenceRecordDocuments())).count() > 1L) {
            throw new UnsupportedOperationException("Unable to merge ASiC-S with XAdES containers. Evidence record containers cannot be merged with the given container type!");
        }
        if (Arrays.stream(this.asicContents).anyMatch(asicContent -> Utils.collectionSize((Collection)asicContent.getRootLevelSignedDocuments()) > 1)) {
            throw new UnsupportedOperationException("Unable to merge ASiC-S with XAdES containers. One of the containers has more than one signer documents!");
        }
        if (Utils.collectionSize(this.getSignerDocumentNameSet()) > 1) {
            throw new UnsupportedOperationException("Unable to merge ASiC-S with XAdES containers. Signer documents have different names!");
        }
        if (Arrays.stream(this.asicContents).anyMatch(asicContent -> Utils.isCollectionNotEmpty((Collection)asicContent.getSignatureDocuments())) && Arrays.stream(this.asicContents).anyMatch(asicContent -> Utils.isCollectionNotEmpty((Collection)asicContent.getEvidenceRecordDocuments()))) {
            throw new UnsupportedOperationException("Unable to merge ASiC-S with XAdES containers. Only one type of a container is allowed (signature or evidence record)!");
        }
        Arrays.stream(this.asicContents).forEach(asicContent -> this.assertSignatureDocumentNameValid(asicContent.getSignatureDocuments()));
        Arrays.stream(this.asicContents).forEach(asicContent -> this.assertEvidenceRecordDocumentNameValid(asicContent.getEvidenceRecordDocuments()));
    }

    private void assertSignatureDocumentNameValid(List<DSSDocument> signatureDocuments) {
        if (Utils.isCollectionNotEmpty(signatureDocuments)) {
            for (DSSDocument signatureDocument : signatureDocuments) {
                if ("META-INF/signatures.xml".equals(signatureDocument.getName())) continue;
                throw new UnsupportedOperationException("Unable to merge ASiC-S with XAdES containers. The signature document in one of the containers has invalid naming!");
            }
        }
    }

    private void assertEvidenceRecordDocumentNameValid(List<DSSDocument> evidenceRecordDocuments) {
        if (Utils.isCollectionNotEmpty(evidenceRecordDocuments)) {
            String evidenceRecordDocumentName = null;
            for (DSSDocument evidenceRecordDocument : evidenceRecordDocuments) {
                if (!"META-INF/evidencerecord.xml".equals(evidenceRecordDocument.getName()) && !"META-INF/evidencerecord.ers".equals(evidenceRecordDocument.getName())) {
                    throw new UnsupportedOperationException("Unable to merge ASiC-S with XAdES containers. The evidence record document in one of the containers has invalid naming!");
                }
                if (evidenceRecordDocumentName == null) {
                    evidenceRecordDocumentName = evidenceRecordDocument.getName();
                    continue;
                }
                if (evidenceRecordDocumentName.equals(evidenceRecordDocument.getName())) continue;
                throw new UnsupportedOperationException("Unable to merge ASiC-S with XAdES containers. The evidence record documents have conflicting names within containers!");
            }
        }
    }

    private Set<String> getSignerDocumentNameSet() {
        HashSet<String> result = new HashSet<String>();
        for (ASiCContent asicContent : this.asicContents) {
            result.addAll(DSSUtils.getDocumentNames((List)asicContent.getRootLevelSignedDocuments()));
        }
        return result;
    }

    protected void ensureSignaturesAllowMerge() {
        if (Arrays.stream(this.asicContents).filter(asicContent -> Utils.isCollectionNotEmpty((Collection)asicContent.getSignatureDocuments()) || Utils.isCollectionNotEmpty((Collection)asicContent.getEvidenceRecordDocuments())).count() <= 1L) {
            return;
        }
        this.mergeSignatureDocuments();
    }

    private void mergeSignatureDocuments() {
        List<XMLDocumentAnalyzer> documentValidators = this.getAllDocumentValidators();
        List<AdvancedSignature> allSignatures = this.getAllSignatures(documentValidators);
        if (Utils.isCollectionEmpty(allSignatures)) {
            return;
        }
        if (!this.checkNoCommonIdsBetweenSignatures(allSignatures)) {
            throw new IllegalInputException("Signature documents contain signatures with the same identifiers!");
        }
        if (!this.checkNoCommonIdsBetweenSignedData(allSignatures)) {
            throw new IllegalInputException("Signature documents contain signatures signed enveloped objects with the same identifiers!");
        }
        if (!this.checkNoCommonIdsBetweenSignatureValues(allSignatures)) {
            throw new IllegalInputException("Signature documents contain signatures with SignatureValue elements sharing the same ids!");
        }
        this.assertSameRootElement(documentValidators);
        DSSDocument signaturesXml = this.getMergedSignaturesXml(documentValidators);
        for (ASiCContent asicContent : this.asicContents) {
            asicContent.setSignatureDocuments(Collections.singletonList(signaturesXml));
        }
    }

    private List<XMLDocumentAnalyzer> getAllDocumentValidators() {
        ArrayList<XMLDocumentAnalyzer> validators = new ArrayList<XMLDocumentAnalyzer>();
        for (ASiCContent asicContent : this.asicContents) {
            for (DSSDocument signatureDocument : asicContent.getSignatureDocuments()) {
                validators.add(new XMLDocumentAnalyzer(signatureDocument));
            }
        }
        return validators;
    }

    private List<AdvancedSignature> getAllSignatures(List<XMLDocumentAnalyzer> validators) {
        ArrayList<AdvancedSignature> signatures = new ArrayList<AdvancedSignature>();
        for (XMLDocumentAnalyzer validator : validators) {
            signatures.addAll(validator.getSignatures());
        }
        return signatures;
    }

    private boolean checkNoCommonIdsBetweenSignatures(List<AdvancedSignature> signatures) {
        List<String> signatureIds = this.getSignatureIds(signatures);
        return !this.checkDuplicatesPresent(signatureIds);
    }

    private List<String> getSignatureIds(List<AdvancedSignature> signatures) {
        return signatures.stream().map(AdvancedSignature::getDAIdentifier).collect(Collectors.toList());
    }

    private boolean checkNoCommonIdsBetweenSignedData(List<AdvancedSignature> signatures) {
        List<String> signedDataObjectIdsOne = this.getSignedDataObjectIds(signatures);
        return !this.checkDuplicatesPresent(signedDataObjectIdsOne);
    }

    private List<String> getSignedDataObjectIds(List<AdvancedSignature> signatures) {
        ArrayList<String> ids = new ArrayList<String>();
        for (AdvancedSignature signature : signatures) {
            XAdESSignature xadesSignature = (XAdESSignature)signature;
            List references = xadesSignature.getReferences();
            for (Reference reference : references) {
                String referenceURI = DSSXMLUtils.getReferenceURI((Reference)reference);
                if (referenceURI == null) continue;
                if ("".equals(referenceURI)) {
                    throw new IllegalInputException("Unable to merge signatures, as one of them covers the whole signature file document!");
                }
                if (!DomUtils.startsFromHash((String)referenceURI) && !DomUtils.isXPointerQuery((String)referenceURI)) continue;
                ids.add(referenceURI);
            }
        }
        return ids;
    }

    private boolean checkNoCommonIdsBetweenSignatureValues(List<AdvancedSignature> signatures) {
        List<String> signatureValueIds = this.getSignatureValueIds(signatures);
        return !this.checkDuplicatesPresent(signatureValueIds);
    }

    private List<String> getSignatureValueIds(List<AdvancedSignature> signatures) {
        ArrayList<String> ids = new ArrayList<String>();
        for (AdvancedSignature signature : signatures) {
            XAdESSignature xadesSignature = (XAdESSignature)signature;
            ids.add(xadesSignature.getSignatureValueId());
        }
        return ids;
    }

    private boolean checkDuplicatesPresent(List<String> strings) {
        for (String str : strings) {
            if (Collections.frequency(strings, str) <= 1) continue;
            return true;
        }
        return false;
    }

    private void assertSameRootElement(List<XMLDocumentAnalyzer> documentValidators) {
        Element rootElement = null;
        for (XMLDocumentAnalyzer documentValidator : documentValidators) {
            Element currentRootElement = documentValidator.getRootElement().getDocumentElement();
            if (rootElement == null) {
                rootElement = currentRootElement;
                continue;
            }
            if (!rootElement.getLocalName().equals(currentRootElement.getLocalName())) {
                throw new IllegalInputException("Signature containers have different root elements!");
            }
            if (rootElement.getNamespaceURI() != null ^ currentRootElement.getNamespaceURI() != null) {
                throw new IllegalInputException("Signature containers have different namespaces!");
            }
            if (rootElement.getNamespaceURI() != null && !rootElement.getNamespaceURI().equals(currentRootElement.getNamespaceURI())) {
                throw new IllegalInputException("Signature containers have different namespaces!");
            }
            if (rootElement.getPrefix().equals(currentRootElement.getPrefix())) continue;
            throw new IllegalInputException("Signature containers have different namespace prefixes!");
        }
    }

    private DSSDocument getMergedSignaturesXml(List<XMLDocumentAnalyzer> documentValidators) {
        Document document = null;
        Element documentElement = null;
        for (XMLDocumentAnalyzer documentValidator : documentValidators) {
            if (document == null) {
                document = documentValidator.getRootElement();
                documentElement = document.getDocumentElement();
                continue;
            }
            NodeList childNodesToAdd = documentValidator.getRootElement().getDocumentElement().getChildNodes();
            for (int i = 0; i < childNodesToAdd.getLength(); ++i) {
                Node node = childNodesToAdd.item(i);
                Node adopted = document.importNode(node, true);
                documentElement.appendChild(adopted);
            }
        }
        byte[] bytes = DomUtils.serializeNode(documentElement);
        return new InMemoryDocument(bytes, "META-INF/signatures.xml", (MimeType)MimeTypeEnum.XML);
    }
}

