/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.xades.validation;

import eu.europa.esig.dss.asic.common.ASiCContent;
import eu.europa.esig.dss.asic.common.ASiCUtils;
import eu.europa.esig.dss.asic.common.ZipUtils;
import eu.europa.esig.dss.asic.common.extract.DefaultASiCContainerExtractor;
import eu.europa.esig.dss.asic.common.validation.ASiCManifestParser;
import eu.europa.esig.dss.asic.common.validation.ASiCManifestValidator;
import eu.europa.esig.dss.asic.common.validation.AbstractASiCContainerAnalyzer;
import eu.europa.esig.dss.asic.xades.OpenDocumentSupportUtils;
import eu.europa.esig.dss.asic.xades.extract.ASiCWithXAdESContainerExtractor;
import eu.europa.esig.dss.asic.xades.validation.ASiCEWithXAdESManifestParser;
import eu.europa.esig.dss.enumerations.ASiCContainerType;
import eu.europa.esig.dss.enumerations.ASiCManifestTypeEnum;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.ManifestFile;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.signature.AdvancedSignature;
import eu.europa.esig.dss.spi.validation.analyzer.DocumentAnalyzer;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.xades.XAdESSignatureUtils;
import eu.europa.esig.dss.xades.validation.XAdESSignature;
import eu.europa.esig.dss.xades.validation.XMLDocumentAnalyzer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ASiCContainerWithXAdESAnalyzer
extends AbstractASiCContainerAnalyzer {
    ASiCContainerWithXAdESAnalyzer() {
    }

    public ASiCContainerWithXAdESAnalyzer(DSSDocument asicContainer) {
        super(asicContainer);
    }

    public ASiCContainerWithXAdESAnalyzer(ASiCContent asicContent) {
        super(asicContent);
    }

    public boolean isSupported(DSSDocument dssDocument) {
        if (ASiCUtils.isZip((DSSDocument)dssDocument)) {
            List filenames = ZipUtils.getInstance().extractEntryNames(dssDocument);
            if (ASiCUtils.isASiCWithXAdES((List)filenames)) {
                return true;
            }
            return !ASiCUtils.isASiCWithCAdES((List)filenames);
        }
        return false;
    }

    public boolean isSupported(ASiCContent asicContent) {
        List entryNames = DSSUtils.getDocumentNames((List)asicContent.getAllDocuments());
        return !ASiCUtils.isASiCWithCAdES((List)entryNames);
    }

    protected DefaultASiCContainerExtractor getContainerExtractor() {
        return new ASiCWithXAdESContainerExtractor(this.document);
    }

    protected List<DocumentAnalyzer> getSignatureAnalyzers() {
        if (this.signatureValidators == null) {
            this.signatureValidators = new ArrayList();
            for (DSSDocument signature : this.getSignatureDocuments()) {
                XMLDocumentAnalyzer documentAnalyzer = new XMLDocumentAnalyzer(signature);
                documentAnalyzer.setCertificateVerifier(this.certificateVerifier);
                documentAnalyzer.setSignaturePolicyProvider(this.getSignaturePolicyProvider());
                if (ASiCUtils.isOpenDocument((DSSDocument)this.getMimeTypeDocument())) {
                    documentAnalyzer.setDetachedContents(OpenDocumentSupportUtils.getOpenDocumentCoverage(this.asicContent));
                } else if (ASiCContainerType.ASiC_S.equals((Object)this.getContainerType())) {
                    documentAnalyzer.setDetachedContents(this.getSignedDocuments());
                    documentAnalyzer.setContainerContents(this.getArchiveDocuments());
                } else {
                    documentAnalyzer.setDetachedContents(this.getAllDocuments());
                }
                this.signatureValidators.add(documentAnalyzer);
            }
        }
        return this.signatureValidators;
    }

    protected List<ManifestFile> getManifestFilesDescriptions() {
        ArrayList<ManifestFile> descriptions = new ArrayList<ManifestFile>();
        List signatureDocuments = this.getSignatureDocuments();
        List manifestDocuments = this.getManifestDocuments();
        for (DSSDocument signatureDoc : signatureDocuments) {
            for (DSSDocument manifestDoc : manifestDocuments) {
                ASiCEWithXAdESManifestParser manifestParser = new ASiCEWithXAdESManifestParser(signatureDoc, manifestDoc);
                descriptions.add(manifestParser.getManifest());
            }
        }
        List evidenceRecordManifestDocuments = this.getEvidenceRecordManifestDocuments();
        for (DSSDocument manifestDocument : evidenceRecordManifestDocuments) {
            ManifestFile manifestFile = ASiCManifestParser.getManifestFile((DSSDocument)manifestDocument);
            if (manifestFile == null) continue;
            manifestFile.setManifestType(ASiCManifestTypeEnum.EVIDENCE_RECORD);
            ASiCManifestValidator manifestValidator = new ASiCManifestValidator(manifestFile, this.getAllDocuments());
            manifestValidator.validateEntries();
            descriptions.add(manifestFile);
        }
        return descriptions;
    }

    public List<DSSDocument> getOriginalDocuments(AdvancedSignature advancedSignature) {
        XAdESSignature xadesSignature = (XAdESSignature)advancedSignature;
        List retrievedDocs = XAdESSignatureUtils.getSignerDocuments((XAdESSignature)xadesSignature);
        if (Utils.isCollectionNotEmpty((Collection)retrievedDocs)) {
            return this.extractArchiveDocuments(retrievedDocs);
        }
        return Collections.emptyList();
    }

    private List<DSSDocument> extractArchiveDocuments(List<DSSDocument> retrievedDocs) {
        if (ASiCContainerType.ASiC_S.equals((Object)this.getContainerType())) {
            return this.getSignedDocumentsASiCS(retrievedDocs);
        }
        return retrievedDocs;
    }
}

