/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.signature;

import eu.europa.esig.dss.cades.CAdESSignatureParameters;
import eu.europa.esig.dss.cades.CMSUtils;
import eu.europa.esig.dss.cades.SignedAssertion;
import eu.europa.esig.dss.cades.SignedAssertions;
import eu.europa.esig.dss.cades.SignerAttributeV2;
import eu.europa.esig.dss.cades.signature.CAdESCounterSignatureParameters;
import eu.europa.esig.dss.enumerations.CommitmentType;
import eu.europa.esig.dss.enumerations.MimeTypeEnum;
import eu.europa.esig.dss.model.CommonCommitmentType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.Policy;
import eu.europa.esig.dss.model.SpDocSpecification;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.OID;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Objects;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1UTF8String;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.esf.CommitmentTypeIndication;
import org.bouncycastle.asn1.esf.CommitmentTypeQualifier;
import org.bouncycastle.asn1.esf.OtherHashAlgAndValue;
import org.bouncycastle.asn1.esf.SigPolicyQualifierInfo;
import org.bouncycastle.asn1.esf.SigPolicyQualifiers;
import org.bouncycastle.asn1.esf.SignaturePolicyId;
import org.bouncycastle.asn1.esf.SignaturePolicyIdentifier;
import org.bouncycastle.asn1.esf.SignerAttribute;
import org.bouncycastle.asn1.esf.SignerLocation;
import org.bouncycastle.asn1.ess.ContentHints;
import org.bouncycastle.asn1.ess.ContentIdentifier;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Attribute;
import org.bouncycastle.asn1.x509.NoticeReference;
import org.bouncycastle.asn1.x509.Time;
import org.bouncycastle.asn1.x509.UserNotice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CAdESLevelBaselineB {
    private static final Logger LOG = LoggerFactory.getLogger(CAdESLevelBaselineB.class);
    private final boolean padesUsage;
    private final DSSDocument documentToSign;

    public CAdESLevelBaselineB() {
        this(false);
    }

    public CAdESLevelBaselineB(boolean padesUsage) {
        this(null, padesUsage);
    }

    public CAdESLevelBaselineB(DSSDocument documentToSign) {
        this(documentToSign, false);
    }

    CAdESLevelBaselineB(DSSDocument documentToSign, boolean padesUsage) {
        this.documentToSign = documentToSign;
        this.padesUsage = padesUsage;
    }

    public AttributeTable getUnsignedAttributes() {
        return new AttributeTable(new Hashtable());
    }

    public AttributeTable getSignedAttributes(CAdESSignatureParameters parameters) {
        if (Utils.isArrayNotEmpty((byte[])parameters.getSignedData())) {
            LOG.debug("Using explicit SignedAttributes from parameter");
            return CMSUtils.getAttributesFromByteArray(parameters.getSignedData());
        }
        ASN1EncodableVector signedAttributes = new ASN1EncodableVector();
        this.addSigningCertificateAttribute(parameters, signedAttributes);
        this.addSigningTimeAttribute(parameters, signedAttributes);
        this.addSignerAttribute(parameters, signedAttributes);
        this.addSignaturePolicyId(parameters, signedAttributes);
        this.addContentHints(parameters, signedAttributes);
        this.addMimeType(parameters, signedAttributes);
        this.addContentIdentifier(parameters, signedAttributes);
        this.addCommitmentType(parameters, signedAttributes);
        this.addSignerLocation(parameters, signedAttributes);
        this.addContentTimestamps(parameters, signedAttributes);
        return new AttributeTable(signedAttributes);
    }

    private void addSignerAttribute(CAdESSignatureParameters parameters, ASN1EncodableVector signedAttributes) {
        List claimedSignerRoles = parameters.bLevel().getClaimedSignerRoles();
        if (claimedSignerRoles != null) {
            ArrayList<Attribute> claimedAttributes = new ArrayList<Attribute>(claimedSignerRoles.size());
            for (String claimedSignerRole : claimedSignerRoles) {
                DERUTF8String roles = new DERUTF8String(claimedSignerRole);
                Attribute idAaEtsSignerAttr = new Attribute(OID.id_at_role, (ASN1Set)new DERSet((ASN1Encodable)roles));
                claimedAttributes.add(idAaEtsSignerAttr);
            }
            org.bouncycastle.asn1.cms.Attribute signerAttributes = !parameters.isEn319122() ? new org.bouncycastle.asn1.cms.Attribute(PKCSObjectIdentifiers.id_aa_ets_signerAttr, (ASN1Set)new DERSet((ASN1Encodable)new SignerAttribute(claimedAttributes.toArray(new Attribute[claimedAttributes.size()])))) : new org.bouncycastle.asn1.cms.Attribute(OID.id_aa_ets_signerAttrV2, (ASN1Set)new DERSet((ASN1Encodable)new SignerAttributeV2(claimedAttributes.toArray(new Attribute[claimedAttributes.size()]))));
            signedAttributes.add((ASN1Encodable)signerAttributes);
            return;
        }
        List signedAssertions = parameters.bLevel().getSignedAssertions();
        if (signedAssertions != null && parameters.isEn319122()) {
            ArrayList<SignedAssertion> assertionsToAdd = new ArrayList<SignedAssertion>();
            for (String signedAssertion : signedAssertions) {
                SignedAssertion sa = new SignedAssertion(signedAssertion);
                assertionsToAdd.add(sa);
            }
            if (!assertionsToAdd.isEmpty()) {
                org.bouncycastle.asn1.cms.Attribute signerAttributes = new org.bouncycastle.asn1.cms.Attribute(OID.id_aa_ets_signerAttrV2, (ASN1Set)new DERSet((ASN1Encodable)new SignerAttributeV2(new SignedAssertions(assertionsToAdd))));
                signedAttributes.add((ASN1Encodable)signerAttributes);
            }
        }
    }

    private void addSigningTimeAttribute(CAdESSignatureParameters parameters, ASN1EncodableVector signedAttributes) {
        if (this.padesUsage) {
            return;
        }
        Date signingDate = parameters.bLevel().getSigningDate();
        if (signingDate != null) {
            DERSet attrValues = new DERSet((ASN1Encodable)new Time(signingDate));
            org.bouncycastle.asn1.cms.Attribute attribute = new org.bouncycastle.asn1.cms.Attribute(PKCSObjectIdentifiers.pkcs_9_at_signingTime, (ASN1Set)attrValues);
            signedAttributes.add((ASN1Encodable)attribute);
        }
    }

    private void addSignerLocation(CAdESSignatureParameters parameters, ASN1EncodableVector signedAttributes) {
        if (this.padesUsage) {
            return;
        }
        eu.europa.esig.dss.model.SignerLocation signerLocationParameter = parameters.bLevel().getSignerLocation();
        if (signerLocationParameter != null && !signerLocationParameter.isEmpty()) {
            DERUTF8String country = signerLocationParameter.getCountry() == null ? null : new DERUTF8String(signerLocationParameter.getCountry());
            DERUTF8String locality = signerLocationParameter.getLocality() == null ? null : new DERUTF8String(signerLocationParameter.getLocality());
            DERSequence derSequencePostalAddress = this.getPostalAddressSequence(signerLocationParameter.getPostalAddress());
            SignerLocation signerLocation = new SignerLocation((ASN1UTF8String)country, (ASN1UTF8String)locality, (ASN1Sequence)derSequencePostalAddress);
            DERSet attrValues = new DERSet((ASN1Encodable)signerLocation);
            org.bouncycastle.asn1.cms.Attribute attribute = new org.bouncycastle.asn1.cms.Attribute(PKCSObjectIdentifiers.id_aa_ets_signerLocation, (ASN1Set)attrValues);
            signedAttributes.add((ASN1Encodable)attribute);
        }
    }

    private DERSequence getPostalAddressSequence(List<String> postalAddressParameter) {
        DERSequence derSequencePostalAddress = null;
        if (Utils.isCollectionNotEmpty(postalAddressParameter)) {
            ASN1EncodableVector postalAddress = new ASN1EncodableVector();
            for (String addressLine : postalAddressParameter) {
                postalAddress.add((ASN1Encodable)new DERUTF8String(addressLine));
            }
            derSequencePostalAddress = new DERSequence(postalAddress);
        }
        return derSequencePostalAddress;
    }

    private void addCommitmentType(CAdESSignatureParameters parameters, ASN1EncodableVector signedAttributes) {
        List commitmentTypeIndications = parameters.bLevel().getCommitmentTypeIndications();
        if (Utils.isCollectionNotEmpty((Collection)commitmentTypeIndications)) {
            int size = commitmentTypeIndications.size();
            ASN1Encodable[] asn1Encodables = new ASN1Encodable[size];
            for (int ii = 0; ii < size; ++ii) {
                CommitmentType commitmentType = (CommitmentType)commitmentTypeIndications.get(ii);
                if (Utils.isStringEmpty((String)commitmentType.getOid())) {
                    throw new IllegalArgumentException("The commitmentTypeIndication OID must be defined for CAdES creation!");
                }
                ASN1ObjectIdentifier objectIdentifier = new ASN1ObjectIdentifier(commitmentType.getOid());
                ASN1Sequence qualifiers = this.getCommitmentQualifiers(commitmentType);
                CommitmentTypeIndication commitmentTypeIndication = new CommitmentTypeIndication(objectIdentifier, qualifiers);
                asn1Encodables[ii] = commitmentTypeIndication.toASN1Primitive();
            }
            DERSet attrValues = new DERSet(asn1Encodables);
            org.bouncycastle.asn1.cms.Attribute attribute = new org.bouncycastle.asn1.cms.Attribute(PKCSObjectIdentifiers.id_aa_ets_commitmentType, (ASN1Set)attrValues);
            signedAttributes.add((ASN1Encodable)attribute);
        }
    }

    private ASN1Sequence getCommitmentQualifiers(CommitmentType commitmentType) {
        Object[] commitmentTypeQualifiers;
        DERSequence qualifiers = null;
        if (commitmentType instanceof CommonCommitmentType && Utils.isArrayNotEmpty((Object[])(commitmentTypeQualifiers = ((CommonCommitmentType)commitmentType).getCommitmentTypeQualifiers()))) {
            ASN1EncodableVector vector = new ASN1EncodableVector(commitmentTypeQualifiers.length);
            for (Object commitmentQualifier : commitmentTypeQualifiers) {
                ASN1Primitive qualifier;
                Objects.requireNonNull(commitmentQualifier, "CommitmentTypeQualifier cannot be null!");
                if (Utils.isStringEmpty((String)commitmentQualifier.getOid())) {
                    throw new IllegalArgumentException("CommitmentTypeQualifier OID cannot be null for CAdES!");
                }
                ASN1ObjectIdentifier commitmentIdentifier = new ASN1ObjectIdentifier(commitmentQualifier.getOid());
                DSSDocument content = commitmentQualifier.getContent();
                if (content == null) {
                    throw new IllegalArgumentException("CommitmentTypeQualifier content cannot be null!");
                }
                byte[] binaries = DSSUtils.toByteArray((DSSDocument)content);
                if (DSSASN1Utils.isAsn1Encoded((byte[])binaries)) {
                    qualifier = DSSASN1Utils.toASN1Primitive((byte[])binaries);
                } else {
                    LOG.info("None ASN.1 encoded CommitmentTypeQualifier has been provided. Incorporate as DERUTF8String.");
                    qualifier = new DERUTF8String(new String(binaries));
                }
                vector.add((ASN1Encodable)new CommitmentTypeQualifier(commitmentIdentifier, (ASN1Encodable)qualifier));
            }
            qualifiers = new DERSequence(vector);
        }
        return qualifiers;
    }

    private void addContentTimestamps(CAdESSignatureParameters parameters, ASN1EncodableVector signedAttributes) {
        if (Utils.isCollectionNotEmpty((Collection)parameters.getContentTimestamps())) {
            List contentTimestamps = parameters.getContentTimestamps();
            for (TimestampToken contentTimestamp : contentTimestamps) {
                ASN1Primitive asn1Object = DSSASN1Utils.toASN1Primitive((byte[])contentTimestamp.getEncoded());
                DERSet attrValues = new DERSet((ASN1Encodable)asn1Object);
                org.bouncycastle.asn1.cms.Attribute attribute = new org.bouncycastle.asn1.cms.Attribute(PKCSObjectIdentifiers.id_aa_ets_contentTimestamp, (ASN1Set)attrValues);
                signedAttributes.add((ASN1Encodable)attribute);
            }
        }
    }

    private void addContentHints(CAdESSignatureParameters parameters, ASN1EncodableVector signedAttributes) {
        if (Utils.isStringNotBlank((String)parameters.getContentHintsType())) {
            ASN1ObjectIdentifier contentHintsType = new ASN1ObjectIdentifier(parameters.getContentHintsType());
            String contentHintsDescriptionString = parameters.getContentHintsDescription();
            DERUTF8String contentHintsDescription = Utils.isStringBlank((String)contentHintsDescriptionString) ? null : new DERUTF8String(contentHintsDescriptionString);
            ContentHints contentHints = new ContentHints(contentHintsType, (ASN1UTF8String)contentHintsDescription);
            DERSet attrValues = new DERSet((ASN1Encodable)contentHints);
            org.bouncycastle.asn1.cms.Attribute attribute = new org.bouncycastle.asn1.cms.Attribute(PKCSObjectIdentifiers.id_aa_contentHint, (ASN1Set)attrValues);
            signedAttributes.add((ASN1Encodable)attribute);
        }
    }

    private void addContentIdentifier(CAdESSignatureParameters parameters, ASN1EncodableVector signedAttributes) {
        if (this.padesUsage) {
            return;
        }
        String contentIdentifierPrefix = parameters.getContentIdentifierPrefix();
        if (Utils.isStringNotBlank((String)contentIdentifierPrefix)) {
            if (Utils.isStringBlank((String)parameters.getContentIdentifierSuffix())) {
                StringBuilder suffixBuilder = new StringBuilder();
                suffixBuilder.append(new ASN1GeneralizedTime(new Date()).getTimeString());
                suffixBuilder.append(new SecureRandom().nextLong());
                parameters.setContentIdentifierSuffix(suffixBuilder.toString());
            }
            String contentIdentifierString = contentIdentifierPrefix + parameters.getContentIdentifierSuffix();
            ContentIdentifier contentIdentifier = new ContentIdentifier(contentIdentifierString.getBytes());
            DERSet attrValues = new DERSet((ASN1Encodable)contentIdentifier);
            org.bouncycastle.asn1.cms.Attribute attribute = new org.bouncycastle.asn1.cms.Attribute(PKCSObjectIdentifiers.id_aa_contentIdentifier, (ASN1Set)attrValues);
            signedAttributes.add((ASN1Encodable)attribute);
        }
    }

    private void addSignaturePolicyId(CAdESSignatureParameters parameters, ASN1EncodableVector signedAttributes) {
        Policy policy = parameters.bLevel().getSignaturePolicy();
        if (policy != null) {
            SignaturePolicyIdentifier sigPolicy;
            String policyId = policy.getId();
            if (Utils.isStringEmpty((String)policyId)) {
                sigPolicy = new SignaturePolicyIdentifier();
            } else {
                ASN1ObjectIdentifier derOIPolicyId = new ASN1ObjectIdentifier(policyId);
                ASN1ObjectIdentifier oid = new ASN1ObjectIdentifier(policy.getDigestAlgorithm().getOid());
                AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(oid);
                OtherHashAlgAndValue otherHashAlgAndValue = new OtherHashAlgAndValue(algorithmIdentifier, (ASN1OctetString)new DEROctetString(policy.getDigestValue()));
                if (policy.isSPQualifierPresent()) {
                    SigPolicyQualifiers sigPolicyQualifiers = this.buildSigPolicyQualifiers(policy);
                    sigPolicy = new SignaturePolicyIdentifier(new SignaturePolicyId(derOIPolicyId, otherHashAlgAndValue, sigPolicyQualifiers));
                } else {
                    sigPolicy = new SignaturePolicyIdentifier(new SignaturePolicyId(derOIPolicyId, otherHashAlgAndValue));
                }
            }
            DERSet attrValues = new DERSet((ASN1Encodable)sigPolicy);
            org.bouncycastle.asn1.cms.Attribute attribute = new org.bouncycastle.asn1.cms.Attribute(PKCSObjectIdentifiers.id_aa_ets_sigPolicyId, (ASN1Set)attrValues);
            signedAttributes.add((ASN1Encodable)attribute);
        }
    }

    private SigPolicyQualifiers buildSigPolicyQualifiers(Policy policy) {
        SpDocSpecification spDocSpecification;
        eu.europa.esig.dss.model.UserNotice userNotice;
        ArrayList<SigPolicyQualifierInfo> qualifierInfos = new ArrayList<SigPolicyQualifierInfo>();
        String spUri = policy.getSpuri();
        if (Utils.isStringNotEmpty((String)spUri)) {
            SigPolicyQualifierInfo spuriQualifier = new SigPolicyQualifierInfo(PKCSObjectIdentifiers.id_spq_ets_uri, (ASN1Encodable)new DERIA5String(policy.getSpuri()));
            qualifierInfos.add(spuriQualifier);
        }
        if ((userNotice = policy.getUserNotice()) != null && !userNotice.isEmpty()) {
            DSSUtils.assertSPUserNoticeConfigurationValid((eu.europa.esig.dss.model.UserNotice)userNotice);
            NoticeReference noticeReference = null;
            String explicitText = null;
            String organization = userNotice.getOrganization();
            int[] noticeNumbers = userNotice.getNoticeNumbers();
            if (Utils.isStringNotEmpty((String)organization) && noticeNumbers != null && noticeNumbers.length > 0) {
                Vector numbers = new Vector(DSSUtils.toBigIntegerList((int[])noticeNumbers));
                noticeReference = new NoticeReference(organization, numbers);
            }
            if (Utils.isStringNotEmpty((String)userNotice.getExplicitText())) {
                explicitText = userNotice.getExplicitText();
            }
            UserNotice asn1UserNotice = new UserNotice(noticeReference, explicitText);
            SigPolicyQualifierInfo userNoticeQualifier = new SigPolicyQualifierInfo(PKCSObjectIdentifiers.id_spq_ets_unotice, (ASN1Encodable)asn1UserNotice);
            qualifierInfos.add(userNoticeQualifier);
        }
        if ((spDocSpecification = policy.getSpDocSpecification()) != null && Utils.isStringNotEmpty((String)spDocSpecification.getId())) {
            ASN1Primitive spDocSpecificationId = DSSASN1Utils.buildSPDocSpecificationId((String)spDocSpecification.getId());
            SigPolicyQualifierInfo spDocSpecificationQualifier = new SigPolicyQualifierInfo(OID.id_sp_doc_specification, (ASN1Encodable)spDocSpecificationId);
            qualifierInfos.add(spDocSpecificationQualifier);
        }
        return new SigPolicyQualifiers(qualifierInfos.toArray(new SigPolicyQualifierInfo[0]));
    }

    private void addSigningCertificateAttribute(CAdESSignatureParameters parameters, ASN1EncodableVector signedAttributes) {
        if (parameters.getSigningCertificate() == null && parameters.isGenerateTBSWithoutCertificate()) {
            LOG.debug("Signing certificate not available and must be added to signed attributes later");
            return;
        }
        CMSUtils.addSigningCertificateAttribute(signedAttributes, parameters.getDigestAlgorithm(), parameters.getSigningCertificate());
    }

    private void addMimeType(CAdESSignatureParameters parameters, ASN1EncodableVector signedAttributes) {
        if (this.padesUsage) {
            return;
        }
        if (parameters instanceof CAdESCounterSignatureParameters) {
            return;
        }
        if (Utils.isStringNotBlank((String)parameters.getContentHintsType())) {
            return;
        }
        MimeTypeEnum mimeType = MimeTypeEnum.BINARY;
        if (this.documentToSign != null && this.documentToSign.getMimeType() != null) {
            mimeType = this.documentToSign.getMimeType();
        }
        DERUTF8String mimeTypeDerString = new DERUTF8String(mimeType.getMimeTypeString());
        DERSet attrValues = new DERSet((ASN1Encodable)mimeTypeDerString);
        org.bouncycastle.asn1.cms.Attribute attribute = new org.bouncycastle.asn1.cms.Attribute(OID.id_aa_ets_mimeType, (ASN1Set)attrValues);
        signedAttributes.add((ASN1Encodable)attribute);
    }
}

