/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.validation;

import eu.europa.esig.dss.cades.CMSUtils;
import eu.europa.esig.dss.cades.validation.CAdESSignature;
import eu.europa.esig.dss.enumerations.ArchiveTimestampType;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureForm;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.model.SignaturePolicyStore;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.OID;
import eu.europa.esig.dss.spi.signature.BaselineRequirementsChecker;
import eu.europa.esig.dss.spi.signature.DefaultAdvancedSignature;
import eu.europa.esig.dss.spi.validation.CertificateVerifier;
import eu.europa.esig.dss.spi.x509.CertificateRef;
import eu.europa.esig.dss.spi.x509.CertificateSource;
import eu.europa.esig.dss.spi.x509.ListCertificateSource;
import eu.europa.esig.dss.spi.x509.tsp.TimestampToken;
import eu.europa.esig.dss.utils.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CAdESBaselineRequirementsChecker
extends BaselineRequirementsChecker<CAdESSignature> {
    private static final Logger LOG = LoggerFactory.getLogger(CAdESBaselineRequirementsChecker.class);

    protected CAdESBaselineRequirementsChecker(CAdESSignature signature) {
        this(signature, null);
    }

    public CAdESBaselineRequirementsChecker(CAdESSignature signature, CertificateVerifier offlineCertificateVerifier) {
        super((DefaultAdvancedSignature)signature, offlineCertificateVerifier);
    }

    protected SignatureForm getBaselineSignatureForm() {
        return SignatureForm.CAdES;
    }

    protected boolean cmsBaselineBRequirements() {
        boolean cades;
        CMSSignedData cmsSignedData = ((CAdESSignature)this.signature).getCmsSignedData();
        SignerInformation signerInformation = ((CAdESSignature)this.signature).getSignerInformation();
        SignatureForm signatureForm = this.getBaselineSignatureForm();
        if (Utils.isCollectionEmpty((Collection)cmsSignedData.getCertificates().getMatches(null))) {
            LOG.warn("SignedData.certificates shall be present for {}-BASELINE-B signature (cardinality == 1)!", (Object)signatureForm);
            return false;
        }
        if (!this.isContentTypeValid(signerInformation)) {
            LOG.warn("content-type attribute shall be present for {}-BASELINE-B signature (cardinality == 1)!", (Object)signatureForm);
            return false;
        }
        if (!this.isMessageDigestPresent(signerInformation)) {
            LOG.warn("message-digest attribute shall be present for {}-BASELINE-B signature (cardinality == 1)!", (Object)signatureForm);
            return false;
        }
        if (!this.isOneSigningCertificatePresent(signerInformation)) {
            LOG.warn("signing-certificate(-v2) attribute shall be present for {}-BASELINE-B signature (cardinality == 1)!", (Object)signatureForm);
            return false;
        }
        Object[] signingTimeAttrs = CMSUtils.getSignedAttributes(signerInformation, PKCSObjectIdentifiers.pkcs_9_at_signingTime);
        boolean signingTimePresent = Utils.arraySize((Object[])signingTimeAttrs) == 1;
        if (signingTimePresent != (cades = SignatureForm.CAdES.equals((Object)signatureForm))) {
            if (cades) {
                LOG.warn("signing-time attribute shall be present for {}-BASELINE-B signature (cardinality == 1})!", (Object)signatureForm);
            } else {
                LOG.warn("signing-time attribute shall not be present for {}-BASELINE-B signature (cardinality == 0})!", (Object)signatureForm);
            }
            return false;
        }
        if (!this.containsSigningCertificate(((CAdESSignature)this.signature).getCertificateSource().getSignedDataCertificates())) {
            LOG.warn("Signing certificate shall be present in SignedData.certificates for {}-BASELINE-B signature (requirement (a))!", (Object)signatureForm);
            return false;
        }
        if (((CAdESSignature)this.signature).getContentType() != null && !PKCSObjectIdentifiers.data.getId().equals(((CAdESSignature)this.signature).getContentType())) {
            LOG.warn("The content-type attribute shall have value id-data for {}-BASELINE-B signature (requirement (f))!", (Object)signatureForm);
            return false;
        }
        if (!this.isSigningCertificateAttributeValid(signerInformation)) {
            LOG.warn("signing-certificate attribute shall be used for SHA1 hash algorithm and signing-certificate-v2 for other hash algorithms for {}-BASELINE-B signature (requirements (h) and (i) 319 122-1)!", (Object)signatureForm);
            return false;
        }
        return true;
    }

    public boolean hasBaselineBProfile() {
        if (!this.cmsBaselineBRequirements()) {
            return false;
        }
        SignaturePolicyStore signaturePolicyStore = ((CAdESSignature)this.signature).getSignaturePolicyStore();
        if (signaturePolicyStore != null && !this.isSignaturePolicyIdentifierHashPresent()) {
            LOG.warn("signature-policy-store shall not be present for CAdES-BASELINE-B signature with not defined signature-policy-identifier/sigPolicyHash (requirement (k))!");
            return false;
        }
        return true;
    }

    public boolean hasBaselineTProfile() {
        if (!this.minimalTRequirement()) {
            return false;
        }
        if (!this.signatureTimestampsCreatedBeforeSignCertExpiration()) {
            LOG.warn("signature-time-stamp shall be created before expiration of the signing-certificate for CAdES-BASELINE-T signature (requirement (m))!");
            return false;
        }
        return true;
    }

    public boolean hasBaselineLTProfile() {
        if (!this.minimalLTRequirement()) {
            return false;
        }
        SignerInformation signerInformation = ((CAdESSignature)this.signature).getSignerInformation();
        if (Utils.isArrayNotEmpty((Object[])CMSUtils.getUnsignedAttributes(signerInformation, PKCSObjectIdentifiers.id_aa_ets_certValues))) {
            LOG.warn("certificate-values attribute shall not be present for CAdES-BASELINE-LT signature (cardinality == 0)!");
            return false;
        }
        if (Utils.isArrayNotEmpty((Object[])CMSUtils.getUnsignedAttributes(signerInformation, PKCSObjectIdentifiers.id_aa_ets_certificateRefs))) {
            LOG.warn("complete-certificate-references attribute shall not be present for CAdES-BASELINE-LT signature (cardinality == 0)!");
            return false;
        }
        if (Utils.isArrayNotEmpty((Object[])CMSUtils.getUnsignedAttributes(signerInformation, PKCSObjectIdentifiers.id_aa_ets_revocationValues))) {
            LOG.warn("revocation-values attribute shall not be present for CAdES-BASELINE-LT signature (cardinality == 0)!");
            return false;
        }
        if (Utils.isArrayNotEmpty((Object[])CMSUtils.getUnsignedAttributes(signerInformation, PKCSObjectIdentifiers.id_aa_ets_revocationRefs))) {
            LOG.warn("complete-revocation-references attribute shall not be present for CAdES-BASELINE-LT signature (cardinality == 0)!");
            return false;
        }
        if (Utils.isArrayNotEmpty((Object[])CMSUtils.getUnsignedAttributes(signerInformation, PKCSObjectIdentifiers.id_aa_ets_certCRLTimestamp))) {
            LOG.warn("time-stamped-certs-crls-references attribute shall not be present for CAdES-BASELINE-LT signature (cardinality == 0)!");
            return false;
        }
        return true;
    }

    protected boolean containsLTLevelCertificates() {
        CMSSignedData cmsSignedData = ((CAdESSignature)this.signature).getCmsSignedData();
        List signedDataCertificates = cmsSignedData.getCertificates().getMatches(null).stream().map(DSSASN1Utils::getCertificate).collect(Collectors.toList());
        ListCertificateSource timestampListCertificateSource = ((CAdESSignature)this.signature).getTimestampSource().getTimestampCertificateSourcesExceptLastArchiveTimestamp();
        List timestampCertificateSources = timestampListCertificateSource.getSources();
        if (Utils.isCollectionEmpty((Collection)timestampCertificateSources)) {
            return false;
        }
        for (CertificateSource timestampCertificateSource : timestampCertificateSources) {
            if (Utils.containsAny(signedDataCertificates, (Collection)timestampCertificateSource.getCertificates())) continue;
            return false;
        }
        return true;
    }

    public boolean hasBaselineLTAProfile() {
        ArrayList timestampTokens = new ArrayList();
        timestampTokens.addAll(((CAdESSignature)this.signature).getArchiveTimestamps());
        timestampTokens.addAll(((CAdESSignature)this.signature).getDetachedTimestamps());
        if (Utils.isCollectionEmpty(timestampTokens)) {
            LOG.trace("ArchiveTimeStamp shall be present for CAdES-BASELINE-LTA signature (cardinality >= 1)!");
            return false;
        }
        boolean validArcTstFound = false;
        for (TimestampToken timestampToken : timestampTokens) {
            if (!ArchiveTimestampType.CAdES_V3.equals((Object)timestampToken.getArchiveTimestampType()) && !timestampToken.getTimeStampType().isContainerTimestamp()) continue;
            validArcTstFound = true;
            break;
        }
        if (!validArcTstFound) {
            LOG.warn("archive-time-stamp-v3 attribute shall be present for CAdES-BASELINE-LTA signature (cardinality == 1)!");
            return false;
        }
        return true;
    }

    public boolean hasExtendedBESProfile() {
        SignerInformation signerInformation = ((CAdESSignature)this.signature).getSignerInformation();
        SignatureForm signatureForm = this.getBaselineSignatureForm();
        if (!this.isContentTypeValid(signerInformation)) {
            LOG.warn("content-type attribute shall be present for {}-BES signature (cardinality == 1)!", (Object)signatureForm);
            return false;
        }
        if (!this.isMessageDigestPresent(signerInformation)) {
            LOG.warn("message-digest attribute shall be present for {}-BES signature (cardinality == 1)!", (Object)signatureForm);
            return false;
        }
        if (!this.isOneSigningCertificatePresent(signerInformation)) {
            LOG.warn("signing-certificate(-v2) attribute shall be present for {}-BES signature (cardinality == 1)!", (Object)signatureForm);
            return false;
        }
        if (Utils.arraySize((Object[])CMSUtils.getSignedAttributes(signerInformation, PKCSObjectIdentifiers.pkcs_9_at_signingTime)) > 1) {
            LOG.warn("signing-time attribute shall not be present multiple times for {}-BES signature (cardinality == 0 or 1)!", (Object)signatureForm);
            return false;
        }
        if (Utils.arraySize((Object[])CMSUtils.getSignedAttributes(signerInformation, PKCSObjectIdentifiers.id_aa_ets_commitmentType)) > 1) {
            LOG.warn("commitment-time-indication attribute shall not be present multiple times for {}-BES signature (cardinality == 0 or 1)!", (Object)signatureForm);
            return false;
        }
        if (Utils.arraySize((Object[])CMSUtils.getSignedAttributes(signerInformation, PKCSObjectIdentifiers.id_aa_contentHint)) > 1) {
            LOG.warn("content-hints attribute shall not be present multiple times for {}-BES signature (cardinality == 0 or 1)!", (Object)signatureForm);
            return false;
        }
        if (Utils.arraySize((Object[])CMSUtils.getSignedAttributes(signerInformation, OID.id_aa_ets_mimeType)) > 1) {
            LOG.warn("mime-type attribute shall not be present multiple times for {}-BES signature (cardinality == 0 or 1)!", (Object)signatureForm);
            return false;
        }
        if (Utils.arraySize((Object[])CMSUtils.getSignedAttributes(signerInformation, PKCSObjectIdentifiers.id_aa_ets_signerLocation)) > 1) {
            LOG.warn("signer-location attribute shall not be present multiple times for {}-BES signature (cardinality == 0 or 1)!", (Object)signatureForm);
            return false;
        }
        if (Utils.arraySize((Object[])CMSUtils.getSignedAttributes(signerInformation, PKCSObjectIdentifiers.id_aa_ets_sigPolicyId)) > 1) {
            LOG.warn("signature-policy-identifier attribute shall not be present multiple times for {}-BES signature (cardinality == 0 or 1)!", (Object)signatureForm);
            return false;
        }
        if (Utils.arraySize((Object[])CMSUtils.getSignedAttributes(signerInformation, PKCSObjectIdentifiers.id_aa_ets_sigPolicyId)) > 1) {
            LOG.warn("signature-policy-identifier attribute shall not be present multiple times for {}-BES signature (cardinality == 0 or 1)!", (Object)signatureForm);
            return false;
        }
        if (Utils.arraySize((Object[])CMSUtils.getUnsignedAttributes(signerInformation, OID.id_aa_ets_sigPolicyStore)) > 1) {
            LOG.warn("signature-policy-store attribute shall not be present multiple times for {}-BES signature (cardinality == 0 or 1)!", (Object)signatureForm);
            return false;
        }
        if (Utils.arraySize((Object[])CMSUtils.getSignedAttributes(signerInformation, PKCSObjectIdentifiers.id_aa_contentReference)) > 1) {
            LOG.warn("content-reference attribute shall not be present multiple times for {}-BES signature (cardinality == 0 or 1)!", (Object)signatureForm);
            return false;
        }
        if (Utils.arraySize((Object[])CMSUtils.getSignedAttributes(signerInformation, PKCSObjectIdentifiers.id_aa_contentIdentifier)) > 1) {
            LOG.warn("content-identifier attribute shall not be present multiple times for {}-BES signature (cardinality == 0 or 1)!", (Object)signatureForm);
            return false;
        }
        if (Utils.arraySize((Object[])CMSUtils.getUnsignedAttributes(signerInformation, PKCSObjectIdentifiers.id_aa_ets_certificateRefs)) > 1) {
            LOG.warn("complete-certificate-references attribute shall not be present multiple times for {}-BES signature (cardinality == 0 or 1)!", (Object)signatureForm);
            return false;
        }
        if (Utils.arraySize((Object[])CMSUtils.getUnsignedAttributes(signerInformation, PKCSObjectIdentifiers.id_aa_ets_revocationRefs)) > 1) {
            LOG.warn("complete-revocation-references attribute shall not be present multiple times for {}-BES signature (cardinality == 0 or 1)!", (Object)signatureForm);
            return false;
        }
        if (Utils.arraySize((Object[])CMSUtils.getUnsignedAttributes(signerInformation, OID.attributeCertificateRefsOid)) > 1) {
            LOG.warn("attribute-certificate-references attribute shall not be present multiple times for {}-BES signature (cardinality == 0 or 1)!", (Object)signatureForm);
            return false;
        }
        if (Utils.arraySize((Object[])CMSUtils.getUnsignedAttributes(signerInformation, OID.attributeRevocationRefsOid)) > 1) {
            LOG.warn("attribute-revocation-references attribute shall not be present multiple times for {}-BES signature (cardinality == 0 or 1)!", (Object)signatureForm);
            return false;
        }
        if (Utils.arraySize((Object[])CMSUtils.getUnsignedAttributes(signerInformation, PKCSObjectIdentifiers.id_aa_ets_certValues)) > 1) {
            LOG.warn("certificate-values attribute shall not be present multiple times for {}-BES signature (cardinality == 0 or 1)!", (Object)signatureForm);
            return false;
        }
        if (Utils.arraySize((Object[])CMSUtils.getUnsignedAttributes(signerInformation, PKCSObjectIdentifiers.id_aa_ets_revocationValues)) > 1) {
            LOG.warn("revocation-values attribute shall not be present multiple times for {}-BES signature (cardinality == 0 or 1)!", (Object)signatureForm);
            return false;
        }
        if (!this.isSigningCertificateAttributeValid(signerInformation)) {
            LOG.warn("signing-certificate attribute shall be used for SHA1 hash algorithm and signing-certificate-v2 for other hash algorithms for {}-BES signature (requirements (a) and (b) 319 122-2)!", (Object)signatureForm);
            return false;
        }
        return true;
    }

    public boolean hasExtendedEPESProfile() {
        SignerInformation signerInformation = ((CAdESSignature)this.signature).getSignerInformation();
        SignatureForm signatureForm = this.getBaselineSignatureForm();
        Object[] sigPolicyIdAttrs = CMSUtils.getSignedAttributes(signerInformation, PKCSObjectIdentifiers.id_aa_ets_sigPolicyId);
        if (Utils.arraySize((Object[])sigPolicyIdAttrs) == 0) {
            LOG.debug("signature-policy-identifier attribute shall be present for {}-EPES signature (cardinality == 1)!", (Object)signatureForm);
            return false;
        }
        SignaturePolicyStore signaturePolicyStore = ((CAdESSignature)this.signature).getSignaturePolicyStore();
        if (signaturePolicyStore != null && !this.isSignaturePolicyIdentifierHashPresent()) {
            LOG.debug("signature-policy-store may be present for {}-EPES signature only if signature-policy-identifier is present and it contains sigPolicyHash element (requirement (c))!", (Object)signatureForm);
            return false;
        }
        return true;
    }

    public boolean hasExtendedTProfile() {
        if (!this.minimalTRequirement()) {
            return false;
        }
        if (!this.signatureTimestampsCreatedBeforeSignCertExpiration()) {
            LOG.warn("signature-time-stamp shall be created before expiration of the signing-certificate for CAdES-T signature (requirement (f))!");
            return false;
        }
        return true;
    }

    public boolean hasExtendedCProfile() {
        SignerInformation signerInformation = ((CAdESSignature)this.signature).getSignerInformation();
        if (Utils.arraySize((Object[])CMSUtils.getUnsignedAttributes(signerInformation, PKCSObjectIdentifiers.id_aa_ets_certificateRefs)) != 1) {
            LOG.debug("complete-certificate-references attribute shall be present for CAdES-C signature (cardinality == 1)!");
            return false;
        }
        ListCertificateSource certificateSources = this.getCertificateSourcesExceptLastArchiveTimestamp();
        boolean certificateFound = certificateSources.getNumberOfCertificates() > 0;
        boolean allSelfSigned = certificateFound && certificateSources.isAllSelfSigned();
        Object[] revocationRefAttrs = CMSUtils.getUnsignedAttributes(signerInformation, PKCSObjectIdentifiers.id_aa_ets_revocationRefs);
        if (Utils.arraySize((Object[])revocationRefAttrs) > 1) {
            LOG.debug("complete-revocation-references attribute shall be present only once for CAdES-C signature (cardinality == 1)!");
            return false;
        }
        if (!allSelfSigned && Utils.arraySize((Object[])revocationRefAttrs) != 1) {
            LOG.debug("complete-revocation-references attribute shall be present for CAdES-C signature (cardinality == 1)!");
            return false;
        }
        return true;
    }

    public boolean hasExtendedXProfile() {
        SignerInformation signerInformation = ((CAdESSignature)this.signature).getSignerInformation();
        if (Utils.arraySize((Object[])CMSUtils.getUnsignedAttributes(signerInformation, PKCSObjectIdentifiers.id_aa_ets_certCRLTimestamp)) + Utils.arraySize((Object[])CMSUtils.getUnsignedAttributes(signerInformation, PKCSObjectIdentifiers.id_aa_ets_escTimeStamp)) != 1) {
            LOG.debug("complete-revocation-references attribute shall be present for CAdES-C signature (cardinality == 1)!");
            return false;
        }
        return true;
    }

    public boolean hasExtendedXLProfile() {
        return this.minimalLTRequirement();
    }

    public boolean hasExtendedAProfile() {
        ArrayList timestampTokens = new ArrayList();
        timestampTokens.addAll(((CAdESSignature)this.signature).getArchiveTimestamps());
        timestampTokens.addAll(((CAdESSignature)this.signature).getDetachedTimestamps());
        if (Utils.isCollectionEmpty(timestampTokens)) {
            LOG.trace("ArchiveTimeStamp shall be present for CAdES-A signature (cardinality >= 1)!");
            return false;
        }
        return true;
    }

    private boolean isContentTypeValid(SignerInformation signerInformation) {
        Object[] contentTypeAttrs = CMSUtils.getSignedAttributes(signerInformation, PKCSObjectIdentifiers.pkcs_9_at_contentType);
        int numberOfOccurrences = Utils.arraySize((Object[])contentTypeAttrs);
        if (((CAdESSignature)this.signature).isCounterSignature() && numberOfOccurrences == 0) {
            return true;
        }
        return numberOfOccurrences == 1;
    }

    private boolean isMessageDigestPresent(SignerInformation signerInformation) {
        Object[] messageDigestAttrs = CMSUtils.getSignedAttributes(signerInformation, PKCSObjectIdentifiers.pkcs_9_at_messageDigest);
        return Utils.arraySize((Object[])messageDigestAttrs) == 1;
    }

    private boolean isOneSigningCertificatePresent(SignerInformation signerInformation) {
        Object[] signingCertAttrs = CMSUtils.getSignedAttributes(signerInformation, PKCSObjectIdentifiers.id_aa_signingCertificate);
        Object[] signingCertV2Attrs = CMSUtils.getSignedAttributes(signerInformation, PKCSObjectIdentifiers.id_aa_signingCertificateV2);
        return Utils.arraySize((Object[])signingCertAttrs) + Utils.arraySize((Object[])signingCertV2Attrs) == 1;
    }

    private boolean isSigningCertificateAttributeValid(SignerInformation signerInformation) {
        DigestAlgorithm digestAlgorithm;
        CertificateRef signingCertificateRef;
        Digest certDigest;
        List certificateRefs = ((CAdESSignature)this.signature).getCertificateSource().getSigningCertificateRefs();
        return !Utils.isCollectionNotEmpty((Collection)certificateRefs) || (certDigest = (signingCertificateRef = (CertificateRef)certificateRefs.iterator().next()).getCertDigest()) == null || !(DigestAlgorithm.SHA1.equals((Object)(digestAlgorithm = certDigest.getAlgorithm())) ? Utils.arraySize((Object[])CMSUtils.getSignedAttributes(signerInformation, PKCSObjectIdentifiers.id_aa_signingCertificate)) == 0 : Utils.arraySize((Object[])CMSUtils.getSignedAttributes(signerInformation, PKCSObjectIdentifiers.id_aa_signingCertificateV2)) == 0);
    }
}

