/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.validation;

import eu.europa.esig.dss.cades.CMSUtils;
import eu.europa.esig.dss.cades.SignedAssertion;
import eu.europa.esig.dss.cades.SignedAssertions;
import eu.europa.esig.dss.cades.SignerAttributeV2;
import eu.europa.esig.dss.cades.validation.CAdESBaselineRequirementsChecker;
import eu.europa.esig.dss.cades.validation.CAdESCRLSource;
import eu.europa.esig.dss.cades.validation.CAdESCertificateSource;
import eu.europa.esig.dss.cades.validation.CAdESOCSPSource;
import eu.europa.esig.dss.cades.validation.CAdESSignatureIdentifierBuilder;
import eu.europa.esig.dss.cades.validation.CAdESSignatureIntegrityValidator;
import eu.europa.esig.dss.cades.validation.PrecomputedDigestCalculatorProvider;
import eu.europa.esig.dss.cades.validation.scope.CAdESSignatureScopeFinder;
import eu.europa.esig.dss.cades.validation.timestamp.CAdESTimestampSource;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.DigestMatcherType;
import eu.europa.esig.dss.enumerations.EncryptionAlgorithm;
import eu.europa.esig.dss.enumerations.EndorsementType;
import eu.europa.esig.dss.enumerations.MaskGenerationFunction;
import eu.europa.esig.dss.enumerations.SignatureAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureForm;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.model.DigestDocument;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.model.ManifestEntry;
import eu.europa.esig.dss.model.ReferenceValidation;
import eu.europa.esig.dss.model.SignaturePolicyStore;
import eu.europa.esig.dss.model.SpDocSpecification;
import eu.europa.esig.dss.model.UserNotice;
import eu.europa.esig.dss.model.scope.SignatureScope;
import eu.europa.esig.dss.model.signature.CommitmentTypeIndication;
import eu.europa.esig.dss.model.signature.SignatureCryptographicVerification;
import eu.europa.esig.dss.model.signature.SignatureDigestReference;
import eu.europa.esig.dss.model.signature.SignaturePolicy;
import eu.europa.esig.dss.model.signature.SignatureProductionPlace;
import eu.europa.esig.dss.model.signature.SignerRole;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.OID;
import eu.europa.esig.dss.spi.SignatureCertificateSource;
import eu.europa.esig.dss.spi.signature.AdvancedSignature;
import eu.europa.esig.dss.spi.signature.DefaultAdvancedSignature;
import eu.europa.esig.dss.spi.signature.identifier.SignatureIdentifierBuilder;
import eu.europa.esig.dss.spi.validation.CertificateVerifier;
import eu.europa.esig.dss.spi.x509.CandidatesForSigningCertificate;
import eu.europa.esig.dss.spi.x509.CertificateValidity;
import eu.europa.esig.dss.spi.x509.SignerIdentifier;
import eu.europa.esig.dss.spi.x509.revocation.crl.OfflineCRLSource;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OfflineOCSPSource;
import eu.europa.esig.dss.spi.x509.tsp.TimestampToken;
import eu.europa.esig.dss.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1IA5String;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.esf.OtherHashAlgAndValue;
import org.bouncycastle.asn1.esf.SPUserNotice;
import org.bouncycastle.asn1.esf.SigPolicyQualifierInfo;
import org.bouncycastle.asn1.esf.SigPolicyQualifiers;
import org.bouncycastle.asn1.esf.SignaturePolicyId;
import org.bouncycastle.asn1.esf.SignerAttribute;
import org.bouncycastle.asn1.esf.SignerLocation;
import org.bouncycastle.asn1.ess.ContentHints;
import org.bouncycastle.asn1.ess.ContentIdentifier;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.RSASSAPSSparams;
import org.bouncycastle.asn1.x500.DirectoryString;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.AttCertValidityPeriod;
import org.bouncycastle.asn1.x509.AttributeCertificate;
import org.bouncycastle.asn1.x509.AttributeCertificateInfo;
import org.bouncycastle.asn1.x509.DisplayText;
import org.bouncycastle.asn1.x509.NoticeReference;
import org.bouncycastle.asn1.x509.RoleSyntax;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataParser;
import org.bouncycastle.cms.CMSTypedStream;
import org.bouncycastle.cms.SignerId;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.bc.BcDigestCalculatorProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CAdESSignature
extends DefaultAdvancedSignature {
    private static final long serialVersionUID = 8449504364217200965L;
    private static final Logger LOG = LoggerFactory.getLogger(CAdESSignature.class);
    private final CMSSignedData cmsSignedData;
    private final SignerInformation signerInformation;
    private SignerInformationStore counterSignaturesStore;

    public CAdESSignature(CMSSignedData cmsSignedData, SignerInformation signerInformation) {
        Objects.requireNonNull(cmsSignedData, "CMSSignedData cannot be null!");
        Objects.requireNonNull(signerInformation, "SignerInformation must be provided!");
        this.cmsSignedData = cmsSignedData;
        this.signerInformation = signerInformation;
    }

    public SignatureForm getSignatureForm() {
        return SignatureForm.CAdES;
    }

    public SignatureCertificateSource getCertificateSource() {
        if (this.offlineCertificateSource == null) {
            this.offlineCertificateSource = new CAdESCertificateSource(this.cmsSignedData, this.signerInformation);
        }
        return this.offlineCertificateSource;
    }

    public OfflineCRLSource getCRLSource() {
        if (this.signatureCRLSource == null) {
            try {
                this.signatureCRLSource = new CAdESCRLSource(this.cmsSignedData, this.signerInformation.getUnsignedAttributes());
            }
            catch (Exception e) {
                LOG.warn("Error in computing or in format of the algorithm: just continue...", (Throwable)e);
            }
        }
        return this.signatureCRLSource;
    }

    public OfflineOCSPSource getOCSPSource() {
        if (this.signatureOCSPSource == null) {
            this.signatureOCSPSource = new CAdESOCSPSource(this.cmsSignedData, this.signerInformation.getUnsignedAttributes());
        }
        return this.signatureOCSPSource;
    }

    public CAdESTimestampSource getTimestampSource() {
        if (this.signatureTimestampSource == null) {
            this.signatureTimestampSource = new CAdESTimestampSource(this);
        }
        return (CAdESTimestampSource)this.signatureTimestampSource;
    }

    public SignerId getSignerId() {
        return this.signerInformation.getSID();
    }

    protected List<SignatureScope> findSignatureScopes() {
        return new CAdESSignatureScopeFinder().findSignatureScope(this);
    }

    protected SignaturePolicy buildSignaturePolicy() {
        SigPolicyQualifiers sigPolicyQualifiers;
        Attribute attribute = CMSUtils.getSignedAttribute(this.signerInformation, PKCSObjectIdentifiers.id_aa_ets_sigPolicyId);
        if (attribute == null) {
            return null;
        }
        ASN1Encodable attrValue = attribute.getAttrValues().getObjectAt(0);
        if (attrValue instanceof DERNull) {
            this.signaturePolicy = new SignaturePolicy();
            return this.signaturePolicy;
        }
        SignaturePolicyId sigPolicy = SignaturePolicyId.getInstance((Object)attrValue);
        if (sigPolicy == null) {
            return null;
        }
        String policyId = sigPolicy.getSigPolicyId().getId();
        this.signaturePolicy = new SignaturePolicy(policyId);
        OtherHashAlgAndValue hashAlgAndValue = sigPolicy.getSigPolicyHash();
        ASN1OctetString digestValue = hashAlgAndValue.getHashValue();
        byte[] digestValueBytes = digestValue.getOctets();
        boolean zeroHash = this.isZeroHash(digestValueBytes);
        this.signaturePolicy.setZeroHash(zeroHash);
        if (!zeroHash) {
            AlgorithmIdentifier digestAlgorithmIdentifier = hashAlgAndValue.getHashAlgorithm();
            String digestAlgorithmOID = digestAlgorithmIdentifier.getAlgorithm().getId();
            DigestAlgorithm digestAlgorithm = DigestAlgorithm.forOID((String)digestAlgorithmOID);
            this.signaturePolicy.setDigest(new Digest(digestAlgorithm, digestValueBytes));
        }
        if ((sigPolicyQualifiers = sigPolicy.getSigPolicyQualifiers()) != null) {
            for (int ii = 0; ii < sigPolicyQualifiers.size(); ++ii) {
                try {
                    SigPolicyQualifierInfo policyQualifierInfo = sigPolicyQualifiers.getInfoAt(ii);
                    ASN1ObjectIdentifier policyQualifierInfoId = policyQualifierInfo.getSigPolicyQualifierId();
                    String policyQualifierInfoValue = policyQualifierInfo.getSigQualifier().toString();
                    if (PKCSObjectIdentifiers.id_spq_ets_uri.equals((ASN1Primitive)policyQualifierInfoId)) {
                        this.signaturePolicy.setUri(policyQualifierInfoValue);
                        continue;
                    }
                    if (PKCSObjectIdentifiers.id_spq_ets_unotice.equals((ASN1Primitive)policyQualifierInfoId)) {
                        SPUserNotice spUserNotice = SPUserNotice.getInstance((Object)policyQualifierInfo.getSigQualifier());
                        this.signaturePolicy.setUserNotice(this.buildSPUserNoticeString(spUserNotice));
                        continue;
                    }
                    if (OID.id_sp_doc_specification.equals((ASN1Primitive)policyQualifierInfoId)) {
                        SpDocSpecification spDocSpecification = new SpDocSpecification();
                        spDocSpecification.setId(policyQualifierInfoValue);
                        this.signaturePolicy.setDocSpecification(spDocSpecification);
                        continue;
                    }
                    LOG.warn("Unknown signature policy qualifier id: {} with value: {}", (Object)policyQualifierInfoId, (Object)policyQualifierInfoValue);
                    continue;
                }
                catch (Exception e) {
                    LOG.warn("Unable to read SigPolicyQualifierInfo {} : {}", (Object)ii, (Object)e.getMessage());
                }
            }
        }
        return this.signaturePolicy;
    }

    private UserNotice buildSPUserNoticeString(SPUserNotice spUserNotice) {
        DisplayText explicitText;
        UserNotice userNotice = new UserNotice();
        NoticeReference noticeRef = spUserNotice.getNoticeRef();
        if (noticeRef != null) {
            ASN1Integer[] noticeNumbers;
            DisplayText organization = noticeRef.getOrganization();
            if (organization != null) {
                userNotice.setOrganization(organization.getString());
            }
            if ((noticeNumbers = noticeRef.getNoticeNumbers()) != null && noticeNumbers.length != 0) {
                int[] noticeNumbersArray = new int[noticeNumbers.length];
                for (int i = 0; i < noticeNumbers.length; ++i) {
                    noticeNumbersArray[i] = noticeNumbers[i].intValueExact();
                }
                userNotice.setNoticeNumbers(noticeNumbersArray);
            }
        }
        if ((explicitText = spUserNotice.getExplicitText()) != null) {
            userNotice.setExplicitText(explicitText.getString());
        }
        return userNotice;
    }

    public SignaturePolicyStore getSignaturePolicyStore() {
        Attribute sigPolicyStore = CMSUtils.getUnsignedAttribute(this.signerInformation, OID.id_aa_ets_sigPolicyStore);
        if (sigPolicyStore != null && sigPolicyStore.getAttrValues().size() > 0) {
            SignaturePolicyStore signaturePolicyStore = new SignaturePolicyStore();
            SpDocSpecification spDocSpecification = new SpDocSpecification();
            ASN1Sequence sequence = ASN1Sequence.getInstance((Object)sigPolicyStore.getAttrValues().getObjectAt(0));
            if (sequence.size() == 2) {
                ASN1Encodable spDocSpec = sequence.getObjectAt(0);
                spDocSpecification.setId(spDocSpec.toString());
                ASN1Encodable spDocument = sequence.getObjectAt(1);
                if (spDocument instanceof ASN1OctetString) {
                    ASN1OctetString sigPolicyEncoded = ASN1OctetString.getInstance((Object)spDocument);
                    signaturePolicyStore.setSignaturePolicyContent((DSSDocument)new InMemoryDocument(sigPolicyEncoded.getOctets()));
                } else if (spDocument instanceof ASN1IA5String) {
                    ASN1IA5String sigPolicyLocalURI = ASN1IA5String.getInstance((Object)spDocument);
                    signaturePolicyStore.setSigPolDocLocalURI(sigPolicyLocalURI.getString());
                } else {
                    LOG.warn("Unable to extract a signature-policy-store spDocument. One of 'sigPolicyEncoded' or 'sigPolicyLocalURI' is expected!");
                }
                signaturePolicyStore.setSpDocSpecification(spDocSpecification);
                return signaturePolicyStore;
            }
            LOG.warn("Unable to extract a signature-policy-store. The element shall contain two attributes.");
        }
        return null;
    }

    private boolean isZeroHash(byte[] hashValue) {
        return this.isZeroHashEmpty(hashValue) || this.doesZeroHashContainSigneZeroByte(hashValue);
    }

    private boolean isZeroHashEmpty(byte[] hashValue) {
        return hashValue != null && hashValue.length == 0;
    }

    private boolean doesZeroHashContainSigneZeroByte(byte[] hashValue) {
        return hashValue != null && hashValue.length == 1 && (hashValue[0] == 48 || hashValue[0] == 0);
    }

    public Date getSigningTime() {
        Attribute attr = CMSUtils.getSignedAttribute(this.signerInformation, PKCSObjectIdentifiers.pkcs_9_at_signingTime);
        if (attr == null) {
            return null;
        }
        ASN1Set attrValues = attr.getAttrValues();
        ASN1Encodable attrValue = attrValues.getObjectAt(0);
        return CMSUtils.readSigningDate(attrValue);
    }

    public CMSSignedData getCmsSignedData() {
        return this.cmsSignedData;
    }

    public SignatureProductionPlace getSignatureProductionPlace() {
        ASN1Sequence seq;
        DirectoryString localityName;
        Attribute signatureProductionPlaceAttr = CMSUtils.getSignedAttribute(this.signerInformation, PKCSObjectIdentifiers.id_aa_ets_signerLocation);
        if (signatureProductionPlaceAttr == null) {
            return null;
        }
        ASN1Encodable asn1Encodable = signatureProductionPlaceAttr.getAttrValues().getObjectAt(0);
        SignerLocation signerLocation = null;
        try {
            signerLocation = SignerLocation.getInstance((Object)asn1Encodable);
        }
        catch (Exception e) {
            String errorMessage = "Unable to build a SignerLocation instance. Reason : {}";
            if (LOG.isDebugEnabled()) {
                LOG.warn(errorMessage, (Object)e.getMessage(), (Object)e);
            }
            LOG.warn(errorMessage, (Object)e.getMessage());
        }
        if (signerLocation == null) {
            return null;
        }
        SignatureProductionPlace signatureProductionPlace = new SignatureProductionPlace();
        DirectoryString countryName = signerLocation.getCountry();
        if (countryName != null) {
            signatureProductionPlace.setCountryName(countryName.getString());
        }
        if ((localityName = signerLocation.getLocality()) != null) {
            signatureProductionPlace.setCity(localityName.getString());
        }
        if ((seq = signerLocation.getPostalAddress()) != null) {
            for (int ii = 0; ii < seq.size(); ++ii) {
                String postalAddress = DSSASN1Utils.getDirectoryStringValue((ASN1Encodable)seq.getObjectAt(ii));
                if (!Utils.isStringNotEmpty((String)postalAddress)) continue;
                signatureProductionPlace.getPostalAddress().add(postalAddress);
            }
        }
        return signatureProductionPlace;
    }

    public List<CommitmentTypeIndication> getCommitmentTypeIndications() {
        Attribute commitmentTypeIndicationAttribute = CMSUtils.getSignedAttribute(this.signerInformation, PKCSObjectIdentifiers.id_aa_ets_commitmentType);
        if (commitmentTypeIndicationAttribute == null) {
            return Collections.emptyList();
        }
        try {
            ArrayList<CommitmentTypeIndication> commitmentTypeIndications = null;
            ASN1Set attrValues = commitmentTypeIndicationAttribute.getAttrValues();
            int size = attrValues.size();
            if (size > 0) {
                commitmentTypeIndications = new ArrayList<CommitmentTypeIndication>();
                for (int ii = 0; ii < size; ++ii) {
                    if (attrValues.getObjectAt(ii) instanceof ASN1Sequence) {
                        ASN1Sequence sequence = (ASN1Sequence)attrValues.getObjectAt(ii);
                        org.bouncycastle.asn1.esf.CommitmentTypeIndication commitmentTypeIndication = org.bouncycastle.asn1.esf.CommitmentTypeIndication.getInstance((Object)sequence);
                        ASN1ObjectIdentifier commitmentTypeId = commitmentTypeIndication.getCommitmentTypeId();
                        commitmentTypeIndications.add(new CommitmentTypeIndication(commitmentTypeId.getId()));
                        continue;
                    }
                    LOG.warn("Unsupported type for CommitmentType : {}", (Object)attrValues.getObjectAt(ii).getClass());
                }
            }
            return commitmentTypeIndications;
        }
        catch (Exception e) {
            LOG.warn("An error while extracting CommitmentTypeIndication. Reason : {}", (Object)e.getMessage(), (Object)e);
            return Collections.emptyList();
        }
    }

    public List<SignerRole> getSignedAssertions() {
        ArrayList<SignerRole> result = new ArrayList<SignerRole>();
        SignerAttributeV2 signerAttrV2 = this.getSignerAttributeV2();
        if (signerAttrV2 != null) {
            for (Object signerAttrValue : signerAttrV2.getValues()) {
                if (!(signerAttrValue instanceof SignedAssertions)) continue;
                List<SignedAssertion> assertions = ((SignedAssertions)((Object)signerAttrValue)).getAssertions();
                for (SignedAssertion sa : assertions) {
                    result.add(new SignerRole(sa.toString(), EndorsementType.SIGNED));
                }
            }
        }
        return result;
    }

    public List<SignerRole> getClaimedSignerRoles() {
        SignerAttribute signerAttr = this.getSignerAttributeV1();
        SignerAttributeV2 signerAttrV2 = this.getSignerAttributeV2();
        Object[] signerAttrValues = null;
        try {
            if (signerAttr != null) {
                signerAttrValues = signerAttr.getValues();
            } else if (signerAttrV2 != null) {
                signerAttrValues = signerAttrV2.getValues();
            }
            if (signerAttrValues == null) {
                return Collections.emptyList();
            }
            ArrayList<SignerRole> claimedRoles = new ArrayList<SignerRole>();
            for (Object signerAttrValue : signerAttrValues) {
                org.bouncycastle.asn1.x509.Attribute[] signerAttrValueArray;
                if (!(signerAttrValue instanceof org.bouncycastle.asn1.x509.Attribute[])) continue;
                for (org.bouncycastle.asn1.x509.Attribute claimedRole : signerAttrValueArray = (org.bouncycastle.asn1.x509.Attribute[])signerAttrValue) {
                    claimedRoles.addAll(this.getClaimedSignerRoles(claimedRole));
                }
            }
            return claimedRoles;
        }
        catch (Exception e) {
            LOG.warn("Error when dealing with claimed signer roles : {}", (Object)signerAttrValues, (Object)e);
            return Collections.emptyList();
        }
    }

    private List<SignerRole> getClaimedSignerRoles(org.bouncycastle.asn1.x509.Attribute claimedRole) {
        ASN1Encodable[] attrValues1;
        ArrayList<SignerRole> claimedRoles = new ArrayList<SignerRole>();
        for (ASN1Encodable asn1Encodable : attrValues1 = claimedRole.getAttrValues().toArray()) {
            if (!(asn1Encodable instanceof ASN1String)) continue;
            ASN1String asn1String = (ASN1String)asn1Encodable;
            String role = asn1String.getString();
            claimedRoles.add(new SignerRole(role, EndorsementType.CLAIMED));
        }
        return claimedRoles;
    }

    public List<SignerRole> getCertifiedSignerRoles() {
        SignerAttribute signerAttr = this.getSignerAttributeV1();
        SignerAttributeV2 signerAttrV2 = this.getSignerAttributeV2();
        Object[] signerAttrValues = null;
        try {
            if (signerAttr != null) {
                signerAttrValues = signerAttr.getValues();
            } else if (signerAttrV2 != null) {
                signerAttrValues = signerAttrV2.getValues();
            }
            if (signerAttrValues == null) {
                return Collections.emptyList();
            }
            ArrayList<SignerRole> roles = new ArrayList<SignerRole>();
            for (Object signerAttrValue : signerAttrValues) {
                if (!(signerAttrValue instanceof AttributeCertificate)) continue;
                roles.addAll(this.getCertifiedSignerRoles((AttributeCertificate)signerAttrValue));
            }
            return roles;
        }
        catch (Exception e) {
            LOG.warn("Error when dealing with certified signer roles : {}", (Object)signerAttrValues, (Object)e);
            return Collections.emptyList();
        }
    }

    private List<SignerRole> getCertifiedSignerRoles(AttributeCertificate attributeCertificate) {
        ArrayList<SignerRole> roles = new ArrayList<SignerRole>();
        AttributeCertificateInfo acInfo = attributeCertificate.getAcinfo();
        AttCertValidityPeriod attrCertValidityPeriod = acInfo.getAttrCertValidityPeriod();
        ASN1Sequence attributes = acInfo.getAttributes();
        for (int ii = 0; ii < attributes.size(); ++ii) {
            ASN1Encodable objectAt = attributes.getObjectAt(ii);
            org.bouncycastle.asn1.x509.Attribute attribute = org.bouncycastle.asn1.x509.Attribute.getInstance((Object)objectAt);
            ASN1Set attrValues1 = attribute.getAttrValues();
            ASN1Encodable firstItem = attrValues1.getObjectAt(0);
            if (firstItem instanceof ASN1Sequence) {
                ASN1Sequence sequence = (ASN1Sequence)firstItem;
                RoleSyntax roleSyntax = RoleSyntax.getInstance((Object)sequence);
                SignerRole certifiedRole = new SignerRole(roleSyntax.getRoleNameAsString(), EndorsementType.CERTIFIED);
                certifiedRole.setNotBefore(DSSASN1Utils.toDate((ASN1GeneralizedTime)attrCertValidityPeriod.getNotBeforeTime()));
                certifiedRole.setNotAfter(DSSASN1Utils.toDate((ASN1GeneralizedTime)attrCertValidityPeriod.getNotAfterTime()));
                roles.add(certifiedRole);
                continue;
            }
            LOG.warn("Unsupported type for RoleSyntax : {}", firstItem == null ? null : firstItem.getClass().getSimpleName());
        }
        return roles;
    }

    private SignerAttribute getSignerAttributeV1() {
        Attribute idAaEtsSignerAttr = CMSUtils.getSignedAttribute(this.signerInformation, PKCSObjectIdentifiers.id_aa_ets_signerAttr);
        if (idAaEtsSignerAttr != null) {
            ASN1Set attrValues = idAaEtsSignerAttr.getAttrValues();
            ASN1Encodable attrValue = attrValues.getObjectAt(0);
            try {
                return SignerAttribute.getInstance((Object)attrValue);
            }
            catch (Exception e) {
                String warningMessage = "Unable to parse signerAttr - [{}]. Reason : {}";
                if (LOG.isDebugEnabled()) {
                    LOG.warn(warningMessage, new Object[]{Utils.toBase64((byte[])DSSASN1Utils.getDEREncoded((ASN1Encodable)attrValue)), e.getMessage(), e});
                }
                LOG.warn(warningMessage, (Object)Utils.toBase64((byte[])DSSASN1Utils.getDEREncoded((ASN1Encodable)attrValue)), (Object)e.getMessage());
            }
        }
        return null;
    }

    private SignerAttributeV2 getSignerAttributeV2() {
        Attribute idAaEtsSignerAttrV2 = CMSUtils.getSignedAttribute(this.signerInformation, OID.id_aa_ets_signerAttrV2);
        if (idAaEtsSignerAttrV2 != null) {
            ASN1Set attrValues = idAaEtsSignerAttrV2.getAttrValues();
            ASN1Encodable attrValue = attrValues.getObjectAt(0);
            try {
                return SignerAttributeV2.getInstance(attrValue);
            }
            catch (Exception e) {
                LOG.warn("Unable to parse signerAttrV2 : {}", (Object)Utils.toBase64((byte[])DSSASN1Utils.getDEREncoded((ASN1Encodable)attrValue)), (Object)e);
            }
        }
        return null;
    }

    public EncryptionAlgorithm getEncryptionAlgorithm() {
        String oid = this.signerInformation.getEncryptionAlgOID();
        try {
            return EncryptionAlgorithm.forOID((String)oid);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.forOID((String)oid);
                return signatureAlgorithm.getEncryptionAlgorithm();
            }
            catch (IllegalArgumentException e) {
                LOG.warn("Unable to identify encryption algorithm for OID '{}'. Reason : {}", (Object)oid, (Object)e.getMessage());
                return null;
            }
        }
    }

    public DigestAlgorithm getDigestAlgorithm() {
        SignatureAlgorithm signatureAlgorithm = this.getEncryptedDigestAlgo();
        if (signatureAlgorithm != null) {
            if (EncryptionAlgorithm.RSASSA_PSS.equals((Object)signatureAlgorithm.getEncryptionAlgorithm())) {
                return this.getPSSHashAlgorithm();
            }
            return signatureAlgorithm.getDigestAlgorithm();
        }
        String digestAlgOID = this.signerInformation.getDigestAlgOID();
        try {
            return DigestAlgorithm.forOID((String)digestAlgOID);
        }
        catch (IllegalArgumentException e) {
            LOG.warn("Unable to identify DigestAlgorithm for OID '{}'. Reason : {}", (Object)digestAlgOID, (Object)e.getMessage());
            return null;
        }
    }

    private SignatureAlgorithm getEncryptedDigestAlgo() {
        try {
            return SignatureAlgorithm.forOID((String)this.signerInformation.getEncryptionAlgOID());
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    private DigestAlgorithm getPSSHashAlgorithm() {
        try {
            byte[] encryptionAlgParams = this.signerInformation.getEncryptionAlgParams();
            if (Utils.isArrayNotEmpty((byte[])encryptionAlgParams) && !Arrays.equals(DERNull.INSTANCE.getEncoded(), encryptionAlgParams)) {
                RSASSAPSSparams param = RSASSAPSSparams.getInstance((Object)encryptionAlgParams);
                AlgorithmIdentifier pssHashAlgo = param.getHashAlgorithm();
                return DigestAlgorithm.forOID((String)pssHashAlgo.getAlgorithm().getId());
            }
        }
        catch (IOException e) {
            LOG.warn("Unable to analyze EncryptionAlgParams", (Throwable)e);
        }
        return null;
    }

    @Deprecated
    public MaskGenerationFunction getMaskGenerationFunction() {
        EncryptionAlgorithm encryptionAlgorithm = this.getEncryptionAlgorithm();
        if (EncryptionAlgorithm.RSASSA_PSS == encryptionAlgorithm) {
            return MaskGenerationFunction.MGF1;
        }
        return null;
    }

    public SignatureAlgorithm getSignatureAlgorithm() {
        return SignatureAlgorithm.getAlgorithm((EncryptionAlgorithm)this.getEncryptionAlgorithm(), (DigestAlgorithm)this.getDigestAlgorithm());
    }

    public void checkSignatureIntegrity() {
        if (this.signatureCryptographicVerification != null) {
            return;
        }
        this.signatureCryptographicVerification = new SignatureCryptographicVerification();
        try {
            boolean detachedSignature = CMSUtils.isDetachedSignature(this.cmsSignedData);
            SignerInformation signerInformationToCheck = null;
            if (detachedSignature && !this.isCounterSignature()) {
                if (Utils.isCollectionEmpty((Collection)this.detachedContents)) {
                    this.signatureCryptographicVerification.setErrorMessage("Detached file not found!");
                    this.getReferenceValidations(signerInformationToCheck);
                    return;
                }
                signerInformationToCheck = this.recreateSignerInformation();
            } else {
                signerInformationToCheck = this.signerInformation;
            }
            CandidatesForSigningCertificate candidatesForSigningCertificate = this.getCandidatesForSigningCertificate();
            CAdESSignatureIntegrityValidator signingCertificateValidator = new CAdESSignatureIntegrityValidator(signerInformationToCheck);
            CertificateValidity certificateValidity = signingCertificateValidator.validate(candidatesForSigningCertificate);
            if (certificateValidity != null) {
                candidatesForSigningCertificate.setTheCertificateValidity(certificateValidity);
            }
            List errorMessages = signingCertificateValidator.getErrorMessages();
            this.signatureCryptographicVerification.setErrorMessages(errorMessages);
            this.signatureCryptographicVerification.setSignatureIntact(certificateValidity != null);
            boolean referenceDataFound = true;
            boolean referenceDataIntact = true;
            List<ReferenceValidation> refValidations = this.getReferenceValidations(signerInformationToCheck);
            for (ReferenceValidation referenceValidation : refValidations) {
                referenceDataFound = referenceDataFound && referenceValidation.isFound();
                referenceDataIntact = referenceDataIntact && referenceValidation.isIntact();
            }
            this.signatureCryptographicVerification.setReferenceDataFound(referenceDataFound);
            this.signatureCryptographicVerification.setReferenceDataIntact(referenceDataIntact);
        }
        catch (IOException | CMSException e) {
            LOG.warn(e.getMessage(), e);
            this.signatureCryptographicVerification.setErrorMessage(e.getMessage());
        }
        LOG.debug(" - RESULT: {}", (Object)this.signatureCryptographicVerification);
    }

    public List<ReferenceValidation> getReferenceValidations(SignerInformation signerInformationToCheck) {
        if (this.referenceValidations == null) {
            ReferenceValidation validation;
            this.referenceValidations = new ArrayList();
            DSSDocument originalDocument = null;
            try {
                originalDocument = this.getSignerDocumentContent();
            }
            catch (DSSException e) {
                LOG.warn("Original document not found");
            }
            byte[] messageDigestValue = this.getMessageDigestValue();
            if (messageDigestValue != null) {
                validation = this.getMessageDigestReferenceValidation(originalDocument, messageDigestValue);
            } else {
                LOG.warn("message-digest is not present in SignedData! Extracting digests from content SignatureValue...");
                validation = this.getContentReferenceValidation(originalDocument, signerInformationToCheck);
            }
            this.referenceValidations.add(validation);
        }
        return this.referenceValidations;
    }

    protected DSSDocument getSignerDocumentContent() {
        return this.getOriginalDocument();
    }

    private boolean verifyDigestAlgorithm(DSSDocument originalDocument, Set<DigestAlgorithm> messageDigestAlgorithms, Digest messageDigest) {
        if (Utils.isCollectionNotEmpty(messageDigestAlgorithms)) {
            for (DigestAlgorithm digestAlgorithm : messageDigestAlgorithms) {
                byte[] base64Digest = originalDocument.getDigestValue(digestAlgorithm);
                if (!Arrays.equals(messageDigest.getValue(), base64Digest)) continue;
                messageDigest.setAlgorithm(digestAlgorithm);
                return true;
            }
        } else {
            LOG.warn("Message DigestAlgorithms not found in SignedData! Reference validation is not possible.");
        }
        return false;
    }

    private List<ReferenceValidation> getManifestEntryValidation() {
        ArrayList<ReferenceValidation> manifestEntryValidations = new ArrayList<ReferenceValidation>();
        if (this.manifestFile == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No related manifest file found for a signature with name [{}]", (Object)this.getSignatureFilename());
            }
            return manifestEntryValidations;
        }
        for (ManifestEntry entry : this.manifestFile.getEntries()) {
            ReferenceValidation entryValidation = new ReferenceValidation();
            entryValidation.setType(DigestMatcherType.MANIFEST_ENTRY);
            entryValidation.setUri(entry.getUri());
            entryValidation.setDocumentName(entry.getDocumentName());
            entryValidation.setDigest(entry.getDigest());
            entryValidation.setFound(entry.isFound());
            entryValidation.setIntact(entry.isIntact());
            manifestEntryValidations.add(entryValidation);
        }
        return manifestEntryValidations;
    }

    public List<ReferenceValidation> getReferenceValidations() {
        this.checkSignatureIntegrity();
        return this.referenceValidations;
    }

    private ReferenceValidation getMessageDigestReferenceValidation(DSSDocument originalDocument, byte[] messageDigestValue) {
        ReferenceValidation messageDigestValidation = new ReferenceValidation();
        messageDigestValidation.setType(DigestMatcherType.MESSAGE_DIGEST);
        Digest messageDigest = new Digest();
        messageDigest.setValue(messageDigestValue);
        messageDigestValidation.setDigest(messageDigest);
        HashSet<DigestAlgorithm> digestAlgorithmCandidates = new HashSet<DigestAlgorithm>();
        DigestAlgorithm signerInformationDigestAlgorithm = this.getDigestAlgorithm();
        if (signerInformationDigestAlgorithm != null) {
            digestAlgorithmCandidates.add(signerInformationDigestAlgorithm);
        }
        digestAlgorithmCandidates.addAll(this.getMessageDigestAlgorithms());
        if (Utils.collectionSize(digestAlgorithmCandidates) == 1) {
            messageDigest.setAlgorithm((DigestAlgorithm)digestAlgorithmCandidates.iterator().next());
        }
        if (originalDocument != null) {
            messageDigestValidation.setDocumentName(originalDocument.getName());
            messageDigestValidation.setFound(true);
            messageDigestValidation.setIntact(this.verifyDigestAlgorithm(originalDocument, digestAlgorithmCandidates, messageDigest));
            if (this.manifestFile != null && Arrays.equals(messageDigest.getValue(), this.manifestFile.getDigestValue(messageDigest.getAlgorithm()))) {
                messageDigestValidation.getDependentValidations().addAll(this.getManifestEntryValidation());
            }
        } else {
            LOG.warn("The original document is not found or cannot be extracted. Reference validation is not possible.");
        }
        return messageDigestValidation;
    }

    private ReferenceValidation getContentReferenceValidation(DSSDocument originalDocument, SignerInformation signerInformation) {
        ReferenceValidation contentValidation = new ReferenceValidation();
        contentValidation.setType(DigestMatcherType.CONTENT_DIGEST);
        if (signerInformation != null) {
            byte[] contentDigest;
            DigestAlgorithm digestAlgorithm = this.getDigestAlgorithmForOID(signerInformation.getDigestAlgOID());
            if (originalDocument != null && digestAlgorithm != null && Utils.isArrayNotEmpty((byte[])(contentDigest = signerInformation.getContentDigest()))) {
                contentValidation.setFound(true);
                contentValidation.setDigest(new Digest(digestAlgorithm, contentDigest));
                if (Arrays.equals(contentDigest, originalDocument.getDigestValue(digestAlgorithm))) {
                    contentValidation.setIntact(true);
                }
            }
        }
        return contentValidation;
    }

    public SignatureDigestReference getSignatureDigestReference(DigestAlgorithm digestAlgorithm) {
        byte[] derEncodedSignerInfo = DSSASN1Utils.getDEREncoded((ASN1Encodable)this.signerInformation.toASN1Structure());
        byte[] digestValue = DSSUtils.digest((DigestAlgorithm)digestAlgorithm, (byte[])derEncodedSignerInfo);
        return new SignatureDigestReference(new Digest(digestAlgorithm, digestValue));
    }

    public Digest getDataToBeSignedRepresentation() {
        List<ReferenceValidation> referenceValidations = this.getReferenceValidations();
        ReferenceValidation referenceValidation = referenceValidations.iterator().next();
        switch (referenceValidation.getType()) {
            case MESSAGE_DIGEST: {
                DigestAlgorithm digestAlgorithm = this.getDigestAlgorithm();
                if (digestAlgorithm != null) {
                    AttributeTable signedAttributes = CMSUtils.getSignedAttributes(this.signerInformation);
                    byte[] derEncoded = DSSASN1Utils.getDEREncoded((ASN1Encodable)signedAttributes.toASN1Structure());
                    return new Digest(digestAlgorithm, DSSUtils.digest((DigestAlgorithm)digestAlgorithm, (byte[])derEncoded));
                }
                return null;
            }
            case CONTENT_DIGEST: {
                return referenceValidation.getDigest();
            }
        }
        throw new DSSException(String.format("The found referenceValidation type '%s' is not supported! Unable to compute DTBSR.", referenceValidation.getType()));
    }

    private SignerInformation recreateSignerInformation() throws CMSException, IOException {
        CMSSignedDataParser cmsSignedDataParser;
        DSSDocument dssDocument = (DSSDocument)this.detachedContents.get(0);
        if (dssDocument instanceof DigestDocument) {
            cmsSignedDataParser = new CMSSignedDataParser((DigestCalculatorProvider)new PrecomputedDigestCalculatorProvider((DigestDocument)dssDocument), this.cmsSignedData.getEncoded());
        } else {
            try (InputStream inputStream = dssDocument.openStream();){
                CMSTypedStream signedContent = new CMSTypedStream(inputStream);
                cmsSignedDataParser = new CMSSignedDataParser((DigestCalculatorProvider)new BcDigestCalculatorProvider(), signedContent, this.cmsSignedData.getEncoded());
                cmsSignedDataParser.getSignedContent().drain();
            }
        }
        SignerId signerId = this.getSignerId();
        return cmsSignedDataParser.getSignerInfos().get(signerId);
    }

    public Set<DigestAlgorithm> getMessageDigestAlgorithms() {
        HashSet<DigestAlgorithm> result = new HashSet<DigestAlgorithm>();
        Set digestAlgorithmIDs = this.cmsSignedData.getDigestAlgorithmIDs();
        for (AlgorithmIdentifier algorithmIdentifier : digestAlgorithmIDs) {
            String oid = algorithmIdentifier.getAlgorithm().getId();
            DigestAlgorithm digestAlgorithm = this.getDigestAlgorithmForOID(oid);
            if (digestAlgorithm == null) continue;
            result.add(digestAlgorithm);
        }
        return result;
    }

    private DigestAlgorithm getDigestAlgorithmForOID(String oid) {
        try {
            return DigestAlgorithm.forOID((String)oid);
        }
        catch (IllegalArgumentException e) {
            LOG.warn("Not a digest algorithm {} : {}", (Object)oid, (Object)e.getMessage());
            return null;
        }
    }

    public byte[] getMessageDigestValue() {
        Attribute messageDigestAttribute = CMSUtils.getSignedAttribute(this.signerInformation, PKCSObjectIdentifiers.pkcs_9_at_messageDigest);
        if (messageDigestAttribute == null) {
            return null;
        }
        ASN1OctetString asn1OctetString = (ASN1OctetString)messageDigestAttribute.getAttrValues().getObjectAt(0);
        return asn1OctetString.getOctets();
    }

    public String getContentType() {
        Attribute contentTypeAttribute = CMSUtils.getSignedAttribute(this.signerInformation, PKCSObjectIdentifiers.pkcs_9_at_contentType);
        if (contentTypeAttribute == null) {
            return null;
        }
        ASN1ObjectIdentifier oid = (ASN1ObjectIdentifier)contentTypeAttribute.getAttrValues().getObjectAt(0);
        return oid.getId();
    }

    public String getMimeType() {
        Attribute mimeTypeAttribute = CMSUtils.getSignedAttribute(this.signerInformation, OID.id_aa_ets_mimeType);
        if (mimeTypeAttribute == null) {
            return null;
        }
        return DSSASN1Utils.getString((ASN1Encodable)mimeTypeAttribute.getAttrValues().getObjectAt(0));
    }

    public String getContentIdentifier() {
        Attribute contentIdentifierAttribute = CMSUtils.getSignedAttribute(this.signerInformation, PKCSObjectIdentifiers.id_aa_contentIdentifier);
        if (contentIdentifierAttribute == null) {
            return null;
        }
        ASN1Encodable asn1Encodable = contentIdentifierAttribute.getAttrValues().getObjectAt(0);
        ContentIdentifier contentIdentifier = ContentIdentifier.getInstance((Object)asn1Encodable);
        return DSSASN1Utils.toString((ASN1OctetString)contentIdentifier.getValue());
    }

    public String getContentHints() {
        Attribute contentHintAttribute = CMSUtils.getSignedAttribute(this.signerInformation, PKCSObjectIdentifiers.id_aa_contentHint);
        if (contentHintAttribute == null) {
            return null;
        }
        ASN1Encodable asn1Encodable = contentHintAttribute.getAttrValues().getObjectAt(0);
        String contentHint = null;
        try {
            ContentHints contentHints = ContentHints.getInstance((Object)asn1Encodable);
            if (contentHints != null) {
                contentHint = contentHints.getContentType().toString();
                if (contentHints.getContentDescriptionUTF8() != null) {
                    contentHint = contentHint + " [" + contentHints.getContentDescriptionUTF8().toString() + "]";
                }
            }
        }
        catch (Exception e) {
            String warningMessage = "Unable to parse ContentHints - [{}]. Reason : {}";
            if (LOG.isDebugEnabled()) {
                LOG.warn(warningMessage, new Object[]{Utils.toBase64((byte[])DSSASN1Utils.getDEREncoded((ASN1Encodable)asn1Encodable)), e.getMessage(), e});
            }
            LOG.warn(warningMessage, (Object)Utils.toBase64((byte[])DSSASN1Utils.getDEREncoded((ASN1Encodable)asn1Encodable)), (Object)e.getMessage());
        }
        return contentHint;
    }

    public SignerInformation getSignerInformation() {
        return this.signerInformation;
    }

    public byte[] getSignatureValue() {
        return this.signerInformation.getSignature();
    }

    public boolean isCounterSignature() {
        return this.signerInformation.isCounterSignature();
    }

    public List<AdvancedSignature> getCounterSignatures() {
        if (this.counterSignatures != null) {
            return this.counterSignatures;
        }
        this.counterSignatures = new ArrayList();
        for (SignerInformation counterSignerInformation : this.getCounterSignatureStore()) {
            CAdESSignature counterSignature = new CAdESSignature(this.cmsSignedData, counterSignerInformation);
            counterSignature.setSignatureFilename(this.getSignatureFilename());
            counterSignature.setMasterSignature((AdvancedSignature)this);
            this.counterSignatures.add(counterSignature);
        }
        return this.counterSignatures;
    }

    protected SignerInformationStore getCounterSignatureStore() {
        if (this.counterSignaturesStore == null) {
            this.counterSignaturesStore = this.signerInformation.getCounterSignatures();
        }
        return this.counterSignaturesStore;
    }

    public DSSDocument getOriginalDocument() {
        if (this.isCounterSignature()) {
            return new InMemoryDocument(this.getMasterSignature().getSignatureValue());
        }
        return CMSUtils.getOriginalDocument(this.cmsSignedData, this.detachedContents);
    }

    protected SignatureIdentifierBuilder getSignatureIdentifierBuilder() {
        return new CAdESSignatureIdentifierBuilder(this);
    }

    public String getDAIdentifier() {
        return null;
    }

    public Set<SignerIdentifier> getSignerInformationStoreInfos() {
        return this.getCertificateSource().getAllCertificateIdentifiers();
    }

    public void addExternalTimestamp(TimestampToken timestamp) {
        if (!timestamp.isProcessed()) {
            throw new DSSException("Timestamp token must be validated first !");
        }
        this.getTimestampSource().addExternalTimestamp(timestamp);
    }

    public SignatureLevel getDataFoundUpToLevel() {
        if (!this.hasBESProfile()) {
            return SignatureLevel.CMS_NOT_ETSI;
        }
        boolean baselineProfile = this.hasBProfile();
        if (!this.hasExtendedTProfile()) {
            if (baselineProfile) {
                return SignatureLevel.CAdES_BASELINE_B;
            }
            if (this.hasEPESProfile()) {
                return SignatureLevel.CAdES_EPES;
            }
            return SignatureLevel.CAdES_BES;
        }
        boolean bl = baselineProfile = baselineProfile && this.hasTProfile();
        if (baselineProfile && this.hasLTProfile()) {
            if (this.hasLTAProfile()) {
                return SignatureLevel.CAdES_BASELINE_LTA;
            }
            return SignatureLevel.CAdES_BASELINE_LT;
        }
        if (this.hasCProfile()) {
            if (this.hasXLProfile()) {
                if (this.hasAProfile()) {
                    return SignatureLevel.CAdES_A;
                }
                if (this.hasXProfile()) {
                    return SignatureLevel.CAdES_XL;
                }
            }
            if (this.hasXProfile()) {
                return SignatureLevel.CAdES_X;
            }
            return SignatureLevel.CAdES_C;
        }
        if (this.hasXLProfile()) {
            if (this.hasAProfile()) {
                return SignatureLevel.CAdES_A;
            }
            return SignatureLevel.CAdES_LT;
        }
        return baselineProfile ? SignatureLevel.CAdES_BASELINE_T : SignatureLevel.CAdES_T;
    }

    protected CAdESBaselineRequirementsChecker getBaselineRequirementsChecker() {
        return (CAdESBaselineRequirementsChecker)super.getBaselineRequirementsChecker();
    }

    protected CAdESBaselineRequirementsChecker createBaselineRequirementsChecker(CertificateVerifier certificateVerifier) {
        return new CAdESBaselineRequirementsChecker(this, certificateVerifier);
    }
}

