/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.validation.timestamp;

import eu.europa.esig.dss.cades.CMSUtils;
import eu.europa.esig.dss.cades.signature.CadesLevelBaselineLTATimestampExtractor;
import eu.europa.esig.dss.cades.validation.CAdESSignature;
import eu.europa.esig.dss.enumerations.ArchiveTimestampType;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.DSSMessageDigest;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSMessageDigestCalculator;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.OID;
import eu.europa.esig.dss.spi.validation.timestamp.TimestampMessageDigestBuilder;
import eu.europa.esig.dss.spi.x509.ListCertificateSource;
import eu.europa.esig.dss.spi.x509.tsp.TimestampToken;
import eu.europa.esig.dss.utils.Utils;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.BEROctetString;
import org.bouncycastle.asn1.BERSequence;
import org.bouncycastle.asn1.BERSet;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.SignedData;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.tsp.TimeStampToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CAdESTimestampMessageDigestBuilder
implements TimestampMessageDigestBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(CAdESTimestampMessageDigestBuilder.class);
    private static final String MESSAGE_IMPRINT_ERROR = "Unable to compute message-imprint for TimestampToken with Id '{}'. Reason : {}";
    private final CMSSignedData cmsSignedData;
    private final SignerInformation signerInformation;
    private final List<DSSDocument> detachedDocuments;
    private final CadesLevelBaselineLTATimestampExtractor timestampExtractor;
    private DigestAlgorithm digestAlgorithm;
    private TimestampToken timestampToken;

    public CAdESTimestampMessageDigestBuilder(CAdESSignature signature, ListCertificateSource certificateSource, DigestAlgorithm digestAlgorithm) {
        this(signature, certificateSource);
        Objects.requireNonNull(digestAlgorithm, "DigestAlgorithm cannot be null!");
        this.digestAlgorithm = digestAlgorithm;
    }

    public CAdESTimestampMessageDigestBuilder(CAdESSignature signature, ListCertificateSource certificateSource, TimestampToken timestampToken) {
        this(signature, certificateSource);
        Objects.requireNonNull(timestampToken, "TimestampToken cannot be null!");
        this.timestampToken = timestampToken;
        this.digestAlgorithm = timestampToken.getDigestAlgorithm();
    }

    private CAdESTimestampMessageDigestBuilder(CAdESSignature signature, ListCertificateSource certificateSource) {
        Objects.requireNonNull(signature, "Signature cannot be null!");
        Objects.requireNonNull(certificateSource, "ListCertificateSource cannot be null!");
        this.cmsSignedData = signature.getCmsSignedData();
        this.signerInformation = signature.getSignerInformation();
        this.detachedDocuments = signature.getDetachedContents();
        this.timestampExtractor = new CadesLevelBaselineLTATimestampExtractor(this.cmsSignedData, certificateSource.getCertificates());
    }

    public DSSMessageDigest getContentTimestampMessageDigest() {
        return this.getOriginalDocumentDigest();
    }

    public DSSMessageDigest getSignatureTimestampMessageDigest() {
        byte[] signature = this.signerInformation.getSignature();
        return new DSSMessageDigest(this.digestAlgorithm, DSSUtils.digest((DigestAlgorithm)this.digestAlgorithm, (byte[])signature));
    }

    public DSSMessageDigest getTimestampX1MessageDigest() {
        try {
            DSSMessageDigestCalculator digestCalculator = new DSSMessageDigestCalculator(this.digestAlgorithm);
            digestCalculator.update(this.signerInformation.getSignature());
            Object[] attributes = CMSUtils.getUnsignedAttributes(this.signerInformation, PKCSObjectIdentifiers.id_aa_signatureTimeStampToken);
            if (Utils.isArrayNotEmpty((Object[])attributes)) {
                for (Object attribute : attributes) {
                    digestCalculator.update(DSSASN1Utils.getDEREncoded((ASN1Encodable)attribute.getAttrType()));
                    digestCalculator.update(DSSASN1Utils.getDEREncoded((ASN1Encodable)attribute.getAttrValues()));
                }
            }
            this.writeTimestampX2MessageDigest(digestCalculator);
            return digestCalculator.getMessageDigest();
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.warn(MESSAGE_IMPRINT_ERROR, new Object[]{this.timestampToken.getDSSIdAsString(), e.getMessage(), e});
            } else {
                LOG.warn(MESSAGE_IMPRINT_ERROR, (Object)this.timestampToken.getDSSIdAsString(), (Object)e.getMessage());
            }
            return null;
        }
    }

    public DSSMessageDigest getTimestampX2MessageDigest() {
        try {
            DSSMessageDigestCalculator digestCalculator = new DSSMessageDigestCalculator(this.digestAlgorithm);
            this.writeTimestampX2MessageDigest(digestCalculator);
            return digestCalculator.getMessageDigest();
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.warn(MESSAGE_IMPRINT_ERROR, new Object[]{this.timestampToken.getDSSIdAsString(), e.getMessage(), e});
            } else {
                LOG.warn(MESSAGE_IMPRINT_ERROR, (Object)this.timestampToken.getDSSIdAsString(), (Object)e.getMessage());
            }
            return null;
        }
    }

    private void writeTimestampX2MessageDigest(DSSMessageDigestCalculator digestCalculator) {
        Object[] revAttributes;
        Object[] certAttributes = CMSUtils.getUnsignedAttributes(this.signerInformation, PKCSObjectIdentifiers.id_aa_ets_certificateRefs);
        if (Utils.isArrayNotEmpty((Object[])certAttributes)) {
            for (Object attribute : certAttributes) {
                digestCalculator.update(DSSASN1Utils.getDEREncoded((ASN1Encodable)attribute.getAttrType()));
                digestCalculator.update(DSSASN1Utils.getDEREncoded((ASN1Encodable)attribute.getAttrValues()));
            }
        }
        if (Utils.isArrayNotEmpty((Object[])(revAttributes = CMSUtils.getUnsignedAttributes(this.signerInformation, PKCSObjectIdentifiers.id_aa_ets_revocationRefs)))) {
            for (Object attribute : revAttributes) {
                digestCalculator.update(DSSASN1Utils.getDEREncoded((ASN1Encodable)attribute.getAttrType()));
                digestCalculator.update(DSSASN1Utils.getDEREncoded((ASN1Encodable)attribute.getAttrValues()));
            }
        }
    }

    public DSSMessageDigest getArchiveTimestampMessageDigest() {
        DSSMessageDigest messageDigest;
        ArchiveTimestampType archiveTimestampType = this.timestampToken != null ? this.timestampToken.getArchiveTimestampType() : ArchiveTimestampType.CAdES_V3;
        switch (archiveTimestampType) {
            case CAdES_V2: {
                messageDigest = this.getArchiveTimestampDataV2(true);
                if (this.timestampToken.matchData(messageDigest, true)) break;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Unable to match message imprint for an Archive TimestampToken V2 with Id '{}' by including unsigned attribute tags and length, try to compute the data without...", (Object)this.timestampToken.getDSSIdAsString());
                }
                messageDigest = this.getArchiveTimestampDataV2(false);
                break;
            }
            case CAdES_V3: {
                messageDigest = this.getArchiveTimestampDataV3();
                break;
            }
            default: {
                throw new DSSException("Unsupported ArchiveTimestampType " + archiveTimestampType);
            }
        }
        return messageDigest;
    }

    private DSSMessageDigest getArchiveTimestampDataV3() throws DSSException {
        Attribute atsHashIndexAttribute = this.timestampExtractor.getVerifiedAtsHashIndex(this.signerInformation, this.timestampToken);
        DSSDocument originalDocument = this.getOriginalDocument();
        if (originalDocument != null) {
            return this.timestampExtractor.getArchiveTimestampV3MessageImprint(this.signerInformation, atsHashIndexAttribute, originalDocument, this.digestAlgorithm);
        }
        LOG.warn("The original document is not found for TimestampToken with Id '{}'! Unable to compute message imprint.", (Object)this.timestampToken.getDSSIdAsString());
        return DSSMessageDigest.createEmptyDigest();
    }

    private DSSMessageDigest getOriginalDocumentDigest() {
        DSSDocument originalDocument = this.getOriginalDocument();
        if (originalDocument != null) {
            byte[] digest = originalDocument.getDigestValue(this.digestAlgorithm);
            return new DSSMessageDigest(this.digestAlgorithm, digest);
        }
        LOG.warn("The original document is not found for TimestampToken with Id '{}'! Unable to compute message imprint.", (Object)this.timestampToken.getDSSIdAsString());
        return DSSMessageDigest.createEmptyDigest();
    }

    private DSSMessageDigest getArchiveTimestampDataV2(boolean includeUnsignedAttrsTagAndLength) throws DSSException {
        try {
            DSSMessageDigestCalculator digestCalculator = new DSSMessageDigestCalculator(this.digestAlgorithm);
            ContentInfo contentInfo = this.cmsSignedData.toASN1Structure();
            SignedData signedData = SignedData.getInstance((Object)contentInfo.getContent());
            byte[] bytes = this.getContentInfoBytes(signedData);
            digestCalculator.update(bytes);
            if (CMSUtils.isDetachedSignature(this.cmsSignedData)) {
                bytes = this.getOriginalDocumentBinaries();
                if (bytes == null) {
                    LOG.warn("The detached content is not provided for a TimestampToken with Id '{}'. Not possible to compute message imprint!", (Object)this.timestampToken.getDSSIdAsString());
                    return DSSMessageDigest.createEmptyDigest();
                }
                digestCalculator.update(bytes);
            }
            if (Utils.isArrayNotEmpty((byte[])(bytes = this.getCertificateDataBytes(signedData)))) {
                digestCalculator.update(bytes);
            }
            if (Utils.isArrayNotEmpty((byte[])(bytes = this.getCRLDataBytes(signedData)))) {
                digestCalculator.update(bytes);
            }
            this.writeSignerInfoBytes(digestCalculator, includeUnsignedAttrsTagAndLength);
            return digestCalculator.getMessageDigest();
        }
        catch (Exception e) {
            LOG.warn("An error in computing of message-imprint for a TimestampToken with Id : {}. Reason : {}", new Object[]{this.timestampToken.getDSSIdAsString(), e.getMessage(), e});
            return null;
        }
    }

    private byte[] getContentInfoBytes(SignedData signedData) {
        ContentInfo content = signedData.getEncapContentInfo();
        byte[] contentInfoBytes = content.getContent() instanceof BEROctetString ? DSSASN1Utils.getBEREncoded((ASN1Encodable)content) : DSSASN1Utils.getDEREncoded((ASN1Encodable)content);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Content Info: {}", (Object)DSSUtils.toHex((byte[])contentInfoBytes));
        }
        return contentInfoBytes;
    }

    private byte[] getOriginalDocumentBinaries() {
        DSSDocument originalDocument = this.getOriginalDocument();
        if (originalDocument != null) {
            return DSSUtils.toByteArray((DSSDocument)this.getOriginalDocument());
        }
        return null;
    }

    private byte[] getCertificateDataBytes(SignedData signedData) throws IOException {
        byte[] certificatesBytes = null;
        ASN1Set certificates = signedData.getCertificates();
        if (certificates != null) {
            certificatesBytes = certificates instanceof BERSet ? new BERTaggedObject(false, 0, (ASN1Encodable)new BERSequence(certificates.toArray())).getEncoded() : new DERTaggedObject(false, 0, (ASN1Encodable)new DERSequence(certificates.toArray())).getEncoded();
            if (LOG.isTraceEnabled()) {
                LOG.trace("Certificates: {}", (Object)DSSUtils.toHex((byte[])certificatesBytes));
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Certificates are not present in the SignedData.");
        }
        return certificatesBytes;
    }

    private byte[] getCRLDataBytes(SignedData signedData) throws IOException {
        byte[] crlBytes = null;
        ASN1Set crLs = signedData.getCRLs();
        if (crLs != null) {
            crlBytes = signedData.getCRLs() instanceof BERSet ? new BERTaggedObject(false, 1, (ASN1Encodable)new BERSequence(crLs.toArray())).getEncoded() : new DERTaggedObject(false, 1, (ASN1Encodable)new DERSequence(crLs.toArray())).getEncoded();
            if (LOG.isTraceEnabled()) {
                LOG.trace("CRLs: {}", (Object)DSSUtils.toHex((byte[])crlBytes));
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("CRLs are not present in the SignedData.");
        }
        return crlBytes;
    }

    private void writeSignerInfoBytes(DSSMessageDigestCalculator digestCalculator, boolean includeUnsignedAttrsTagAndLength) {
        SignerInfo signerInfo = this.signerInformation.toASN1Structure();
        ASN1Set unauthenticatedAttributes = signerInfo.getUnauthenticatedAttributes();
        ASN1Sequence filteredUnauthenticatedAttributes = this.filterUnauthenticatedAttributes(unauthenticatedAttributes, this.timestampToken);
        ASN1Sequence asn1Object = this.getSignerInfoEncoded(signerInfo, filteredUnauthenticatedAttributes, includeUnsignedAttrsTagAndLength);
        for (int ii = 0; ii < asn1Object.size(); ++ii) {
            byte[] signerInfoBytes = DSSASN1Utils.getDEREncoded((ASN1Encodable)asn1Object.getObjectAt(ii).toASN1Primitive());
            if (LOG.isTraceEnabled()) {
                LOG.trace("SignerInfoBytes: {}", (Object)DSSUtils.toHex((byte[])signerInfoBytes));
            }
            digestCalculator.update(signerInfoBytes);
        }
    }

    private ASN1Sequence filterUnauthenticatedAttributes(ASN1Set unauthenticatedAttributes, TimestampToken timestampToken) {
        ASN1EncodableVector result = new ASN1EncodableVector();
        for (int ii = 0; ii < unauthenticatedAttributes.size(); ++ii) {
            Attribute attribute = Attribute.getInstance((Object)unauthenticatedAttributes.getObjectAt(ii));
            ASN1ObjectIdentifier attrType = attribute.getAttrType();
            if (OID.id_aa_ets_archiveTimestampV2.equals((ASN1Primitive)attrType) || OID.id_aa_ets_archiveTimestampV3.equals((ASN1Primitive)attrType)) {
                try {
                    TimeStampToken token = CMSUtils.getTimeStampToken(attribute);
                    if (token == null || !token.getTimeStampInfo().getGenTime().before(timestampToken.getGenerationTime())) {
                        continue;
                    }
                }
                catch (Exception e) {
                    throw new DSSException(String.format("Unexpected error occurred on reading unsigned properties : %s", e.getMessage()), (Throwable)e);
                }
            }
            result.add(unauthenticatedAttributes.getObjectAt(ii));
        }
        return new DERSequence(result);
    }

    private ASN1Sequence getSignerInfoEncoded(SignerInfo signerInfo, ASN1Sequence unauthenticatedAttributes, boolean includeUnsignedAttrsTagAndLength) {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)signerInfo.getVersion());
        v.add((ASN1Encodable)signerInfo.getSID());
        v.add((ASN1Encodable)signerInfo.getDigestAlgorithm());
        DERTaggedObject signedAttributes = CMSUtils.getDERSignedAttributes(this.signerInformation);
        if (signedAttributes != null) {
            v.add((ASN1Encodable)signedAttributes);
        }
        v.add((ASN1Encodable)signerInfo.getDigestEncryptionAlgorithm());
        v.add((ASN1Encodable)signerInfo.getEncryptedDigest());
        if (unauthenticatedAttributes != null) {
            if (includeUnsignedAttrsTagAndLength) {
                v.add((ASN1Encodable)new DERTaggedObject(false, 1, (ASN1Encodable)unauthenticatedAttributes));
            } else {
                for (int i = 0; i < unauthenticatedAttributes.size(); ++i) {
                    v.add(unauthenticatedAttributes.getObjectAt(i));
                }
            }
        }
        return new DERSequence(v);
    }

    private DSSDocument getOriginalDocument() {
        try {
            return CMSUtils.getOriginalDocument(this.cmsSignedData, this.detachedDocuments);
        }
        catch (DSSException e) {
            LOG.warn("Cannot extract original document! Reason : {}", (Object)e.getMessage());
            return null;
        }
    }
}

