/**
 * DSS - Digital Signature Services
 * Copyright (C) 2015 European Commission, provided under the CEF programme
 * <p>
 * This file is part of the "DSS - Digital Signature Services" project.
 * <p>
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * <p>
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * <p>
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package eu.europa.esig.dss.cades.validation;

import eu.europa.esig.dss.spi.validation.SignatureProperties;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.cms.Attribute;

import java.util.ArrayList;
import java.util.List;

/**
 * Represents a list of {@code CAdESAttribute}s
 */
public abstract class CAdESSigProperties implements SignatureProperties<CAdESAttribute> {

	private static final long serialVersionUID = -1730805576179343914L;

	/** The CMS attribute table set */
	private final ASN1Set asn1Set;

	/**
	 * The default constructor
	 *
	 * @param asn1Set {@link ASN1Set}
	 */
	CAdESSigProperties(final ASN1Set asn1Set) {
		this.asn1Set = asn1Set;
	}

	@Override
	public boolean isExist() {
		return asn1Set != null;
	}

	@Override
	public List<CAdESAttribute> getAttributes() {
		List<CAdESAttribute> attributes = new ArrayList<>();
		if (isExist()) {
			for (int ii = 0; ii < asn1Set.size(); ii++) {
				Attribute attribute = Attribute.getInstance(asn1Set.getObjectAt(ii));
				attributes.add(new CAdESAttribute(attribute, ii));
			}
		}
		return attributes;
	}

}
