/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades;

import eu.europa.esig.dss.cades.signature.CustomMessageDigestCalculatorProvider;
import eu.europa.esig.dss.cades.validation.PrecomputedDigestCalculatorProvider;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.TimestampType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.DigestDocument;
import eu.europa.esig.dss.model.FileDocument;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.OID;
import eu.europa.esig.dss.utils.Utils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Objects;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1UTCTime;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DLSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.Attributes;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.OtherRevocationInfoFormat;
import org.bouncycastle.asn1.cms.SignedData;
import org.bouncycastle.asn1.ess.ESSCertID;
import org.bouncycastle.asn1.ess.ESSCertIDv2;
import org.bouncycastle.asn1.ess.SigningCertificate;
import org.bouncycastle.asn1.ess.SigningCertificateV2;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.IssuerSerial;
import org.bouncycastle.cms.CMSAbsentContent;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSProcessableFile;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.bc.BcDigestCalculatorProvider;
import org.bouncycastle.tsp.TSPException;
import org.bouncycastle.tsp.TimeStampToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CMSUtils {
    private static final Logger LOG = LoggerFactory.getLogger(CMSUtils.class);
    public static final DigestAlgorithm DEFAULT_ARCHIVE_TIMESTAMP_HASH_ALGO = DigestAlgorithm.SHA256;
    private static final Date JANUARY_1950 = DSSUtils.getUtcDate((int)1950, (int)0, (int)1);
    private static final Date JANUARY_2050 = DSSUtils.getUtcDate((int)2050, (int)0, (int)1);
    private static List<ASN1ObjectIdentifier> timestampOids = new ArrayList<ASN1ObjectIdentifier>();

    private CMSUtils() {
    }

    public static CMSSignedData generateCMSSignedData(CMSSignedDataGenerator generator, CMSTypedData content, boolean encapsulate) {
        try {
            return generator.generate(content, encapsulate);
        }
        catch (CMSException e) {
            throw new DSSException("Unable to generate the CMSSignedData", (Throwable)e);
        }
    }

    public static SignerInformationStore generateCounterSigners(CMSSignedDataGenerator cmsSignedDataGenerator, SignerInformation signerInfoToSign) {
        try {
            return cmsSignedDataGenerator.generateCounterSigners(signerInfoToSign);
        }
        catch (CMSException e) {
            throw new DSSException("Unable to generate the SignerInformationStore for the counter-signature", (Throwable)e);
        }
    }

    public static CMSSignedData generateDetachedCMSSignedData(CMSSignedDataGenerator generator, CMSProcessableByteArray content) {
        return CMSUtils.generateCMSSignedData(generator, (CMSTypedData)content, false);
    }

    public static CMSSignedData populateDigestAlgorithmSet(CMSSignedData newCmsSignedData, CMSSignedData oldCmsSignedData) {
        if (oldCmsSignedData != null) {
            for (AlgorithmIdentifier algorithmIdentifier : oldCmsSignedData.getDigestAlgorithmIDs()) {
                newCmsSignedData = CMSUtils.addDigestAlgorithm(newCmsSignedData, algorithmIdentifier);
            }
        }
        return newCmsSignedData;
    }

    public static CMSSignedData addDigestAlgorithm(CMSSignedData cmsSignedData, AlgorithmIdentifier algorithmIdentifier) {
        return CMSSignedData.addDigestAlgorithm((CMSSignedData)cmsSignedData, (AlgorithmIdentifier)algorithmIdentifier);
    }

    public static DERTaggedObject getDERSignedAttributes(SignerInformation signerInformation) {
        try {
            byte[] encodedSignedAttributes = signerInformation.getEncodedSignedAttributes();
            if (encodedSignedAttributes == null) {
                return null;
            }
            ASN1Set asn1Set = (ASN1Set)DSSASN1Utils.toASN1Primitive((byte[])encodedSignedAttributes);
            return new DERTaggedObject(false, 0, (ASN1Encodable)asn1Set);
        }
        catch (IOException e) {
            throw new DSSException(String.format("Unable to extract SignedAttributes. Reason : %s", e.getMessage()), (Throwable)e);
        }
    }

    public static byte[] getSignedContent(CMSTypedData cmsTypedData) {
        byte[] byArray;
        if (cmsTypedData == null) {
            throw new DSSException("CMSTypedData is null (should be a detached signature)");
        }
        ByteArrayOutputStream originalDocumentData = new ByteArrayOutputStream();
        try {
            cmsTypedData.write((OutputStream)originalDocumentData);
            byArray = originalDocumentData.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    originalDocumentData.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | CMSException e) {
                throw new DSSException(e);
            }
        }
        originalDocumentData.close();
        return byArray;
    }

    public static AttributeTable getUnsignedAttributes(SignerInformation signerInformation) {
        AttributeTable unsignedAttributes = signerInformation.getUnsignedAttributes();
        return CMSUtils.emptyIfNull(unsignedAttributes);
    }

    public static AttributeTable getSignedAttributes(SignerInformation signerInformation) {
        AttributeTable signedAttributes = signerInformation.getSignedAttributes();
        return CMSUtils.emptyIfNull(signedAttributes);
    }

    public static AttributeTable getAttributesFromByteArray(byte[] encodedAttributes) {
        DLSet dlSet;
        try (ASN1InputStream asn1InputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(encodedAttributes));){
            dlSet = (DLSet)asn1InputStream.readObject();
        }
        catch (IOException e) {
            throw new DSSException("Error while reading ASN.1 encoded attributes", (Throwable)e);
        }
        return new AttributeTable((ASN1Set)dlSet);
    }

    public static void addSigningCertificateAttribute(ASN1EncodableVector signedAttributes, DigestAlgorithm digestAlgorithm, CertificateToken signingToken) {
        Attribute attribute;
        IssuerSerial issuerSerial = DSSASN1Utils.getIssuerSerial((CertificateToken)signingToken);
        byte[] certHash = signingToken.getDigest(digestAlgorithm);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding Certificate Hash {} with algorithm {}", (Object)Utils.toHex((byte[])certHash), (Object)digestAlgorithm.getName());
        }
        if (digestAlgorithm == DigestAlgorithm.SHA1) {
            ESSCertID essCertID = new ESSCertID(certHash, issuerSerial);
            SigningCertificate signingCertificate = new SigningCertificate(essCertID);
            attribute = new Attribute(PKCSObjectIdentifiers.id_aa_signingCertificate, (ASN1Set)new DERSet((ASN1Encodable)signingCertificate));
        } else {
            ESSCertIDv2 essCertIdv2 = DigestAlgorithm.SHA256 == digestAlgorithm ? new ESSCertIDv2(null, certHash, issuerSerial) : new ESSCertIDv2(DSSASN1Utils.getAlgorithmIdentifier((DigestAlgorithm)digestAlgorithm), certHash, issuerSerial);
            SigningCertificateV2 signingCertificateV2 = new SigningCertificateV2(essCertIdv2);
            attribute = new Attribute(PKCSObjectIdentifiers.id_aa_signingCertificateV2, (ASN1Set)new DERSet((ASN1Encodable)signingCertificateV2));
        }
        signedAttributes.add((ASN1Encodable)attribute);
    }

    public static boolean isCMSSignedDataEqual(CMSSignedData signedData, CMSSignedData signedDataToCompare) throws IOException {
        return Arrays.equals(signedData.getEncoded(), signedDataToCompare.getEncoded());
    }

    public static Attribute getSignedAttribute(SignerInformation signerInformation, ASN1ObjectIdentifier oid) {
        Object[] attributes = CMSUtils.getSignedAttributes(signerInformation, oid);
        if (Utils.isArrayEmpty((Object[])attributes)) {
            return null;
        }
        if (Utils.arraySize((Object[])attributes) > 1) {
            LOG.warn("More than attribute with OID '{}' found in signed attributes table! Value is skipped.", (Object)oid);
            return null;
        }
        return attributes[0];
    }

    public static Attribute[] getSignedAttributes(SignerInformation signerInformation, ASN1ObjectIdentifier oid) {
        AttributeTable attributeTable = CMSUtils.getSignedAttributes(signerInformation);
        return DSSASN1Utils.getAsn1Attributes((AttributeTable)attributeTable, (ASN1ObjectIdentifier)oid);
    }

    public static Attribute getUnsignedAttribute(SignerInformation signerInformation, ASN1ObjectIdentifier oid) {
        Object[] attributes = CMSUtils.getUnsignedAttributes(signerInformation, oid);
        if (Utils.isArrayEmpty((Object[])attributes)) {
            return null;
        }
        if (Utils.arraySize((Object[])attributes) > 1) {
            LOG.warn("More than attribute with OID '{}' found in unsigned attributes table! Value is skipped.", (Object)oid);
            return null;
        }
        return attributes[0];
    }

    public static Attribute[] getUnsignedAttributes(SignerInformation signerInformation, ASN1ObjectIdentifier oid) {
        AttributeTable attributeTable = CMSUtils.getUnsignedAttributes(signerInformation);
        return DSSASN1Utils.getAsn1Attributes((AttributeTable)attributeTable, (ASN1ObjectIdentifier)oid);
    }

    public static boolean isDetachedSignature(CMSSignedData cmsSignedData) {
        return cmsSignedData.isDetachedSignature();
    }

    public static DSSDocument getOriginalDocument(CMSSignedData cmsSignedData, List<DSSDocument> detachedDocuments) {
        Objects.requireNonNull(cmsSignedData, "CMSSignedData shall be provided!");
        CMSTypedData signedContent = cmsSignedData.getSignedContent();
        if (!CMSUtils.isDetachedSignature(cmsSignedData)) {
            if (signedContent == null) {
                throw new DSSException("No signed content found within enveloping CMS signature!");
            }
            return new InMemoryDocument(CMSUtils.getSignedContent(signedContent));
        }
        if (Utils.collectionSize(detachedDocuments) == 1) {
            return detachedDocuments.get(0);
        }
        throw new DSSException("Detached content is not provided or cannot be identified (only one document shall be provided)!");
    }

    public static CMSTypedData getContentToBeSigned(DSSDocument toSignData) {
        CMSAbsentContent content;
        Objects.requireNonNull(toSignData, "Document to be signed is missing");
        if (toSignData instanceof DigestDocument) {
            content = new CMSAbsentContent();
        } else if (toSignData instanceof FileDocument) {
            FileDocument fileDocument = (FileDocument)toSignData;
            content = new CMSProcessableFile(fileDocument.getFile());
        } else {
            content = new CMSProcessableByteArray(DSSUtils.toByteArray((DSSDocument)toSignData));
        }
        return content;
    }

    public static DigestCalculatorProvider getDigestCalculatorProvider(DSSDocument toSignDocument, DigestAlgorithm digestAlgorithm) {
        if (digestAlgorithm != null) {
            return new CustomMessageDigestCalculatorProvider(digestAlgorithm, toSignDocument.getDigestValue(digestAlgorithm));
        }
        if (toSignDocument instanceof DigestDocument) {
            return new PrecomputedDigestCalculatorProvider((DigestDocument)toSignDocument);
        }
        return new BcDigestCalculatorProvider();
    }

    public static boolean containsATSTv2(SignerInformation signerInformation) {
        Attribute[] attributes;
        AttributeTable unsignedAttributes = CMSUtils.getUnsignedAttributes(signerInformation);
        for (Attribute attribute : attributes = unsignedAttributes.toASN1Structure().getAttributes()) {
            if (!CMSUtils.isAttributeOfType(attribute, OID.id_aa_ets_archiveTimestampV2)) continue;
            return true;
        }
        return false;
    }

    public static Date readSigningDate(ASN1Encodable attrValue) {
        if (attrValue != null) {
            Date signingDate = DSSASN1Utils.getDate((ASN1Encodable)attrValue);
            if (signingDate != null) {
                if (signingDate.compareTo(JANUARY_1950) >= 0 && signingDate.before(JANUARY_2050) && !(attrValue.toASN1Primitive() instanceof ASN1UTCTime)) {
                    LOG.warn("RFC 3852 states that dates between January 1, 1950 and December 31, 2049 (inclusive) MUST be encoded as UTCTime. Any dates with year values before 1950 or after 2049 MUST be encoded as GeneralizedTime. Date found is {} encoded as {}", (Object)signingDate, (Object)attrValue.getClass());
                    return null;
                }
                return signingDate;
            }
            LOG.warn("Error when reading signing time. Unrecognized {}", (Object)attrValue.getClass());
        }
        return null;
    }

    public static List<TimeStampToken> findArchiveTimeStampTokens(AttributeTable unsignedAttributes) {
        Attribute[] attributes;
        ArrayList<TimeStampToken> timeStamps = new ArrayList<TimeStampToken>();
        for (Attribute attribute : attributes = unsignedAttributes.toASN1Structure().getAttributes()) {
            TimeStampToken timeStampToken;
            if (!CMSUtils.isArchiveTimeStampToken(attribute) || (timeStampToken = CMSUtils.getTimeStampToken(attribute)) == null) continue;
            timeStamps.add(timeStampToken);
        }
        return timeStamps;
    }

    public static List<ASN1ObjectIdentifier> getTimestampOids() {
        return timestampOids;
    }

    public static boolean isArchiveTimeStampToken(Attribute attribute) {
        ASN1ObjectIdentifier attrOid = attribute.getAttrType();
        if (attrOid != null) {
            return TimestampType.ARCHIVE_TIMESTAMP == CMSUtils.getTimestampTypeByOid(attrOid);
        }
        return false;
    }

    public static TimestampType getTimestampTypeByOid(ASN1ObjectIdentifier oid) {
        if (PKCSObjectIdentifiers.id_aa_ets_contentTimestamp.equals((ASN1Primitive)oid)) {
            return TimestampType.CONTENT_TIMESTAMP;
        }
        if (PKCSObjectIdentifiers.id_aa_signatureTimeStampToken.equals((ASN1Primitive)oid)) {
            return TimestampType.SIGNATURE_TIMESTAMP;
        }
        if (PKCSObjectIdentifiers.id_aa_ets_certCRLTimestamp.equals((ASN1Primitive)oid)) {
            return TimestampType.VALIDATION_DATA_REFSONLY_TIMESTAMP;
        }
        if (PKCSObjectIdentifiers.id_aa_ets_escTimeStamp.equals((ASN1Primitive)oid)) {
            return TimestampType.VALIDATION_DATA_TIMESTAMP;
        }
        if (OID.id_aa_ets_archiveTimestampV2.equals((ASN1Primitive)oid) || OID.id_aa_ets_archiveTimestampV3.equals((ASN1Primitive)oid)) {
            return TimestampType.ARCHIVE_TIMESTAMP;
        }
        return null;
    }

    public static ASN1Sequence getAtsHashIndex(AttributeTable timestampUnsignedAttributes) {
        ASN1ObjectIdentifier atsHashIndexVersionIdentifier = CMSUtils.getAtsHashIndexVersionIdentifier(timestampUnsignedAttributes);
        return CMSUtils.getAtsHashIndexByVersion(timestampUnsignedAttributes, atsHashIndexVersionIdentifier);
    }

    public static ASN1Sequence getCertificatesHashIndex(ASN1Sequence atsHashIndexValue) {
        if (atsHashIndexValue != null) {
            int certificateIndex = 0;
            if (atsHashIndexValue.size() > 3) {
                ++certificateIndex;
            }
            return (ASN1Sequence)atsHashIndexValue.getObjectAt(certificateIndex).toASN1Primitive();
        }
        return null;
    }

    public static ASN1Sequence getCRLHashIndex(ASN1Sequence atsHashIndexValue) {
        if (atsHashIndexValue != null) {
            int crlIndex = 1;
            if (atsHashIndexValue.size() > 3) {
                ++crlIndex;
            }
            return (ASN1Sequence)atsHashIndexValue.getObjectAt(crlIndex).toASN1Primitive();
        }
        return null;
    }

    public static ASN1Sequence getUnsignedAttributesHashIndex(ASN1Sequence atsHashIndexValue) {
        if (atsHashIndexValue != null) {
            int unsignedAttributesIndex = 2;
            if (atsHashIndexValue.size() > 3) {
                ++unsignedAttributesIndex;
            }
            return (ASN1Sequence)atsHashIndexValue.getObjectAt(unsignedAttributesIndex).toASN1Primitive();
        }
        return null;
    }

    public static ASN1Sequence getAtsHashIndexByVersion(AttributeTable timestampUnsignedAttributes, ASN1ObjectIdentifier atsHashIndexVersionIdentifier) {
        ASN1Set attrValues;
        Object atsHashIndexAttribute;
        Object[] attributes;
        if (timestampUnsignedAttributes != null && atsHashIndexVersionIdentifier != null && Utils.arraySize((Object[])(attributes = DSSASN1Utils.getAsn1Attributes((AttributeTable)timestampUnsignedAttributes, (ASN1ObjectIdentifier)atsHashIndexVersionIdentifier))) == 1 && (atsHashIndexAttribute = attributes[0]) != null && (attrValues = atsHashIndexAttribute.getAttrValues()) != null && attrValues.size() == 1) {
            return (ASN1Sequence)attrValues.getObjectAt(0).toASN1Primitive();
        }
        return null;
    }

    public static ASN1ObjectIdentifier getAtsHashIndexVersionIdentifier(AttributeTable timestampUnsignedAttributes) {
        if (timestampUnsignedAttributes != null) {
            Attributes attributes = timestampUnsignedAttributes.toASN1Structure();
            for (Attribute attribute : attributes.getAttributes()) {
                ASN1ObjectIdentifier attrType = attribute.getAttrType();
                if (!OID.id_aa_ATSHashIndex.equals((ASN1Primitive)attrType) && !OID.id_aa_ATSHashIndexV2.equals((ASN1Primitive)attrType) && !OID.id_aa_ATSHashIndexV3.equals((ASN1Primitive)attrType)) continue;
                LOG.debug("Unsigned attribute of type [{}] found in the timestamp.", (Object)attrType);
                return attrType;
            }
            LOG.warn("The timestamp unsignedAttributes does not contain ATSHashIndex!");
        }
        return null;
    }

    public static List<byte[]> getOctetStringForAtsHashIndex(Attribute attribute, ASN1ObjectIdentifier atsHashIndexVersionIdentifier) {
        if (OID.id_aa_ATSHashIndexV3.equals((ASN1Primitive)atsHashIndexVersionIdentifier)) {
            return CMSUtils.getATSHashIndexV3OctetString(attribute.getAttrType(), attribute.getAttrValues());
        }
        return Collections.singletonList(DSSASN1Utils.getDEREncoded((ASN1Encodable)attribute));
    }

    public static List<byte[]> getATSHashIndexV3OctetString(ASN1ObjectIdentifier attributeIdentifier, ASN1Set attributeValues) {
        ArrayList<byte[]> octets = new ArrayList<byte[]>();
        byte[] attrType = DSSASN1Utils.getDEREncoded((ASN1Encodable)attributeIdentifier);
        for (ASN1Encodable asn1Encodable : attributeValues.toArray()) {
            octets.add(Utils.concat((byte[][])new byte[][]{attrType, DSSASN1Utils.getDEREncoded((ASN1Encodable)asn1Encodable)}));
        }
        return octets;
    }

    public static boolean isEmpty(AttributeTable attributeTable) {
        return attributeTable == null || attributeTable.size() == 0;
    }

    public static AttributeTable emptyIfNull(AttributeTable originalAttributeTable) {
        if (originalAttributeTable != null) {
            return originalAttributeTable;
        }
        return new AttributeTable(new Hashtable());
    }

    public static boolean isAttributeOfType(Attribute attribute, ASN1ObjectIdentifier asn1ObjectIdentifier) {
        if (attribute == null) {
            return false;
        }
        ASN1ObjectIdentifier objectIdentifier = attribute.getAttrType();
        return asn1ObjectIdentifier.equals((ASN1Primitive)objectIdentifier);
    }

    public static TimeStampToken getTimeStampToken(Attribute attribute) {
        try {
            CMSSignedData signedData = CMSUtils.getCMSSignedData(attribute);
            if (signedData != null) {
                return new TimeStampToken(signedData);
            }
        }
        catch (IOException | CMSException | TSPException e) {
            LOG.warn("The given TimeStampToken cannot be created! Reason: [{}]", (Object)e.getMessage());
        }
        return null;
    }

    public static CMSSignedData getCMSSignedData(Attribute attribute) throws CMSException, IOException {
        ASN1Encodable value = CMSUtils.getAsn1Encodable(attribute);
        if (!(value instanceof DEROctetString)) {
            ASN1Primitive asn1Primitive = value.toASN1Primitive();
            return new CMSSignedData(asn1Primitive.getEncoded());
        }
        LOG.warn("Illegal content for CMSSignedData (OID : {}) : OCTET STRING is not allowed !", (Object)attribute.getAttrType());
        return null;
    }

    public static ASN1ObjectIdentifier getEncapsulatedContentType(CMSSignedData cmsSignedData) {
        ContentInfo contentInfo = cmsSignedData.toASN1Structure();
        SignedData signedData = SignedData.getInstance((Object)contentInfo.getContent());
        return signedData.getEncapContentInfo().getContentType();
    }

    public static byte[] getSignedDataEncodedOCSPResponse(byte[] binaries, ASN1ObjectIdentifier objectIdentifier) {
        OtherRevocationInfoFormat otherRevocationInfoFormat = new OtherRevocationInfoFormat(objectIdentifier, (ASN1Encodable)DSSASN1Utils.toASN1Primitive((byte[])binaries));
        DERTaggedObject derTaggedObject = new DERTaggedObject(false, 1, (ASN1Encodable)otherRevocationInfoFormat);
        return DSSASN1Utils.getDEREncoded((ASN1Encodable)derTaggedObject);
    }

    public static ASN1Encodable getAsn1Encodable(Attribute attribute) {
        return attribute.getAttrValues().getObjectAt(0);
    }

    static {
        timestampOids.add(PKCSObjectIdentifiers.id_aa_ets_contentTimestamp);
        timestampOids.add(OID.id_aa_ets_archiveTimestampV2);
        timestampOids.add(OID.id_aa_ets_archiveTimestampV3);
        timestampOids.add(PKCSObjectIdentifiers.id_aa_ets_certCRLTimestamp);
        timestampOids.add(PKCSObjectIdentifiers.id_aa_ets_escTimeStamp);
        timestampOids.add(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken);
    }
}

