/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.signature;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.utils.Utils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomMessageDigestCalculatorProvider
implements DigestCalculatorProvider {
    private static final Logger LOG = LoggerFactory.getLogger(CustomMessageDigestCalculatorProvider.class);
    private final DigestAlgorithm messageDigestAlgo;
    private final byte[] messageDigestValue;

    public CustomMessageDigestCalculatorProvider(DigestAlgorithm messageDigestAlgo, byte[] messageDigestValue) {
        Objects.requireNonNull(messageDigestAlgo, "DigestAlgorithm shall be defined!");
        Objects.requireNonNull(messageDigestValue, "Digest value shall be defined!");
        this.messageDigestAlgo = messageDigestAlgo;
        this.messageDigestValue = messageDigestValue;
    }

    public DigestCalculator get(AlgorithmIdentifier digestAlgorithmIdentifier) throws OperatorCreationException {
        LOG.info("message-digest algorithm is set with {}", (Object)this.messageDigestAlgo);
        return new DigestCalculator(){

            public OutputStream getOutputStream() {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                try {
                    Utils.write((byte[])this.getDigest(), (OutputStream)os);
                }
                catch (IOException e) {
                    throw new DSSException("Unable to get outputstream", (Throwable)e);
                }
                return os;
            }

            public byte[] getDigest() {
                return CustomMessageDigestCalculatorProvider.this.messageDigestValue;
            }

            public AlgorithmIdentifier getAlgorithmIdentifier() {
                return new AlgorithmIdentifier(new ASN1ObjectIdentifier(CustomMessageDigestCalculatorProvider.this.messageDigestAlgo.getOid()));
            }
        };
    }
}

