/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.validation;

import eu.europa.esig.dss.cades.validation.CAdESSignature;
import eu.europa.esig.dss.model.ManifestFile;
import eu.europa.esig.dss.spi.signature.AdvancedSignature;
import eu.europa.esig.dss.spi.signature.identifier.AbstractSignatureIdentifierBuilder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Collection;
import org.bouncycastle.cms.SignerInformation;

public class CAdESSignatureIdentifierBuilder
extends AbstractSignatureIdentifierBuilder {
    private static final long serialVersionUID = -7828439853620987517L;

    public CAdESSignatureIdentifierBuilder(CAdESSignature signature) {
        super((AdvancedSignature)signature);
    }

    protected void writeSignedProperties(ByteArrayOutputStream baos) throws IOException {
        super.writeSignedProperties(baos);
        this.writeString(baos, this.getManifestFilename());
    }

    private String getManifestFilename() {
        ManifestFile manifestFile = this.signature.getManifestFile();
        if (manifestFile != null) {
            return manifestFile.getFilename();
        }
        return null;
    }

    protected Integer getCounterSignaturePosition(AdvancedSignature masterSignature) {
        CAdESSignature cadesSignature = (CAdESSignature)this.signature;
        CAdESSignature cadesMasterSignature = (CAdESSignature)masterSignature;
        return this.count(cadesMasterSignature.getCounterSignatureStore().getSigners(), cadesSignature.getSignerInformation());
    }

    protected Integer getSignaturePosition() {
        CAdESSignature cadesSignature = (CAdESSignature)this.signature;
        return this.count(cadesSignature.getCmsSignedData().getSignerInfos().getSigners(), cadesSignature.getSignerInformation());
    }

    private Integer count(Collection<SignerInformation> signerInformationStore, SignerInformation currentSignerInformation) {
        int counter = 0;
        for (SignerInformation signerInformation : signerInformationStore) {
            if (currentSignerInformation == signerInformation) break;
            ++counter;
        }
        return counter;
    }
}

